/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network.http;

import android.support.annotation.Nullable;
import com.taboola.android.global_components.network.http.HttpManager;
import com.taboola.android.global_components.network.http.HttpRequest;
import com.taboola.android.global_components.network.http.Request;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import org.json.JSONObject;

class HttpPost
extends HttpRequest {
    public HttpPost(int configuredTimeout) {
        super(configuredTimeout);
    }

    void post(String url, @Nullable JSONObject jsonBody, @Nullable HttpManager.NetworkResponse networkResponse) {
        this.performRequsetOnBackgroundThread(new Request(url, jsonBody), networkResponse);
    }

    @Override
    void protocolSpecificConnectionSetup(HttpURLConnection httpUrlConnection, Request request) throws IOException {
        httpUrlConnection.setRequestMethod("POST");
        httpUrlConnection.setDoInput(true);
        httpUrlConnection.setDoOutput(true);
        this.addJsonBody(httpUrlConnection, request);
    }

    private void addJsonBody(HttpURLConnection httpUrlConnection, Request request) throws IOException {
        JSONObject jsonBody = request.getJsonBody();
        if (jsonBody != null && jsonBody.length() > 0) {
            DataOutputStream writer = new DataOutputStream(httpUrlConnection.getOutputStream());
            writer.writeBytes(jsonBody.toString());
            writer.flush();
            writer.close();
        }
    }
}

