/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.monitor;

import android.text.TextUtils;
import android.util.SparseArray;
import com.taboola.android.monitor.TBAuthentication;
import com.taboola.android.monitor.TBMobileLoaderChange;
import com.taboola.android.monitor.TBNetworkMonitoring;
import com.taboola.android.monitor.TBSimCodeChange;
import com.taboola.android.monitor.TBSuspendMonitor;
import com.taboola.android.monitor.TBUrlParamsChange;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.PropertiesHashed;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class TBSdkFeature
implements Serializable {
    private static final String TAG = "TBSdkFeature";
    private final int sdkFeatureType;

    TBSdkFeature(int type) {
        this.sdkFeatureType = type;
    }

    protected void initFromJSON(JSONObject sdkFeaturesJsonObject) {
    }

    public Integer getKey() {
        return this.sdkFeatureType;
    }

    public static SparseArray<TBSdkFeature> parseSdkFeatures(String sdkFeaturesString) {
        return Parser.parseSdkFeatures(sdkFeaturesString);
    }

    private static class Parser {
        static List<Class<? extends TBSdkFeature>> CLASS_LIST = new ArrayList<Class<? extends TBSdkFeature>>();

        private Parser() {
        }

        private static SparseArray<TBSdkFeature> parseSdkFeatures(String sdkFeaturesString) {
            SparseArray sdkFeatures = new SparseArray();
            boolean isAuthenticated = false;
            try {
                JSONObject sdkFeaturesJsonObject = new JSONObject(sdkFeaturesString);
                for (Class<? extends TBSdkFeature> clazz : CLASS_LIST) {
                    Parser.setFeature(sdkFeaturesJsonObject, clazz, (SparseArray<TBSdkFeature>)sdkFeatures);
                }
                TBAuthentication tbAuthentication = (TBAuthentication)sdkFeatures.get(0);
                String password = tbAuthentication != null ? tbAuthentication.getPassword() : "";
                String keyHash = PropertiesHashed.md5(password).toLowerCase();
                isAuthenticated = TextUtils.equals((CharSequence)"11c40e426d7db9502e87c014a217785b", (CharSequence)keyHash);
            }
            catch (Exception e) {
                Logger.e(TBSdkFeature.TAG, e.toString(), e);
            }
            if (!isAuthenticated) {
                sdkFeatures.clear();
                TBSuspendMonitor tbSuspendMonitor = new TBSuspendMonitor();
                tbSuspendMonitor.setShouldSuspend(true);
                sdkFeatures.put(2, (Object)tbSuspendMonitor);
            }
            return sdkFeatures;
        }

        private static void setFeature(JSONObject jsonObject, Class<? extends TBSdkFeature> clazz, SparseArray<TBSdkFeature> sdkFeatures) {
            try {
                int keyInt = clazz.getField("KEY").getInt(null);
                JSONObject sdkFeatureJsonObject = jsonObject.optJSONObject(String.valueOf(keyInt));
                if (sdkFeatureJsonObject != null) {
                    TBSdkFeature tbSdkFeature = clazz.newInstance();
                    tbSdkFeature.initFromJSON(sdkFeatureJsonObject);
                    sdkFeatures.put(keyInt, (Object)tbSdkFeature);
                }
            }
            catch (Exception e) {
                Logger.e(TBSdkFeature.TAG, e.toString(), e);
            }
        }

        static {
            CLASS_LIST.add(TBAuthentication.class);
            CLASS_LIST.add(TBMobileLoaderChange.class);
            CLASS_LIST.add(TBSuspendMonitor.class);
            CLASS_LIST.add(TBUrlParamsChange.class);
            CLASS_LIST.add(TBNetworkMonitoring.class);
            CLASS_LIST.add(TBSimCodeChange.class);
        }
    }
}

