/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.testing;

import android.os.Build;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.integration_verifier.testing.TEST_ID;
import com.taboola.android.integration_verifier.testing.VerificationTest;
import com.taboola.android.integration_verifier.testing.tests.AlertReleaseVerificationTest;
import com.taboola.android.integration_verifier.testing.tests.CrawlingUrlVerificationTest;
import com.taboola.android.integration_verifier.testing.tests.InitFirstVerificationTest;
import com.taboola.android.integration_verifier.testing.tests.PermissionsVerificationTest;
import com.taboola.android.integration_verifier.testing.tests.ProguardVerificationTest;
import com.taboola.android.integration_verifier.testing.tests.PublisherConfigurationVerificationMandatoryTest;
import com.taboola.android.integration_verifier.testing.tests.PublisherConfigurationVerificationOptionalTest;
import com.taboola.android.integration_verifier.testing.tests.SdkVersionVerificationTest;
import com.taboola.android.integration_verifier.testing.tests.init_order.MethodCallOrderTracker;
import com.taboola.android.integration_verifier.utility.IVLogger;
import com.taboola.android.integration_verifier.utility.IntegrationTypeNameParser;
import com.taboola.android.integration_verifier.utility.StatusReport;
import java.util.Hashtable;

public class TestsManager {
    private Hashtable<Integer, VerificationTest> testsTable;
    private MethodCallOrderTracker methodCallOrderTracker = new MethodCallOrderTracker();
    private NetworkManager networkManager;
    private StatusReport statusReport = new StatusReport();

    public TestsManager(NetworkManager networkManager) {
        this.networkManager = networkManager;
        this.buildTestsTable();
    }

    private void buildTestsTable() {
        this.testsTable = new Hashtable();
        this.addVerificationTest(new PermissionsVerificationTest(2, true));
        this.addVerificationTest(new ProguardVerificationTest(3, true));
        this.addVerificationTest(new InitFirstVerificationTest(4, false, this.methodCallOrderTracker));
        this.addVerificationTest(new SdkVersionVerificationTest(5, false, this.networkManager));
        this.addVerificationTest(new PublisherConfigurationVerificationMandatoryTest(6, true));
        this.addVerificationTest(new PublisherConfigurationVerificationOptionalTest(7, false));
        this.addVerificationTest(new CrawlingUrlVerificationTest(8, false, this.networkManager));
        this.addVerificationTest(new AlertReleaseVerificationTest(9, true));
    }

    private void addVerificationTest(VerificationTest verificationTest) {
        IVLogger.log("TestsManager | addVerificationTest() | New VerificationTest add request: " + TEST_ID.class.getSimpleName());
        int key_id = verificationTest.getId();
        if (Build.VERSION.SDK_INT >= 24) {
            this.testsTable.putIfAbsent(key_id, verificationTest);
        } else if (!this.testsTable.containsKey(key_id)) {
            this.testsTable.put(key_id, verificationTest);
        }
    }

    public VerificationTest getVerificationTest(int id2) {
        return this.testsTable.get(id2);
    }

    public void setNetworkManagerAndRebuildTestsTable(NetworkManager networkManager) {
        this.networkManager = networkManager;
        this.testsTable.clear();
        this.buildTestsTable();
    }

    public MethodCallOrderTracker getMethodCallOrderTracker() {
        return this.methodCallOrderTracker;
    }

    public void addToStatusReport(int integrationType, VerificationTest verificationTest, String status) {
        this.statusReport.appendStatus(String.format("IntegrationType: %s | Name: %s | Result: %s.", IntegrationTypeNameParser.getNameFor(integrationType), verificationTest.getClass().getSimpleName(), status));
    }

    public void logStatusReport() {
        this.statusReport.logStatusReport();
    }

    public void clearStatusReport() {
        this.statusReport.clearStatusReport();
    }
}

