/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.network.handlers;

import android.os.Bundle;
import com.taboola.android.integration_verifier.network.VerifierHttpManager;
import com.taboola.android.integration_verifier.utility.IVLoggedException;
import com.taboola.android.integration_verifier.utility.IVLogger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class KibanaHandler {
    private static final String KIBANA_BASE_URL = "https://vidanalytics.taboola.com";
    private static final String KIBANA_MOBILE_SUFFIX = "/putes";
    private static final String KIBANA_INDEX_SUFFIX = "/sdk_verifier";
    public static final String KIBANA_KEY_VERIFIER_TIMESTAMP = "timestamp";
    public static final String KIBANA_KEY_VERIFIER_SDK_TYPE = "sdk_type";
    public static final String KIBANA_KEY_VERIFIER_SDK_VERSION = "sdk_version";
    public static final String KIBANA_KEY_VERIFIER_PUBLISHER_ID = "publisher_id";
    public static final String KIBANA_KEY_VERIFIER_TEST_NAME = "test_name";
    public static final String KIBANA_KEY_VERIFIER_IS_MANDATORY = "is_mandatory";
    public static final String KIBANA_KEY_VERIFIER_TEST_OUTPUT = "test_output";
    public static final String KIBANA_KEY_VERIFIER_SESSION_ID = "session_id";

    public void sendVerificationFailedReport(VerifierHttpManager verifierHttpManager, Bundle bundle, VerifierHttpManager.NetworkResponse networkResponse) {
        verifierHttpManager.post("https://vidanalytics.taboola.com/putes/sdk_verifier", this.getVerificationFailedReportJson(bundle), networkResponse);
    }

    private JSONObject getVerificationFailedReportJson(Bundle bundle) {
        JSONObject jsonReportBody = new JSONObject();
        try {
            jsonReportBody.put(KIBANA_KEY_VERIFIER_TIMESTAMP, (Object)this.getISO8601currentTime());
            jsonReportBody.put(KIBANA_KEY_VERIFIER_SDK_VERSION, (Object)"2.1.2-40172-8");
            jsonReportBody.put(KIBANA_KEY_VERIFIER_SDK_TYPE, (Object)bundle.getString(KIBANA_KEY_VERIFIER_SDK_TYPE));
            jsonReportBody.put(KIBANA_KEY_VERIFIER_TEST_NAME, (Object)bundle.getString(KIBANA_KEY_VERIFIER_TEST_NAME));
            jsonReportBody.put(KIBANA_KEY_VERIFIER_IS_MANDATORY, bundle.getBoolean(KIBANA_KEY_VERIFIER_IS_MANDATORY));
            jsonReportBody.put(KIBANA_KEY_VERIFIER_TEST_OUTPUT, (Object)bundle.getString(KIBANA_KEY_VERIFIER_TEST_OUTPUT));
            jsonReportBody.put(KIBANA_KEY_VERIFIER_PUBLISHER_ID, (Object)bundle.getString(KIBANA_KEY_VERIFIER_PUBLISHER_ID));
            jsonReportBody.put(KIBANA_KEY_VERIFIER_SESSION_ID, (Object)bundle.getString(KIBANA_KEY_VERIFIER_SESSION_ID));
        }
        catch (JSONException e) {
            throw new IVLoggedException("KibanaHandler | sendReport() | KibanaHandler | getReportJson | " + e.getLocalizedMessage());
        }
        IVLogger.log("KibanaHandler | sendReport() | KibanaHandler | getReportJson | jsonReportBody: " + jsonReportBody.toString());
        return jsonReportBody;
    }

    private String getISO8601currentTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(new Date());
    }
}

