/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.testing.tests;

import android.content.Context;
import android.os.Bundle;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.global_components.network.http.HttpManager;
import com.taboola.android.integration_verifier.testing.VerificationTest;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTarget;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTargets;
import com.taboola.android.integration_verifier.testing.tests.crawl_urls.CrawlUrlBlacklist;
import com.taboola.android.integration_verifier.utility.IVLogger;
import com.taboola.android.integration_verifier.utility.IntegrationTypeNameParser;

public class CrawlingUrlVerificationTest
extends VerificationTest {
    private static final String TEST_NAME = "CrawlingUrlVerification";
    private static final String ON_FAIL_ERROR_MESSAGE = "CrawlingUrlVerificationTest | Test failed: %s.";
    private static final String INTERNET_PERMISSION = "android.permission.INTERNET";
    public static final String KEY_CRAWLING_URL = "crawlingUrlTest_key_crawling_url";
    public static final String KEY_CONFIGURATION_PARAMS_CRAWL_PAGE_URL = "config_pageurl";
    private NetworkManager networkManager;
    private String failReason;

    public CrawlingUrlVerificationTest(int id, boolean isMandatory, NetworkManager networkManager) {
        super(id, isMandatory);
        this.networkManager = networkManager;
    }

    @Override
    public void execute(@Nullable Context context, @Nullable Bundle bundle, @NonNull VerificationTest.TestResults testResults) {
        if (context == null || context.checkPermission(INTERNET_PERMISSION, Process.myPid(), Process.myUid()) != 0) {
            IVLogger.log("CrawlingUrlVerificationTest | execute | context is null");
            testResults.onUnavailable();
            return;
        }
        this.isCrawlingUrlValid(testResults, bundle.getString(KEY_CRAWLING_URL));
    }

    private void isCrawlingUrlValid(final VerificationTest.TestResults testResults, String crawlingUrl) {
        IVLogger.log("CrawlingUrlVerificationTest | execute | isCrawlingUrlValid | crawlingUrl = " + crawlingUrl);
        if (TextUtils.isEmpty((CharSequence)crawlingUrl)) {
            IVLogger.log("CrawlingUrlVerificationTest | execute | isCrawlingUrlValid | Crawling url is empty or null.");
            this.failReason = "No source page url added, did you forget to add it?";
            testResults.onFail(this.isMandatory());
            return;
        }
        CrawlUrlBlacklist crawlUrlBlacklist = new CrawlUrlBlacklist();
        if (crawlUrlBlacklist.isUrlInBlackList(crawlingUrl)) {
            IVLogger.log("CrawlingUrlVerificationTest | execute | isCrawlingUrlValid | Crawling url is blacklisted.");
            this.failReason = crawlUrlBlacklist.getFailMessage();
            testResults.onFail(this.isMandatory());
            return;
        }
        this.networkManager.getGenericHandler().isUrlReachableOk(crawlingUrl, new HttpManager.NetworkResponse(){

            @Override
            public void onResponse(String response) {
                IVLogger.log("CrawlingUrlVerificationTest | execute | isCrawlingUrlValid | Crawling url is reachable.");
                testResults.onSuccess();
            }

            @Override
            public void onError(String error) {
                IVLogger.log("CrawlingUrlVerificationTest | execute | isCrawlingUrlValid | Crawling url is unreachable. error = " + error);
                CrawlingUrlVerificationTest.this.failReason = String.format("CrawlingUrlVerificationTest | execute | isUrlReachableOk | Taboola failed opening the page url you entered, reason: %s ", error);
                testResults.onFail(CrawlingUrlVerificationTest.this.isMandatory());
            }
        });
    }

    @Override
    public VerificationOutputTargets getVerificationOutputTargets(@Nullable Bundle bundle) {
        VerificationOutputTargets verificationOutputTargets = new VerificationOutputTargets(new VerificationOutputTarget[0]);
        Bundle consoleBundle = new Bundle();
        String failMessage = String.format(ON_FAIL_ERROR_MESSAGE, this.failReason);
        consoleBundle.putString("consoleOutput_key_log_error_string", failMessage);
        verificationOutputTargets.add(new VerificationOutputTarget(2, consoleBundle));
        verificationOutputTargets.add(new VerificationOutputTarget(3, this.getKibanaBundle(IntegrationTypeNameParser.getNameFor(bundle.getInt("integration_verifier_key_integrationType")), TEST_NAME, failMessage)));
        return verificationOutputTargets;
    }
}

