/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.integration_verifier.testing;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taboola.android.integration_verifier.IntegrationVerifier;
import com.taboola.android.integration_verifier.testing.output_connector.VerificationOutputTargets;
import com.taboola.android.integration_verifier.utility.SessionData;

public abstract class VerificationTest {
    private int id;
    private boolean isMandatory;

    public VerificationTest(int id, boolean isMandatory) {
        this.id = id;
        this.isMandatory = isMandatory;
    }

    public int getId() {
        return this.id;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public Bundle getKibanaBundle(String integrationType, String testName, String testOutput) {
        SessionData sessionData = IntegrationVerifier.getInstance().getSessionData();
        Bundle kibanaBundle = new Bundle();
        kibanaBundle.putString("sdk_type", integrationType);
        kibanaBundle.putString("test_name", testName);
        kibanaBundle.putBoolean("is_mandatory", this.isMandatory);
        kibanaBundle.putString("test_output", testOutput);
        kibanaBundle.putString("publisher_id", sessionData.getPublisherId());
        kibanaBundle.putString("session_id", sessionData.getSessionId());
        return kibanaBundle;
    }

    public abstract void execute(@Nullable Context var1, @Nullable Bundle var2, @NonNull TestResults var3);

    public abstract VerificationOutputTargets getVerificationOutputTargets(@Nullable Bundle var1);

    public static interface TestResults {
        public void onSuccess();

        public void onFail(boolean var1);

        public void onUnavailable();
    }
}

