/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.api;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.Messenger;
import android.support.annotation.Keep;
import android.support.annotation.MainThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.taboola.android.MonitorManager;
import com.taboola.android.api.KibanaApiClient;
import com.taboola.android.api.KibanaApiService;
import com.taboola.android.api.RetrofitClient;
import com.taboola.android.api.TBImageErrorListener;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBPlacementRequest;
import com.taboola.android.api.TBRecommendationRequestCallback;
import com.taboola.android.api.TBRecommendationsRequest;
import com.taboola.android.api.TBRecommendationsResponse;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.api.TaboolaOnClickListener;
import com.taboola.android.api.TestHelperInternal;
import com.taboola.android.monitor.TBUrlParamsChange;
import com.taboola.android.utils.AdvertisingIdClient;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.MonitorUtils;
import com.taboola.android.utils.OnClickHelper;
import com.taboola.android.utils.PopupHelper;
import com.taboola.android.utils.PropertiesHashed;
import com.taboola.android.utils.RequestUtil;
import com.taboola.android.utils.SdkDetailsHelper;
import com.taboola.android.utils.SharedPrefUtil;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import okhttp3.HttpUrl;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Keep
public class TBPublisherApi {
    private static final String TAG = "TBPublisherApi";
    private static final String REQUEST_ID_KEY = "req_id";
    private static final String PUBLISHER_ID = "PublisherId";
    private static final String API_KEY = "apiKey";
    private static final String ADDITIONAL_DATA = "additional_data";
    private static final String TIMESTAMP = "timestamp";
    private static final String EVENT = "event";
    private static final String SHOULD_ALLOW_NON_ORGANIC_CLICK_OVERRIDE = "mShouldAllowNonOrganicClickOverride";
    private static final String IS_ENABLED_RAW_DATA_RESPONSE = "mIsEnabledRawDataResponse";
    private static final String USE_HTTP = "mUseHttp";
    private static final String API_PARAMS = "mApiParams";
    private static final String MOBILE_INIT = "mobileInit";
    private static final String RESPONSE_ID = "response.id";
    private static final String RESPONSE_SESSION = "response.session";
    private static final String APP_TYPE = "app.type";
    private static final String MOBILE = "mobile";
    private static final String APP_APIKEY = "app.apikey";
    private static final String ITEM_TYPE = "item.type";
    private static final String ITEM_ID = "item.id";
    private static final String DEVICE = "device";
    private static final String EVENT_DATA = "event.data";
    public static final String TABOOLA_HOST = "taboola.com";
    private final Object mUserSessionLock = new Object();
    private int onClickIgnoreTimeMs = 300;
    private static final String BASE_URL = "://api.taboola.com/1.2/json/";
    private static final String HTTP_PREFIX = "http";
    private static final String HTTPS_PREFIX = "https";
    @Nullable
    private String mAdvertisingId = null;
    private String mPublisherId;
    private String apiKey;
    private boolean mShouldAllowNonOrganicClickOverride = false;
    private boolean mIsEnabledRawDataResponse = false;
    private boolean mIsEnabledFullRawDataResponse = false;
    private boolean mUseHttp = false;
    private Map<String, String> mApiParams;
    private Handler mVisibilityMonitoringHandler = new Handler(Looper.getMainLooper());
    private Map<String, TBRecommendationsRequest> mRequestMap = new HashMap<String, TBRecommendationsRequest>();
    private Drawable mImagePlaceholderDrawable;
    private TaboolaOnClickListener mOnClickListener;
    private TestHelperInternal.SdkEventsTestListener mSdkEventsTestListener;
    private RetrofitClient mRetrofitClient;
    private SimpleDateFormat mDefaultSdf;
    private SimpleDateFormat mReportEventDateFormat;
    private Handler mUiHandler;
    private TaboolaApi mTaboolaApi;
    private Gson mGson;
    private boolean mOverrideImageLoad;
    private String mForceClickOnPackage;
    private String mOverrideBaseUrl;

    TBPublisherApi() {
        this.createDataFormat();
    }

    private void createDataFormat() {
        this.mDefaultSdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
        this.mDefaultSdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.mReportEventDateFormat = new SimpleDateFormat("HH:mm:ss.SSS", Locale.getDefault());
        this.mReportEventDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    TBPublisherApi(String publisherId) {
        this();
        this.mPublisherId = publisherId;
    }

    @MainThread
    public TBPublisherApi init(Context applicationContext, String apiKey) {
        return this.init(applicationContext, this.mPublisherId, apiKey, null);
    }

    @MainThread
    public TBPublisherApi init(Context applicationContext, String apiKey, Map<String, String> extraProperties) {
        return this.init(applicationContext, this.mPublisherId, apiKey, extraProperties);
    }

    @MainThread
    TBPublisherApi init(Context ctx, String publisherId, String apiKey, Map<String, String> extraProperties) {
        Random rand;
        int ran;
        Context applicationContext = ctx.getApplicationContext();
        this.mTaboolaApi = TaboolaApi.getInstance();
        this.mTaboolaApi.setApplicationContext(applicationContext);
        this.mTaboolaApi.createPicasso(applicationContext);
        if (extraProperties != null && !extraProperties.isEmpty()) {
            this.setExtraProperties(extraProperties);
        }
        this.mPublisherId = publisherId;
        this.apiKey = apiKey;
        if (this.mAdvertisingId == null) {
            AdvertisingIdClient.updateCachedAdvertisingIdAsync(applicationContext);
        }
        this.reInitRetrofitClient();
        if (MonitorUtils.isSdkMonitorInstalled(applicationContext)) {
            if (this.mUiHandler == null) {
                this.mUiHandler = new Handler(Looper.getMainLooper());
            }
            this.mTaboolaApi.initSdkMonitor(applicationContext);
        }
        if ((ran = (rand = new Random()).nextInt(100)) <= 5) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    TBPublisherApi.this.sendBridgeToKibana();
                }
            });
            thread.start();
        }
        return this;
    }

    public boolean isInitialized() {
        return this.mRetrofitClient != null && !TextUtils.isEmpty((CharSequence)this.mPublisherId) && this.mTaboolaApi != null && this.getAppContext() != null;
    }

    private void checkIsInitialize() {
        if (this.getAppContext() == null || TextUtils.isEmpty((CharSequence)this.mPublisherId)) {
            Log.e((String)TAG, (String)"TaboolaApi is not properly initialized, did you forget to call init() ?", (Throwable)new Exception());
        }
    }

    private String getBaseUrl(String publisherId) {
        StringBuilder sb = TextUtils.isEmpty((CharSequence)this.mOverrideBaseUrl) ? new StringBuilder(this.getUrlProtocol()).append(BASE_URL) : new StringBuilder(this.mOverrideBaseUrl);
        return sb.append(publisherId).append("/").toString();
    }

    private String getUrlProtocol() {
        return this.mUseHttp ? HTTP_PREFIX : HTTPS_PREFIX;
    }

    public void fetchRecommendations(TBRecommendationsRequest request, TBRecommendationRequestCallback callback) {
        this.checkIsInitialize();
        Context appCtx = this.getAppContext();
        if (appCtx == null) {
            return;
        }
        request.setUserSession(this.getUserSession());
        request.setAppType(MOBILE);
        request.setApiKey(this.apiKey);
        request.setAppName(SdkDetailsHelper.getApplicationName(appCtx));
        request.setViewId(String.valueOf(System.currentTimeMillis()));
        String additionalData = SdkDetailsHelper.createSdkJsonString(appCtx, null, "Taboola Android SDK - API");
        request.setAdditionalData(additionalData);
        if (this.mApiParams != null) {
            for (String key : this.mApiParams.keySet()) {
                request.setApiParam(key, this.mApiParams.get(key));
            }
        }
        this.waitForAdvertisingIdAndFetchRecommendations(request, callback, appCtx);
    }

    public void getNextBatchForPlacement(TBPlacement placement, TBRecommendationRequestCallback callback) {
        this.getNextBatchForPlacement(placement, 0, callback);
    }

    public void getNextBatchForPlacement(TBPlacement placement, int count, TBRecommendationRequestCallback callback) {
        this.checkIsInitialize();
        TBRecommendationsRequest nextBatchRequest = placement.getNextBatchRequest();
        nextBatchRequest.setUserSession(this.getUserSession());
        if (count > 0) {
            TBPlacementRequest placementRequest = nextBatchRequest.getPlacementRequests().values().iterator().next();
            placementRequest.setRecCount(count);
        }
        this.actuallyFetchRecommendations(nextBatchRequest, callback);
    }

    public void handleAttributionClick() {
        this.handleAttributionClick(this.getAppContext());
    }

    public void handleAttributionClick(Context context) {
        if (context == null) {
            context = this.getAppContext();
        }
        if (context == null) {
            Logger.e(TAG, "Attribution dialog can't be showed, Context is missing");
            return;
        }
        String locale = context.getResources().getConfiguration().locale.getCountry();
        String url = "https://popup.taboola.com/" + locale;
        boolean isHandled = false;
        if (context instanceof Activity) {
            isHandled = PopupHelper.openPopup(context, url);
        }
        if (!isHandled) {
            Logger.d(TAG, "can't to open as popup, so opening in browser");
            this.openUrlInTabsOrBrowser(context, url);
        }
    }

    private void openUrlInTabsOrBrowser(Context context, String url) {
        if (!TextUtils.isEmpty((CharSequence)this.mForceClickOnPackage)) {
            OnClickHelper.openUrlInApp(context, url, this.mForceClickOnPackage);
        } else {
            OnClickHelper.openUrlInTabsOrBrowser(context, url);
        }
    }

    public TBPublisherApi setOnClickListener(TaboolaOnClickListener onClickListener) {
        this.checkIsInitialize();
        this.mOnClickListener = onClickListener;
        return this;
    }

    public TBPublisherApi setOnClickIgnoreTimeMs(int onClickIgnoreTimeMs) {
        this.checkIsInitialize();
        this.onClickIgnoreTimeMs = onClickIgnoreTimeMs;
        return this;
    }

    public TBPublisherApi setLogLevel(int logLevel) {
        this.checkIsInitialize();
        Logger.setLogLevel(this.isSdkMonitorEnabled() ? 3 : logLevel);
        return this;
    }

    public TBPublisherApi setImagePlaceholder(Drawable placeholderDrawable) {
        this.checkIsInitialize();
        this.mImagePlaceholderDrawable = placeholderDrawable;
        return this;
    }

    public TBPublisherApi setExtraProperties(Map<String, String> extraProperties) {
        this.checkIsInitialize();
        for (String key : extraProperties.keySet()) {
            String keyHash = PropertiesHashed.md5(key).toLowerCase();
            String value = extraProperties.get(key);
            switch (keyHash) {
                case "0c3e538ab65bab24cc1abb09e4e40370": {
                    this.mIsEnabledFullRawDataResponse = Boolean.parseBoolean(value);
                    break;
                }
                case "77560813c6a1cf1842f2c3615581024f": {
                    this.mIsEnabledRawDataResponse = Boolean.parseBoolean(value);
                    break;
                }
                case "b18f6a812a51478281506648e0e6b4c8": {
                    this.mShouldAllowNonOrganicClickOverride = Boolean.parseBoolean(value);
                    break;
                }
                case "ea42d4645bc3bdefb8a8cf85b1c27c5f": {
                    this.mUseHttp = Boolean.parseBoolean(value);
                    break;
                }
                case "b3e9872b189d2feaec89b21d2493eb66": {
                    this.mApiParams = this.getApiParams(value);
                    break;
                }
                case "dc62a72a1585c8118174b5d0783564c2": {
                    this.mOverrideImageLoad = Boolean.parseBoolean(value);
                    break;
                }
                case "9c978c01eb2af8871edcfe32d9f37388": {
                    this.mForceClickOnPackage = value;
                    break;
                }
                case "cdcdfc176b4ab4b3873ca2c3f8907c65": {
                    if (TextUtils.equals((CharSequence)value, (CharSequence)this.mOverrideBaseUrl)) break;
                    try {
                        URI uri = new URI(value);
                        String host = uri.getHost();
                        this.mOverrideBaseUrl = host.endsWith(TABOOLA_HOST) ? value : null;
                        this.reInitRetrofitClient();
                        break;
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)e.toString());
                        this.mOverrideBaseUrl = null;
                    }
                }
            }
        }
        return this;
    }

    private void reInitRetrofitClient() {
        if (!TextUtils.isEmpty((CharSequence)this.mPublisherId)) {
            this.mRetrofitClient = new RetrofitClient(this.mPublisherId, this.getBaseUrl(this.mPublisherId));
        }
    }

    private Map<String, String> getApiParams(String params) {
        String[] separated;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : separated = params.split(",")) {
            String[] keyV = param.split("=");
            map.put(keyV[0], keyV[1]);
        }
        return map;
    }

    void setSdkEventsTestListener(TestHelperInternal.SdkEventsTestListener sdkEventsTestListener) {
        this.mSdkEventsTestListener = sdkEventsTestListener;
    }

    Drawable getImagePlaceholder() {
        return this.mImagePlaceholderDrawable;
    }

    void onPlacementAvailable(String responseId) {
        if (this.mSdkEventsTestListener != null) {
            this.mSdkEventsTestListener.onAvailable();
        }
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put(RESPONSE_ID, responseId);
        queryParameters.put(RESPONSE_SESSION, this.getUserSession());
        queryParameters.put(APP_TYPE, MOBILE);
        queryParameters.put(APP_APIKEY, this.apiKey);
        this.mRetrofitClient.getTaboolaApiService().notifyAvailable(queryParameters).enqueue((Callback)new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
                if (TBPublisherApi.this.isSdkMonitorEnabled()) {
                    TBPublisherApi.this.sendUrlToMonitor(call.request().url());
                }
                if (response.isSuccessful()) {
                    Logger.d(TBPublisherApi.TAG, "onPlacementAvailable notification successfully sent");
                } else {
                    Logger.e(TBPublisherApi.TAG, "onPlacementAvailable notification failed " + response.message());
                }
            }

            public void onFailure(Call<Void> call, Throwable t) {
                if (TBPublisherApi.this.isSdkMonitorEnabled()) {
                    TBPublisherApi.this.sendUrlToMonitor(call.request().url());
                }
                Logger.e(TBPublisherApi.TAG, "onPlacementAvailable notification failed " + t.getMessage());
            }
        });
    }

    void sendUrlToMonitor(final HttpUrl url) {
        if (this.isSdkMonitorEnabled() && this.mTaboolaApi.isShouldMonitorNetwork()) {
            this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    TBPublisherApi.this.mTaboolaApi.sendUrlToMonitor(url);
                }
            });
        }
    }

    void onPlacementVisible(String responseId) {
        if (this.mSdkEventsTestListener != null) {
            this.mSdkEventsTestListener.onVisible();
        }
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put(RESPONSE_ID, responseId);
        queryParameters.put(RESPONSE_SESSION, this.getUserSession());
        queryParameters.put(APP_TYPE, MOBILE);
        queryParameters.put(APP_APIKEY, this.apiKey);
        this.mRetrofitClient.getTaboolaApiService().notifyVisible(queryParameters).enqueue((Callback)new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
                if (TBPublisherApi.this.isSdkMonitorEnabled()) {
                    TBPublisherApi.this.sendUrlToMonitor(call.request().url());
                }
                if (response.isSuccessful()) {
                    Logger.d(TBPublisherApi.TAG, "onPlacementVisible notification successfully sent");
                } else {
                    Logger.e(TBPublisherApi.TAG, "onPlacementVisible notification failed " + response.message());
                }
            }

            public void onFailure(Call<Void> call, Throwable t) {
                if (TBPublisherApi.this.isSdkMonitorEnabled()) {
                    TBPublisherApi.this.sendUrlToMonitor(call.request().url());
                }
                Logger.e(TBPublisherApi.TAG, "onPlacementVisible notification failed " + t.getMessage());
            }
        });
    }

    void reportClientEvent(String type, Map<String, String> data, String password, String responseId) {
        String keyHash = PropertiesHashed.md5(password).toLowerCase();
        if (!keyHash.equalsIgnoreCase("94bfc32fb5d21fdfd6147eeaf0882d7f")) {
            Logger.e(TAG, "reportEvent wrong password " + password);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)type)) {
            Logger.e(TAG, "reportEvent missing type param ");
            return;
        }
        data.put("eventType", type);
        if (this.mGson == null) {
            this.mGson = new Gson();
        }
        String dataString = this.mGson.toJson(data);
        Logger.d(TAG, "reportEvent() called with: type = [" + type + "], data = [" + dataString + "], password = [" + password + "], responseId = [" + responseId + "]");
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put(RESPONSE_ID, responseId);
        queryParameters.put(RESPONSE_SESSION, this.getUserSession());
        queryParameters.put(APP_TYPE, MOBILE);
        queryParameters.put(APP_APIKEY, this.apiKey);
        queryParameters.put(EVENT_DATA, dataString);
        this.mRetrofitClient.getTaboolaApiService().notifyClientEvent(queryParameters).enqueue((Callback)new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
                if (TBPublisherApi.this.isSdkMonitorEnabled()) {
                    TBPublisherApi.this.sendUrlToMonitor(call.request().url());
                }
                if (!response.isSuccessful()) {
                    Logger.e(TBPublisherApi.TAG, "reportEvent fail with unexpected code " + response);
                } else {
                    Logger.d(TBPublisherApi.TAG, "reportEvent successfully sent " + response);
                }
            }

            public void onFailure(Call<Void> call, Throwable t) {
                if (TBPublisherApi.this.isSdkMonitorEnabled()) {
                    TBPublisherApi.this.sendUrlToMonitor(call.request().url());
                }
                Logger.e(TBPublisherApi.TAG, "reportEvent failed " + t.getMessage(), new Exception());
            }
        });
    }

    void onItemClick(Context context, String placementName, final String placementId, String itemId, String clickUrl, boolean isOrganic, String itemType) {
        if (this.isSdkMonitorEnabled()) {
            this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    TBPublisherApi.this.getSdkMonitorManager().sendApiClicked(placementId);
                }
            });
        }
        RequestUtil.performPreClickCallAsync(context.getApplicationContext(), this.mPublisherId, clickUrl, "Taboola Android SDK - API");
        boolean shouldSdkHandleClick = true;
        if (this.mOnClickListener != null) {
            shouldSdkHandleClick = this.mOnClickListener.onItemClick(placementName, itemId, clickUrl, isOrganic);
        }
        if (shouldSdkHandleClick) {
            this.openUrlInTabsOrBrowser(context, clickUrl);
        } else if (isOrganic || this.mShouldAllowNonOrganicClickOverride) {
            this.notifyClick(placementId, itemType, itemId);
        } else {
            Logger.d(TAG, "onItemClick: Performing default click action even though click handler returned \u201cfalse\u201d.Can only override default click action for organic items");
            this.openUrlInTabsOrBrowser(context, clickUrl);
        }
    }

    int getOnClickIgnoreTimeMs() {
        return this.onClickIgnoreTimeMs;
    }

    Handler getVisibilityMonitoringHandler() {
        return this.mVisibilityMonitoringHandler;
    }

    boolean isEnabledRawDataResponse() {
        return this.mIsEnabledRawDataResponse;
    }

    boolean isEnabledFullRawDataResponse() {
        return this.mIsEnabledFullRawDataResponse;
    }

    boolean isOverrideImageLoad() {
        return this.mOverrideImageLoad;
    }

    private void notifyClick(String placementId, String itemType, String itemId) {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put(RESPONSE_ID, placementId);
        queryParameters.put(RESPONSE_SESSION, this.getUserSession());
        queryParameters.put(APP_TYPE, MOBILE);
        queryParameters.put(APP_APIKEY, this.apiKey);
        queryParameters.put(ITEM_TYPE, itemType);
        queryParameters.put(ITEM_ID, itemId);
        this.mRetrofitClient.getTaboolaApiService().notifyClick(queryParameters).enqueue((Callback)new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
                if (TBPublisherApi.this.isSdkMonitorEnabled()) {
                    TBPublisherApi.this.sendUrlToMonitor(call.request().url());
                }
                if (response.isSuccessful()) {
                    Logger.d(TBPublisherApi.TAG, "onItemClick notification successfully sent");
                } else {
                    Logger.e(TBPublisherApi.TAG, "onItemClick notification failed " + response.message());
                }
            }

            public void onFailure(Call<Void> call, Throwable t) {
                if (TBPublisherApi.this.isSdkMonitorEnabled()) {
                    TBPublisherApi.this.sendUrlToMonitor(call.request().url());
                }
                Logger.e(TBPublisherApi.TAG, "onItemClick notification failed " + t.getMessage());
            }
        });
    }

    private void waitForAdvertisingIdAndFetchRecommendations(final TBRecommendationsRequest request, final TBRecommendationRequestCallback listener, Context appCtx) {
        if (this.mAdvertisingId == null) {
            String cachedId = AdvertisingIdClient.getCachedAdvertisingId(appCtx);
            if (cachedId != null) {
                this.mAdvertisingId = cachedId;
                request.setDeviceId(this.mAdvertisingId);
                this.actuallyFetchRecommendations(request, listener);
            } else {
                AdvertisingIdClient.updateAdvertisingIdAsync(appCtx, new AdvertisingIdClient.AdvertisingIdCallback(){

                    @Override
                    public void onIdRetrieved(String advertisingId) {
                        TBPublisherApi.this.mAdvertisingId = advertisingId;
                        request.setDeviceId(TBPublisherApi.this.mAdvertisingId);
                        TBPublisherApi.this.actuallyFetchRecommendations(request, listener);
                    }

                    @Override
                    public void onIdUnavailable() {
                        TBPublisherApi.this.mAdvertisingId = "";
                        TBPublisherApi.this.actuallyFetchRecommendations(request, listener);
                    }
                });
            }
        } else if (this.mAdvertisingId.isEmpty()) {
            this.actuallyFetchRecommendations(request, listener);
        } else {
            request.setDeviceId(this.mAdvertisingId);
            this.actuallyFetchRecommendations(request, listener);
        }
    }

    private void actuallyFetchRecommendations(TBRecommendationsRequest request, final TBRecommendationRequestCallback listener) {
        TBUrlParamsChange paramsChange;
        String requestUuid = UUID.randomUUID().toString();
        this.mRequestMap.put(requestUuid, request);
        HashMap<String, String> queryParameters = request.generateQueryParameters();
        if (this.isSdkMonitorEnabled() && this.mTaboolaApi.isShouldMonitorNetwork() && (paramsChange = (TBUrlParamsChange)this.mTaboolaApi.getFeature(3)) != null && !TextUtils.isEmpty((CharSequence)paramsChange.getParams())) {
            String[] separated;
            for (String param : separated = paramsChange.getParams().split("&")) {
                String[] keyV = param.split("=");
                queryParameters.put(keyV[0], keyV[1]);
            }
        }
        queryParameters.put(REQUEST_ID_KEY, requestUuid);
        Callback<TBRecommendationsResponse> responseCallback = new Callback<TBRecommendationsResponse>(){

            public void onResponse(Call<TBRecommendationsResponse> call, Response<TBRecommendationsResponse> response) {
                HttpUrl url = call.request().url();
                Logger.d(TBPublisherApi.TAG, "request URL : " + url);
                if (TBPublisherApi.this.isSdkMonitorEnabled()) {
                    TBPublisherApi.this.sendUrlToMonitor(url);
                }
                if (response.isSuccessful()) {
                    try {
                        TBPublisherApi.this.onSuccessfulResponse((Call<TBRecommendationsResponse>)call, (Response<TBRecommendationsResponse>)response, listener);
                    }
                    catch (Exception e) {
                        if (listener != null) {
                            listener.onRecommendationsFailed(new Throwable(e.getMessage()));
                        }
                    }
                } else if (listener != null) {
                    listener.onRecommendationsFailed(new Throwable(response.message()));
                }
            }

            public void onFailure(Call<TBRecommendationsResponse> call, Throwable t) {
                if (TBPublisherApi.this.isSdkMonitorEnabled()) {
                    TBPublisherApi.this.sendUrlToMonitor(call.request().url());
                }
                if (listener != null) {
                    listener.onRecommendationsFailed(t);
                }
            }
        };
        this.mRetrofitClient.getTaboolaApiService().fetchRecommendations(queryParameters).enqueue((Callback)responseCallback);
    }

    private void onSuccessfulResponse(Call<TBRecommendationsResponse> call, Response<TBRecommendationsResponse> response, TBRecommendationRequestCallback listener) {
        String reqId = call.request().url().queryParameter(REQUEST_ID_KEY);
        final TBRecommendationsRequest request = this.mRequestMap.get(reqId);
        this.mRequestMap.remove(reqId);
        TBRecommendationsResponse body = (TBRecommendationsResponse)response.body();
        for (Map.Entry<String, TBPlacement> placementEntry : body.getPlacementsMap().entrySet()) {
            final TBPlacement placementValue = placementEntry.getValue();
            TBPlacementRequest tbPlacementRequest = request.getPlacementRequests().get(placementEntry.getKey());
            if (tbPlacementRequest == null) {
                tbPlacementRequest = request.getPlacementRequests().values().iterator().next();
            }
            boolean isAvailable = tbPlacementRequest.getAvailable();
            placementValue.setHasReportedAvailability(isAvailable);
            TBRecommendationsRequest nextBatchRequest = request.createNextBatchRequest(placementEntry.getKey());
            placementValue.setNextBatchRequest(nextBatchRequest);
            placementValue.setName(placementEntry.getKey());
            if (!this.isSdkMonitorEnabled()) continue;
            this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    Messenger placementMessenger = new Messenger((Handler)placementValue.getApiMonitorHandler());
                    MonitorManager monitorManager = TBPublisherApi.this.getSdkMonitorManager();
                    monitorManager.sendApiReceived(placementValue.getId(), placementValue.getName(), placementMessenger);
                    monitorManager.sendApiProperties(placementValue.getId(), TBPublisherApi.this.generateMonitorDebugParams(request));
                }
            });
        }
        this.setUserSession(body.getSession());
        listener.onRecommendationsFetched(body);
    }

    private HashMap<String, String> generateMonitorDebugParams(TBRecommendationsRequest request) {
        HashMap<String, String> parameters = request.generateQueryParameters();
        parameters.put("publisher", this.mPublisherId);
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserSession() {
        Object object = this.mUserSessionLock;
        synchronized (object) {
            return SharedPrefUtil.getUserSession(this.getAppContext(), this.mPublisherId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUserSession(String userSession) {
        Object object = this.mUserSessionLock;
        synchronized (object) {
            Context appCtx = this.getAppContext();
            SharedPrefUtil.setUserSession(appCtx, userSession, this.mPublisherId);
            SharedPrefUtil.setUserSessionTimestamp(appCtx, System.currentTimeMillis(), this.mPublisherId);
        }
    }

    private void sendBridgeToKibana() {
        KibanaApiService kibanaApiService = KibanaApiClient.getKibanaApiService();
        try {
            JsonObject event = new JsonObject();
            if (this.mDefaultSdf == null) {
                this.createDataFormat();
            }
            String formattedDate = this.mDefaultSdf.format(new Date());
            JSONObject bridge = SdkDetailsHelper.createSdkDetailsJSON(this.getAppContext(), null, "Taboola Android SDK - API");
            JsonObject additional_data = new JsonParser().parse(bridge.toString()).getAsJsonObject();
            event.add(ADDITIONAL_DATA, (JsonElement)additional_data);
            event.addProperty(DEVICE, TextUtils.isEmpty((CharSequence)this.mAdvertisingId) ? "undefined" : this.mAdvertisingId);
            event.addProperty(PUBLISHER_ID, this.mPublisherId);
            event.addProperty(API_KEY, this.apiKey);
            event.addProperty(TIMESTAMP, formattedDate);
            event.addProperty(EVENT, MOBILE_INIT);
            event.addProperty(SHOULD_ALLOW_NON_ORGANIC_CLICK_OVERRIDE, Boolean.valueOf(this.mShouldAllowNonOrganicClickOverride));
            event.addProperty(IS_ENABLED_RAW_DATA_RESPONSE, Boolean.valueOf(this.mIsEnabledRawDataResponse));
            event.addProperty(USE_HTTP, Boolean.valueOf(this.mUseHttp));
            event.add(API_PARAMS, new Gson().toJsonTree(this.mApiParams));
            kibanaApiService.sendEvent(event).execute();
        }
        catch (Exception e) {
            Logger.e(TAG, "sendEventToKibana " + e.getMessage());
        }
    }

    public String getPublisherId() {
        return this.mPublisherId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void clear() {
        Log.d((String)TAG, (String)(this.mPublisherId + ", clear() called "));
        this.mOnClickListener = null;
        this.mSdkEventsTestListener = null;
        this.mRetrofitClient = null;
        this.mImagePlaceholderDrawable = null;
        this.mOverrideImageLoad = false;
        this.mOverrideBaseUrl = null;
        this.mTaboolaApi = null;
        if (this.mUiHandler != null) {
            this.mUiHandler.removeCallbacksAndMessages(null);
            this.mUiHandler = null;
        }
    }

    public void setImageErrorListener(TBImageErrorListener tbImageErrorListener) {
        this.checkIsInitialize();
        this.mTaboolaApi.setImageErrorListener(tbImageErrorListener);
    }

    Context getAppContext() {
        if (this.mTaboolaApi == null) {
            return null;
        }
        return this.mTaboolaApi.getApplicationContext();
    }

    boolean isSdkMonitorEnabled() {
        return this.mTaboolaApi.isSdkMonitorEnabled();
    }

    private MonitorManager getSdkMonitorManager() {
        return this.mTaboolaApi.getSdkMonitorManager();
    }

    public void sendApiAvailable(final String id2) {
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                TBPublisherApi.this.getSdkMonitorManager().sendApiAvailable(id2);
            }
        });
    }

    public void sendApiVisible(final String id2) {
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                TBPublisherApi.this.getSdkMonitorManager().sendApiVisible(id2);
            }
        });
    }
}

