/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.api;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.taboola.android.api.IRetrofitClient;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBPublisherApi;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.api.TBRecommendationsResponse;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.api.TaboolaApiService;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.StringUtil;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class RetrofitClient
implements IRetrofitClient {
    static final String THUMBNAIL = "thumbnail";
    static final String DESCRIPTION = "description";
    static final String NAME = "name";
    static final String BRANDING = "branding";
    static final String ORIGIN = "origin";
    static final String URL = "url";
    static final String ID = "id";
    static final String PIXELS = "pixels";
    static final String USER_AGENT = "User-Agent";
    static final String SESSION = "session";
    static final String HTTP_AGENT = "http.agent";
    private final OkHttpClient mClient;
    private TaboolaApiService mTaboolaApiService;
    private final Gson mGson;

    RetrofitClient(String publisherId, String baseUrl) {
        this.mGson = new GsonBuilder().registerTypeAdapter(TBRecommendationsResponse.class, (Object)new RecommendationResponseAdapter(publisherId)).create();
        this.mClient = RetrofitClient.buildOkHttpClient();
        Retrofit retrofit = new Retrofit.Builder().client(this.mClient).baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.mGson)).build();
        this.mTaboolaApiService = (TaboolaApiService)retrofit.create(TaboolaApiService.class);
    }

    @Override
    public Gson getGson() {
        return this.mGson;
    }

    public TaboolaApiService getTaboolaApiService() {
        return this.mTaboolaApiService;
    }

    @NonNull
    private static OkHttpClient buildOkHttpClient() {
        try {
            String userAgent = System.getProperty(HTTP_AGENT);
            if (!TextUtils.isEmpty((CharSequence)userAgent)) {
                userAgent = StringUtil.removeNonAscii(userAgent);
                UserAgentInterceptor interceptor = new UserAgentInterceptor(userAgent);
                return new OkHttpClient.Builder().addInterceptor((Interceptor)interceptor).build();
            }
        }
        catch (Exception e) {
            Logger.e("TaboolaApi", "Failed to build OkHttpClient with user agent interceptor: " + e.getLocalizedMessage());
        }
        return new OkHttpClient();
    }

    OkHttpClient getClient() {
        return this.mClient;
    }

    private static class UserAgentInterceptor
    implements Interceptor {
        private final String mUserAgent;

        public UserAgentInterceptor(String userAgent) {
            this.mUserAgent = userAgent;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request originalRequest = chain.request();
            Request requestWithUserAgent = originalRequest.newBuilder().header(RetrofitClient.USER_AGENT, this.mUserAgent).build();
            return chain.proceed(requestWithUserAgent);
        }
    }

    private static class RecommendationItemAdapter
    implements JsonDeserializer<TBRecommendationItem> {
        private final String mPublisherId;
        private Gson mGson;
        private WeakReference<TBPublisherApi> mTBPublisherApiRef;

        RecommendationItemAdapter(String publisherId) {
            this.mPublisherId = publisherId;
            this.mGson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        }

        public TBRecommendationItem deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            boolean enabledRawData;
            boolean enabledFullRawData;
            TBRecommendationItem tbRecommendationItem = (TBRecommendationItem)this.mGson.fromJson(json, TBRecommendationItem.class);
            tbRecommendationItem.setPublisherId(this.mPublisherId);
            JsonObject jsonObject = json.getAsJsonObject();
            if (this.mTBPublisherApiRef == null || this.mTBPublisherApiRef.get() == null) {
                this.mTBPublisherApiRef = new WeakReference<TBPublisherApi>(TaboolaApi.getInstance(this.mPublisherId));
            }
            if (!(enabledFullRawData = ((TBPublisherApi)this.mTBPublisherApiRef.get()).isEnabledFullRawDataResponse())) {
                HashSet<String> privateKeys = new HashSet<String>();
                privateKeys.add(RetrofitClient.ORIGIN);
                privateKeys.add(RetrofitClient.URL);
                privateKeys.add(RetrofitClient.ID);
                privateKeys.add(RetrofitClient.PIXELS);
                for (String privateKey : privateKeys) {
                    jsonObject.remove(privateKey);
                }
            }
            if (!(enabledRawData = ((TBPublisherApi)this.mTBPublisherApiRef.get()).isEnabledRawDataResponse()) && !enabledFullRawData) {
                HashSet<String> rawDataKeys = new HashSet<String>();
                if (!((TBPublisherApi)this.mTBPublisherApiRef.get()).isOverrideImageLoad()) {
                    rawDataKeys.add(RetrofitClient.THUMBNAIL);
                }
                rawDataKeys.add(RetrofitClient.DESCRIPTION);
                rawDataKeys.add(RetrofitClient.NAME);
                rawDataKeys.add(RetrofitClient.BRANDING);
                for (String rawDataKey : rawDataKeys) {
                    jsonObject.remove(rawDataKey);
                }
            }
            HashMap<String, String> extraDataMap = new HashMap<String, String>();
            for (Map.Entry elementJson : jsonObject.entrySet()) {
                extraDataMap.put((String)elementJson.getKey(), ((JsonElement)elementJson.getValue()).toString());
            }
            tbRecommendationItem.setExtraDataMap(extraDataMap);
            return tbRecommendationItem;
        }
    }

    private static class RecommendationResponseAdapter
    implements JsonDeserializer<TBRecommendationsResponse> {
        private final String mPublisherId;
        private Gson mGson;

        RecommendationResponseAdapter(String publisherId) {
            this.mPublisherId = publisherId;
            this.mGson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(TBRecommendationItem.class, (Object)new RecommendationItemAdapter(this.mPublisherId)).create();
        }

        public TBRecommendationsResponse deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Logger.d("TaboolaApi", "response json : " + json);
            TBRecommendationsResponse response = new TBRecommendationsResponse();
            HashMap<String, TBPlacement> placementMap = new HashMap<String, TBPlacement>();
            for (Map.Entry elementJson : json.getAsJsonObject().entrySet()) {
                if (((String)elementJson.getKey()).equalsIgnoreCase(RetrofitClient.SESSION)) {
                    String session = ((JsonElement)elementJson.getValue()).getAsString();
                    response.setSession(session);
                    continue;
                }
                TBPlacement placement = (TBPlacement)this.mGson.fromJson((JsonElement)elementJson.getValue(), TBPlacement.class);
                placement.setPublisherId(this.mPublisherId);
                for (TBRecommendationItem item : placement.getItems()) {
                    item.setPlacement(placement);
                }
                placementMap.put((String)elementJson.getKey(), placement);
            }
            response.setPlacementsMap(placementMap);
            return response;
        }
    }
}

