/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.customtabs.CustomTabsIntent;
import com.taboola.android.utils.Logger;
import java.util.List;

public class OnClickHelper {
    public static boolean areChromeCustomTabsSupported(Context context) {
        String CHROME_SERVICE_ACTION = "android.support.customtabs.action.CustomTabsService";
        String CHROME_PACKAGE = "com.android.chrome";
        Intent serviceIntent = new Intent("android.support.customtabs.action.CustomTabsService");
        serviceIntent.setPackage("com.android.chrome");
        List resolveInfos = context.getPackageManager().queryIntentServices(serviceIntent, 0);
        try {
            Class.forName("android.support.customtabs.CustomTabsService");
        }
        catch (ClassNotFoundException e) {
            Logger.d("ContentValues", "areChromeCustomTabsSupported :: ChromeCustomTabs not included in hosting app");
            return false;
        }
        return resolveInfos != null && !resolveInfos.isEmpty();
    }

    public static void openUrlInTabsOrBrowser(Context context, String url) {
        try {
            if (OnClickHelper.areChromeCustomTabsSupported(context)) {
                Logger.d("ContentValues", "openChromeTab :: opening ad in a ChromeTab");
                CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().build();
                OnClickHelper.handleNonActivityContext(context, customTabsIntent.intent);
                customTabsIntent.launchUrl(context, Uri.parse((String)url));
            } else {
                Logger.d("ContentValues", "openNativeBrowser :: opening add");
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                OnClickHelper.handleNonActivityContext(context, intent);
                context.startActivity(intent);
            }
        }
        catch (Exception e) {
            Logger.e("ContentValues", "openUrlInTabsOrBrowser :: failed to open url " + e.toString());
        }
    }

    @MainThread
    public static void openUrlInApp(@NonNull Context context, @NonNull String url, @NonNull String packageName) {
        Uri uri = Uri.parse((String)url);
        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().build();
        Intent intent = customTabsIntent.intent;
        intent.setPackage(packageName);
        intent.setData(uri);
        OnClickHelper.handleNonActivityContext(context, intent);
        PackageManager pm = context.getPackageManager();
        if (pm.resolveActivity(intent, 0) == null) {
            intent.setPackage(null);
        }
        customTabsIntent.launchUrl(context, uri);
    }

    private static void handleNonActivityContext(Context context, Intent intent) {
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10008000);
        }
    }
}

