/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.js;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Messenger;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.SparseArray;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.taboola.android.MonitorManager;
import com.taboola.android.api.TaboolaOnClickListener;
import com.taboola.android.js.MonitorWebViewClient;
import com.taboola.android.js.OnRenderListener;
import com.taboola.android.js.OnResizeListener;
import com.taboola.android.js.PublicApi;
import com.taboola.android.js.SdkJSMonitorHandler;
import com.taboola.android.js.WebViewManager;
import com.taboola.android.monitor.TBNetworkMonitoring;
import com.taboola.android.monitor.TBSdkFeature;
import com.taboola.android.monitor.TBSimCodeChange;
import com.taboola.android.monitor.TBSuspendMonitor;
import com.taboola.android.utils.AdvertisingIdClient;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.MonitorUtils;
import com.taboola.android.utils.SdkDetailsHelper;
import java.util.HashMap;
import java.util.Map;

public class TaboolaJs
implements PublicApi.PublicTaboolaJs {
    public static final String PLACEMENT_TAG_DIVIDER = "##";
    public static final String INJECTED_OBJECT_NAME = "taboolaNative";
    public static final String TAG = TaboolaJs.class.getSimpleName();
    @Nullable
    private static String sAdvertisingId = null;
    private static final TaboolaJs ourInstance = new TaboolaJs();
    private Handler mHandler;
    private boolean mShouldAllowNonOrganicClickOverride = false;
    @Nullable
    private TaboolaOnClickListener mOnClickListener;
    private Map<WebView, WebViewManager> mWebViewManagers = new HashMap<WebView, WebViewManager>();
    private MonitorManager mSdkMonitorManager = null;
    private Boolean mIsSdkMonitorInstalled;
    private SparseArray<TBSdkFeature> mSdkFeatures;
    private Messenger mMonitorMessenger;
    private Context mApplicationContext;

    private TaboolaJs() {
    }

    public static TaboolaJs getInstance() {
        return ourInstance;
    }

    @Override
    public TaboolaJs init(@NonNull Context ctx) {
        Context applicationContext = ctx.getApplicationContext();
        if (sAdvertisingId == null) {
            AdvertisingIdClient.updateCachedAdvertisingIdAsync(applicationContext);
        }
        if (MonitorUtils.isSdkMonitorInstalled(applicationContext)) {
            this.initSdkMonitor(applicationContext);
        }
        return this;
    }

    void initSdkMonitor(Context applicationContext) {
        this.mApplicationContext = applicationContext;
        if (this.mIsSdkMonitorInstalled == null) {
            this.mIsSdkMonitorInstalled = true;
            this.mSdkMonitorManager = MonitorManager.getInstance(SdkDetailsHelper.getApplicationName(applicationContext));
            this.mSdkMonitorManager.bindService(applicationContext);
            Logger.setSdkMonitorManager(this.mSdkMonitorManager);
            if (this.mHandler == null) {
                this.mHandler = new Handler(Looper.getMainLooper());
            }
            if (this.mMonitorMessenger == null) {
                this.mMonitorMessenger = new Messenger((Handler)new SdkJSMonitorHandler());
            }
        }
        if (this.mIsSdkMonitorInstalled.booleanValue()) {
            this.mSdkMonitorManager.sendGetFeatureSet(this.mMonitorMessenger, null);
        }
    }

    @Override
    public TaboolaJs registerWebView(@NonNull WebView webView) {
        this.registerWebView(webView, null);
        return this;
    }

    @Override
    public TaboolaJs registerWebView(@NonNull WebView webView, @Nullable OnRenderListener onRenderListener) {
        if (webView == null || webView.getContext() == null) {
            Logger.e(TAG, "registerWebView, WebView is not attached ", new Exception());
            return this;
        }
        if (this.mWebViewManagers.containsKey(webView)) {
            Logger.e(TAG, "registerWebView: WebView is already registered");
        } else {
            WebViewManager webViewManager = new WebViewManager(webView);
            webViewManager.setOnRenderListener(onRenderListener);
            this.mWebViewManagers.put(webView, webViewManager);
            webViewManager.registerWebView();
        }
        if (this.isSdkMonitorEnabled() && this.isShouldMonitorNetwork()) {
            webView.setWebViewClient((WebViewClient)new MonitorWebViewClient());
            if (Build.VERSION.SDK_INT >= 19) {
                WebView.setWebContentsDebuggingEnabled((boolean)true);
            }
        }
        return this;
    }

    @Override
    public TaboolaJs unregisterWebView(@NonNull WebView webView) {
        Logger.d(TAG, "unregisterWebView() ");
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager == null) {
            Logger.e(TAG, "unregisterWebView: WebView is not registered");
        } else {
            webViewManager.unregisterWebView();
            webViewManager.setOnRenderListener(null);
            this.mWebViewManagers.remove(webView);
        }
        return this;
    }

    @Override
    public TaboolaJs setLogLevel(int logLevel) {
        Logger.setLogLevel(this.isSdkMonitorEnabled() ? 3 : logLevel);
        return this;
    }

    @Override
    public TaboolaJs setOnRenderListener(@NonNull WebView webView, @Nullable OnRenderListener onRenderListener) {
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager != null) {
            webViewManager.setOnRenderListener(onRenderListener);
        } else {
            Logger.e(TAG, "setOnRenderListener: WebView is not registered");
        }
        return this;
    }

    public TaboolaJs setTag(@NonNull WebView webView, String tag) {
        if (TextUtils.isEmpty((CharSequence)tag)) {
            Logger.e(TAG, "setTag: was set with empty tag");
            return this;
        }
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager != null) {
            webViewManager.setTag(tag);
        } else {
            Logger.e(TAG, "setTag: WebView is not registered", new Exception());
        }
        return this;
    }

    public TaboolaJs setOnResizeListener(@NonNull WebView webView, @Nullable OnResizeListener onResizeListener) {
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager != null) {
            webViewManager.setOnResizeListener(onResizeListener);
        } else {
            Logger.e(TAG, "setOnResizeListener: WebView is not registered");
        }
        return this;
    }

    @Override
    public TaboolaJs setOnClickListener(@Nullable TaboolaOnClickListener onClickListener) {
        String logMsg = onClickListener != null ? "setOnClickListener " : "TaboolaOnClickListener was removed";
        Logger.d(TAG, logMsg);
        this.mOnClickListener = onClickListener;
        return this;
    }

    public TaboolaJs setExtraProperties(@NonNull Map<String, String> extraProperties) {
        this.mShouldAllowNonOrganicClickOverride = Boolean.parseBoolean(extraProperties.get("allowNonOrganicClickOverride"));
        return this;
    }

    public TaboolaJs setExtraProperties(@NonNull WebView webView, @NonNull Map<String, String> extraProperties) {
        WebViewManager webViewManager = this.mWebViewManagers.get(webView);
        if (webViewManager != null) {
            webViewManager.setExtraProperties(extraProperties);
        } else {
            Logger.e(TAG, "setExtraProperties: WebView is not registered");
        }
        return this;
    }

    boolean shouldAllowNonOrganicClickOverride() {
        return this.mShouldAllowNonOrganicClickOverride;
    }

    @Nullable
    TaboolaOnClickListener getOnClickListener() {
        return this.mOnClickListener;
    }

    @Nullable
    String getAdvertisingIdFromMemory() {
        return sAdvertisingId;
    }

    void getAdvertisingId(final AdvertisingIdRetrievedCallback callback, @NonNull Context applicationContext) {
        if (sAdvertisingId == null) {
            String cachedId = AdvertisingIdClient.getCachedAdvertisingId(applicationContext);
            if (cachedId != null) {
                sAdvertisingId = cachedId;
                callback.onAdIdRetrieved(sAdvertisingId);
            } else {
                AdvertisingIdClient.updateAdvertisingIdAsync(applicationContext, new AdvertisingIdClient.AdvertisingIdCallback(){

                    @Override
                    public void onIdRetrieved(String advertisingId) {
                        sAdvertisingId = advertisingId;
                        callback.onAdIdRetrieved(sAdvertisingId);
                    }

                    @Override
                    public void onIdUnavailable() {
                        sAdvertisingId = "";
                        callback.onAdIdRetrieved(sAdvertisingId);
                    }
                });
            }
        } else if (sAdvertisingId.isEmpty()) {
            callback.onAdIdRetrieved(sAdvertisingId);
        } else {
            callback.onAdIdRetrieved(sAdvertisingId);
        }
    }

    public boolean isSdkMonitorEnabled() {
        return this.mIsSdkMonitorInstalled != null && this.mIsSdkMonitorInstalled != false && !this.isSdkMonitorSuspended();
    }

    boolean isSdkMonitorSuspended() {
        TBSuspendMonitor suspendMonitor = (TBSuspendMonitor)this.getFeature(2);
        return suspendMonitor != null && suspendMonitor.isShouldSuspend();
    }

    boolean isShouldMonitorNetwork() {
        TBNetworkMonitoring tbWebViewMonitor = (TBNetworkMonitoring)this.getFeature(4);
        return tbWebViewMonitor == null || tbWebViewMonitor.isShouldMonitor();
    }

    public MonitorManager getSdkMonitorManager() {
        return this.mSdkMonitorManager;
    }

    void setSdkFeatures(SparseArray<TBSdkFeature> sdkFeatures) {
        this.mSdkFeatures = sdkFeatures;
        SdkDetailsHelper.verifyIfNeededToChangeSimCode((TBSimCodeChange)this.getFeature(5));
    }

    private boolean isMissingSdkFeatures() {
        return this.mSdkFeatures == null || this.mSdkFeatures.size() == 0;
    }

    @Nullable
    <T extends TBSdkFeature> T getFeature(Integer key) {
        if (this.isMissingSdkFeatures()) {
            return null;
        }
        TBSdkFeature sdkFeature = (TBSdkFeature)this.mSdkFeatures.get(key.intValue());
        return (T)sdkFeature;
    }

    void sendUrlToMonitor(final long timestamp, final String url) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                TaboolaJs.this.mSdkMonitorManager.sendNetworkCall(timestamp, url);
            }
        });
    }

    public void clear() {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        this.mOnClickListener = null;
        if (this.mIsSdkMonitorInstalled != null && this.mIsSdkMonitorInstalled.booleanValue() && this.mSdkMonitorManager != null) {
            this.mIsSdkMonitorInstalled = null;
            this.mSdkMonitorManager.unbindService(this.mApplicationContext);
            Logger.setSdkMonitorManager(null);
            this.mSdkMonitorManager = null;
            this.mMonitorMessenger = null;
            if (this.mSdkFeatures != null) {
                this.mSdkFeatures.clear();
            }
        }
        this.mApplicationContext = null;
    }

    public void sendFetchContentParamsToMonitor(WebView webView, String placement, HashMap<String, String> parameters) {
        WebViewManager webViewManager;
        if (this.isSdkMonitorEnabled() && (webViewManager = this.mWebViewManagers.get(webView)) != null) {
            webViewManager.prepareAndSendParamsToMonitor(placement, parameters);
        }
    }

    void sendWebPlacementFetchContent(final String placementId, final String placementType, final String placementName, final HashMap<String, String> parameters) {
        if (this.isSdkMonitorEnabled()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    TaboolaJs.this.mSdkMonitorManager.sendWebPlacementFetchContent(placementId, placementType, placementName, parameters);
                }
            });
        }
    }

    void reportDeviceDataToMonitor(String deviceData) {
        if (this.isSdkMonitorEnabled()) {
            this.mSdkMonitorManager.sendGetFeatureSet(this.mMonitorMessenger, deviceData);
        }
    }

    static interface AdvertisingIdRetrievedCallback {
        public void onAdIdRetrieved(String var1);
    }
}

