/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.js;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewTreeObserver;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import com.taboola.android.js.InjectedObject;
import com.taboola.android.js.JsInitDataObserver;
import com.taboola.android.js.OnRenderListener;
import com.taboola.android.js.OnResizeListener;
import com.taboola.android.js.TaboolaJs;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.SdkDetailsHelper;
import com.taboola.android.utils.VisibilityUtil;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

class WebViewManager {
    private static final String TAG = WebViewManager.class.getSimpleName();
    private static final long SCROLL_EVENT_DELAY_MS = 500L;
    private static final String NOTIFY_EXTERNAL_RECTS = "notifyExternalRects";
    private static final String HIGHTLIGHT_PLACEMENT = "highlightPlacement";
    private static final String WEBVIEW_REGISTERED = "webviewRegistered";
    private static final String EDIT_PROPERTIES = "editProperties";
    private WebView mWebView;
    private Handler mHandler = new Handler();
    private Runnable mNotifyOnScrollRunnable;
    private ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
    private HashMap<String, String> mPlacementIdMap = new HashMap();
    private Messenger mWebViewMessenger;
    private OnRenderListener mOnRenderListener;
    private OnResizeListener mOnResizeListener;
    private boolean mIsAlive;
    private long mLastScrollEventSentTimestamp = 0L;
    private Boolean mShouldAllowNonOrganicClickOverride = null;
    private boolean mIsUsedInTaboolaWidget = false;
    private String mMediatedVia;
    private Map<String, String> mExtraData;
    private boolean didRender;
    private String mTag;
    private InjectedObject injectedObject;
    private JSONObject mNativeWindowRect;

    WebViewManager(WebView webView) {
        this.mWebView = webView;
        this.mWebView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                if (left == 0 && top == 0 && right == 0 && bottom == 0) {
                    return;
                }
                WebViewManager.this.notifyExternalRects();
            }
        });
        this.mNotifyOnScrollRunnable = new Runnable(){

            @Override
            public void run() {
                if (WebViewManager.this.mWebView != null) {
                    WebViewManager.this.notifyExternalRects();
                }
            }
        };
        this.onScrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(){

            public void onScrollChanged() {
                WebViewManager.this.onScrollEvent();
            }
        };
        if (this.isSdkMonitorEnabled()) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    WebViewManager.this.mWebViewMessenger = new Messenger((Handler)new JsMonitorHandler(WebViewManager.this));
                }
            });
        }
    }

    void registerWebView() {
        Context context = this.mWebView.getContext();
        if (context == null) {
            Logger.e(TAG, "registerWebView, WebView is not attached ", new Exception());
            return;
        }
        this.injectedObject = new InjectedObject(context, this);
        this.mWebView.addJavascriptInterface((Object)this.injectedObject, "taboolaNative");
        TaboolaJs.getInstance().getAdvertisingId(new TaboolaJs.AdvertisingIdRetrievedCallback(){

            @Override
            public void onAdIdRetrieved(String id2) {
                WebViewManager.this.onAdIdRetrieved();
            }
        }, context.getApplicationContext());
    }

    private void onAdIdRetrieved() {
        this.mWebView.getViewTreeObserver().addOnScrollChangedListener(this.onScrollChangedListener);
        this.mIsAlive = true;
        this.emitTaboolaBridgeEvent(WEBVIEW_REGISTERED, null);
    }

    void unregisterWebView() {
        this.mIsAlive = false;
        this.mWebView.removeJavascriptInterface("taboolaNative");
        this.mWebView.getViewTreeObserver().removeOnScrollChangedListener(this.onScrollChangedListener);
    }

    void setDidRender(boolean didRender) {
        this.didRender = didRender;
    }

    private void onScrollEvent() {
        long currentTimeMillis = System.currentTimeMillis();
        if (this.mLastScrollEventSentTimestamp + 500L < currentTimeMillis) {
            this.notifyExternalRects();
            this.mLastScrollEventSentTimestamp = currentTimeMillis;
            this.mHandler.removeCallbacks(this.mNotifyOnScrollRunnable);
            this.mHandler.postDelayed(this.mNotifyOnScrollRunnable, 500L);
        }
    }

    private void notifyExternalRects() {
        if (this.mWebView != null && this.didRender) {
            this.emitTaboolaBridgeEvent(NOTIFY_EXTERNAL_RECTS, this.getVisibleBounds());
        }
    }

    void emitTaboolaBridgeEvent(String eventName, String eventData) {
        StringBuilder parameters = new StringBuilder();
        parameters.append("taboolaBridge.emit('").append(eventName).append("'");
        if (eventData != null) {
            parameters.append(",").append(eventData);
        }
        parameters.append(")");
        this.callJsFunction(parameters.toString());
    }

    void callJsFunction(String func) {
        if (this.mWebView != null) {
            if (Build.VERSION.SDK_INT >= 19) {
                this.mWebView.evaluateJavascript(func, null);
            } else {
                this.mWebView.loadUrl("javascript:" + func);
            }
        }
    }

    String getDeviceData() {
        final JSONObject deviceData = new JSONObject();
        JSONObject additionalData = SdkDetailsHelper.createSdkDetailsJSON(this.mWebView.getContext(), this.mMediatedVia, this.getSdkType());
        String advertisingId = TaboolaJs.getInstance().getAdvertisingIdFromMemory();
        try {
            deviceData.put("additional_data", (Object)additionalData);
            deviceData.put("device", (Object)(TextUtils.isEmpty((CharSequence)advertisingId) ? "undefined" : advertisingId));
            if (this.mExtraData != null) {
                for (Map.Entry<String, String> entry : this.mExtraData.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    deviceData.put(key, (Object)value);
                }
            }
        }
        catch (JSONException e) {
            Logger.e(TAG, e.getMessage());
            e.printStackTrace();
        }
        if (this.isSdkMonitorEnabled()) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    WebViewManager.this.reportToMonitor(deviceData);
                }
            }, 1000L);
        }
        return deviceData.toString();
    }

    private void reportToMonitor(final JSONObject deviceData) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.getWebView().evaluateJavascript("(function() { return MOBILE_LOADER_VERSION; })();", (ValueCallback)new ValueCallback<String>(){

                public void onReceiveValue(String value) {
                    try {
                        deviceData.put("mobileLoaderVersion", (Object)(TextUtils.isEmpty((CharSequence)value) ? "undefined" : value));
                        TaboolaJs.getInstance().reportDeviceDataToMonitor(deviceData.toString());
                    }
                    catch (Exception e) {
                        Logger.e(TAG, e.toString(), e);
                    }
                }
            });
        } else {
            TaboolaJs.getInstance().reportDeviceDataToMonitor(deviceData.toString());
        }
    }

    String getSdkType() {
        if (this.mIsUsedInTaboolaWidget) {
            return "Taboola Android SDK";
        }
        return "Taboola Android SDK - JS";
    }

    String getVisibleBounds() {
        JSONObject mJsonRects = new JSONObject();
        try {
            mJsonRects.put("webViewRect", (Object)VisibilityUtil.getViewJsonRect((View)this.mWebView));
            if (this.mNativeWindowRect == null) {
                this.mNativeWindowRect = VisibilityUtil.getScreenJsonRect();
            }
            mJsonRects.put("nativeWindowRect", (Object)this.mNativeWindowRect);
        }
        catch (JSONException e) {
            Logger.e(TAG, "getVisibleBounds :: " + e.toString());
        }
        return mJsonRects.toString();
    }

    private String getPlacementId(String placementName) {
        String placementId = this.mPlacementIdMap.get(placementName);
        if (placementId == null) {
            placementId = UUID.randomUUID().toString();
            this.mPlacementIdMap.put(placementName, placementId);
        }
        return placementId;
    }

    void setExtraProperties(Map<String, String> extraProperties) {
        String clickOverride;
        this.mIsUsedInTaboolaWidget = Boolean.parseBoolean(extraProperties.get("isUsedInTaboolaWidget"));
        if (this.mIsUsedInTaboolaWidget) {
            this.mMediatedVia = extraProperties.get("mediatedVia");
        }
        if ((clickOverride = extraProperties.get("allowNonOrganicClickOverride")) != null) {
            this.mShouldAllowNonOrganicClickOverride = Boolean.parseBoolean(clickOverride);
        }
        this.mExtraData = extraProperties;
    }

    boolean isAlive() {
        return this.mIsAlive;
    }

    WebView getWebView() {
        return this.mWebView;
    }

    OnRenderListener getOnRenderListener() {
        return this.mOnRenderListener;
    }

    void setOnRenderListener(@Nullable OnRenderListener onRenderListener) {
        this.mOnRenderListener = onRenderListener;
    }

    OnResizeListener getOnResizeListener() {
        return this.mOnResizeListener;
    }

    void setOnResizeListener(@Nullable OnResizeListener onResizeListener) {
        this.mOnResizeListener = onResizeListener;
    }

    Boolean shouldAllowNonOrganicClickOverride() {
        return this.mShouldAllowNonOrganicClickOverride;
    }

    boolean isSdkMonitorEnabled() {
        return TaboolaJs.getInstance().isSdkMonitorEnabled();
    }

    void sendRenderSuccessful(final String placementName) {
        final String placementId = this.getPlacementId(placementName);
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                TaboolaJs.getInstance().getSdkMonitorManager().sendWebPlacementRenderSuccess(placementId, WebViewManager.this.getSdkType(), placementName, WebViewManager.this.mWebViewMessenger);
            }
        });
    }

    public void prepareAndSendParamsToMonitor(String placementName, HashMap<String, String> parameters) {
        if (this.isSdkMonitorEnabled()) {
            String placementId = this.getPlacementId(placementName);
            TaboolaJs.getInstance().sendWebPlacementFetchContent(placementId, this.getSdkType(), placementName, parameters);
        }
    }

    void sendRenderFailed(final String placementName) {
        final String placementId = this.getPlacementId(placementName);
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                TaboolaJs.getInstance().getSdkMonitorManager().sendWebPlacementRenderFailed(placementId, WebViewManager.this.getSdkType(), placementName, WebViewManager.this.mWebViewMessenger);
            }
        });
    }

    void sendMonitorData(String placementName, final String data, final String html) {
        final String placementId = this.mPlacementIdMap.get(placementName);
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                TaboolaJs.getInstance().getSdkMonitorManager().sendWebPlacementMonitorData(placementId, data, html);
            }
        });
    }

    void sendPlacementClicked(String placementName) {
        final String placementId = this.getPlacementId(placementName);
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                TaboolaJs.getInstance().getSdkMonitorManager().sendWebPlacementClicked(placementId);
            }
        });
    }

    public void setTag(String tag) {
        this.mTag = tag;
    }

    public String getTag() {
        return this.mTag;
    }

    public void addJsInitDataObserver(JsInitDataObserver jsDataObserver) {
        this.injectedObject.addJsInitDataObserver(jsDataObserver);
    }

    private static class JsMonitorHandler
    extends Handler {
        private final WeakReference<WebViewManager> mWebViewManagerWeakReference;

        JsMonitorHandler(WebViewManager webViewManager) {
            this.mWebViewManagerWeakReference = new WeakReference<WebViewManager>(webViewManager);
        }

        public void handleMessage(Message msg) {
            WebViewManager webViewManager = (WebViewManager)this.mWebViewManagerWeakReference.get();
            if (webViewManager != null) {
                switch (msg.what) {
                    case 291: {
                        String placementName = msg.getData().getString("PLACEMENT_NAME_BUNDLE_KEY");
                        webViewManager.emitTaboolaBridgeEvent(WebViewManager.HIGHTLIGHT_PLACEMENT, placementName);
                        break;
                    }
                    case 231: {
                        String placementName = msg.getData().getString("PLACEMENT_NAME_BUNDLE_KEY");
                        String newProperties = msg.getData().getString("WEB_NEW_PROPERTIES_JSON_BUNDLE_KEY");
                        StringBuilder editProp = new StringBuilder();
                        editProp.append(placementName).append(",").append(newProperties);
                        webViewManager.emitTaboolaBridgeEvent(WebViewManager.EDIT_PROPERTIES, editProp.toString());
                        break;
                    }
                }
            }
        }
    }
}

