/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.api;

import android.os.Parcel;
import android.os.Parcelable;
import com.taboola.android.api.PublicApi;
import java.util.HashMap;
import java.util.Map;

public class TBPlacementRequest
implements PublicApi.PublicTBPlacementRequest,
Parcelable {
    private int mId = 0;
    private int mBatchCounter = 0;
    private String mName;
    private int mRecCount;
    private String mTargetType;
    private int mThumbnailWidth;
    private int mThumbnailHeight;
    private boolean mIsVisible;
    private boolean mIsAvailable;
    public static final Parcelable.Creator<TBPlacementRequest> CREATOR = new Parcelable.Creator<TBPlacementRequest>(){

        public TBPlacementRequest createFromParcel(Parcel in) {
            return new TBPlacementRequest(in);
        }

        public TBPlacementRequest[] newArray(int size) {
            return new TBPlacementRequest[size];
        }
    };

    public TBPlacementRequest(String name, int recCount) {
        this.initDefaultValues();
        this.setRecCount(recCount);
        this.setName(name);
    }

    protected TBPlacementRequest(Parcel in) {
        this.mId = in.readInt();
        this.mBatchCounter = in.readInt();
        this.mName = in.readString();
        this.mRecCount = in.readInt();
        this.mTargetType = in.readString();
        this.mThumbnailWidth = in.readInt();
        this.mThumbnailHeight = in.readInt();
        this.mIsVisible = in.readByte() != 0;
        this.mIsAvailable = in.readByte() != 0;
    }

    @Override
    public TBPlacementRequest setName(String name) {
        this.mName = name;
        return this;
    }

    @Override
    public TBPlacementRequest setRecCount(int recCount) {
        this.mRecCount = recCount;
        return this;
    }

    public int getRecCount() {
        return this.mRecCount;
    }

    @Override
    public TBPlacementRequest setTargetType(String targetType) {
        this.mTargetType = targetType;
        return this;
    }

    @Override
    public TBPlacementRequest setThumbnailSize(int width, int height) {
        this.mThumbnailWidth = width;
        this.mThumbnailHeight = height;
        return this;
    }

    public TBPlacementRequest setAvailable(boolean available) {
        this.mIsAvailable = available;
        return this;
    }

    TBPlacementRequest setVisible(boolean visible) {
        this.mIsVisible = visible;
        return this;
    }

    TBPlacementRequest setId(int id) {
        this.mId = id;
        return this;
    }

    String getName() {
        return this.mName;
    }

    int getId() {
        return this.mId;
    }

    int getThumbnailWidth() {
        return this.mThumbnailWidth;
    }

    int getThumbnailHeight() {
        return this.mThumbnailHeight;
    }

    boolean getAvailable() {
        return this.mIsAvailable;
    }

    TBPlacementRequest incrementBatchCounter() {
        ++this.mBatchCounter;
        return this;
    }

    int getBatchCounter() {
        return this.mBatchCounter;
    }

    Map<String, String> generatePlacementQueryParameters() {
        if (this.mId == 0) {
            throw new IllegalArgumentException("Placement id is not set");
        }
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        if (this.mBatchCounter == 0) {
            queryParameters.put("placement" + this.mId + ".name", this.mName);
        } else {
            queryParameters.put("placement" + this.mId + ".name", this.mName + " " + this.mBatchCounter);
        }
        queryParameters.put("placement" + this.mId + ".rec-count", String.valueOf(this.mRecCount));
        queryParameters.put("placement" + this.mId + ".organic-type", this.mTargetType);
        if (this.mThumbnailWidth != 0 && this.mThumbnailHeight != 0) {
            queryParameters.put("placement" + this.mId + ".thumbnail.width", String.valueOf(this.mThumbnailWidth));
            queryParameters.put("placement" + this.mId + ".thumbnail.height", String.valueOf(this.mThumbnailHeight));
        }
        queryParameters.put("placement" + this.mId + ".visible", String.valueOf(this.mIsVisible));
        queryParameters.put("placement" + this.mId + ".available", String.valueOf(this.mIsAvailable));
        return queryParameters;
    }

    private void initDefaultValues() {
        this.setTargetType("mix");
        this.setVisible(false);
        this.setAvailable(true);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeInt(this.mBatchCounter);
        dest.writeString(this.mName);
        dest.writeInt(this.mRecCount);
        dest.writeString(this.mTargetType);
        dest.writeInt(this.mThumbnailWidth);
        dest.writeInt(this.mThumbnailHeight);
        dest.writeByte((byte)(this.mIsVisible ? 1 : 0));
        dest.writeByte((byte)(this.mIsAvailable ? 1 : 0));
    }
}

