/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.api;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.taboola.android.api.PublicApi;
import com.taboola.android.api.TBPlacementRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TBRecommendationsRequest
implements PublicApi.PublicTBRecommendationsRequest,
Parcelable {
    private static final String TAG = TBRecommendationsRequest.class.getSimpleName();
    private HashMap<String, TBPlacementRequest> mPlacementRequests = new HashMap();
    private HashMap<String, String> mQueryParameters = new HashMap();
    public static final Parcelable.Creator<TBRecommendationsRequest> CREATOR = new Parcelable.Creator<TBRecommendationsRequest>(){

        public TBRecommendationsRequest createFromParcel(Parcel in) {
            return new TBRecommendationsRequest(in);
        }

        public TBRecommendationsRequest[] newArray(int size) {
            return new TBRecommendationsRequest[size];
        }
    };

    private TBRecommendationsRequest() {
    }

    public TBRecommendationsRequest(String pageUrl, String sourceType) {
        this.setPageUrl(pageUrl);
        this.setSourceType(sourceType);
    }

    protected TBRecommendationsRequest(Parcel in) {
        Bundle mapsBundle = in.readBundle(this.getClass().getClassLoader());
        Serializable placementRequests = mapsBundle.getSerializable("placementRequests");
        Serializable queryParameters = mapsBundle.getSerializable("queryParameters");
        this.mPlacementRequests = (HashMap)placementRequests;
        this.mQueryParameters = (HashMap)queryParameters;
    }

    @Override
    public TBRecommendationsRequest addPlacementRequest(TBPlacementRequest placementRequest) {
        if (this.mPlacementRequests.containsKey(placementRequest.getName())) {
            throw new IllegalArgumentException("TBPlacementRequest with the same placementName already exists in this TBRecommendationsRequest");
        }
        int nextPlacementId = this.mPlacementRequests.size() + 1;
        placementRequest.setId(nextPlacementId);
        this.mPlacementRequests.put(placementRequest.getName(), placementRequest);
        return this;
    }

    @Override
    public TBRecommendationsRequest setSourceType(String sourceType) {
        this.mQueryParameters.put("source.type", sourceType);
        return this;
    }

    @Override
    public TBRecommendationsRequest setPageUrl(String pageUrl) {
        this.setSourceId(this.extractSourceId(pageUrl));
        this.setSourceUrl(pageUrl);
        return this;
    }

    @Override
    public TBRecommendationsRequest setUserReferrer(String userReferrer) {
        this.mQueryParameters.put("user.referrer", userReferrer);
        return this;
    }

    @Override
    public TBRecommendationsRequest setUserUnifiedId(String userUnifiedId) {
        this.mQueryParameters.put("user.unified-id", userUnifiedId);
        return this;
    }

    public TBRecommendationsRequest setSourceId(String sourceId) {
        this.mQueryParameters.put("source.id", sourceId);
        return this;
    }

    TBRecommendationsRequest setDeviceId(String deviceId) {
        this.mQueryParameters.put("device.id", deviceId);
        return this;
    }

    TBRecommendationsRequest setViewId(String viewId) {
        this.mQueryParameters.put("view.id", viewId);
        return this;
    }

    TBRecommendationsRequest setUserSession(String userSession) {
        this.mQueryParameters.put("user.session", userSession);
        return this;
    }

    TBRecommendationsRequest setAppType(String appType) {
        this.mQueryParameters.put("app.type", appType);
        return this;
    }

    TBRecommendationsRequest setApiKey(String apiKey) {
        this.mQueryParameters.put("app.apikey", apiKey);
        return this;
    }

    TBRecommendationsRequest setAppName(String appName) {
        this.mQueryParameters.put("app.name", appName);
        return this;
    }

    TBRecommendationsRequest setApiParam(String key, String value) {
        this.mQueryParameters.put(key, value);
        return this;
    }

    TBRecommendationsRequest setAdditionalData(String additionalData) {
        this.mQueryParameters.put("ad", additionalData);
        return this;
    }

    HashMap<String, TBPlacementRequest> getPlacementRequests() {
        return this.mPlacementRequests;
    }

    private TBRecommendationsRequest setSourceUrl(String sourceUrl) {
        this.mQueryParameters.put("source.url", sourceUrl);
        return this;
    }

    private TBRecommendationsRequest setQueryParameters(HashMap<String, String> queryParameters) {
        this.mQueryParameters = queryParameters;
        return this;
    }

    HashMap<String, String> generateQueryParameters() {
        HashMap<String, String> combinedParameters = new HashMap<String, String>(this.mQueryParameters);
        for (Map.Entry<String, TBPlacementRequest> placementEntry : this.mPlacementRequests.entrySet()) {
            combinedParameters.putAll(placementEntry.getValue().generatePlacementQueryParameters());
        }
        return combinedParameters;
    }

    TBRecommendationsRequest createNextBatchRequest(String placementName) {
        TBRecommendationsRequest nextBatchRequest = new TBRecommendationsRequest();
        nextBatchRequest.setQueryParameters(this.mQueryParameters);
        TBPlacementRequest oldPlacementRequest = this.mPlacementRequests.get(placementName);
        if (oldPlacementRequest == null) {
            oldPlacementRequest = this.mPlacementRequests.values().iterator().next();
        }
        TBPlacementRequest newPlacementRequest = oldPlacementRequest;
        newPlacementRequest.incrementBatchCounter();
        nextBatchRequest.addPlacementRequest(newPlacementRequest);
        return nextBatchRequest;
    }

    private String extractSourceId(String pageUrl) {
        Uri uri = Uri.parse((String)pageUrl);
        String authority = uri.getAuthority();
        int authorityEndIndex = pageUrl.indexOf(authority) + authority.length();
        String sourceId = pageUrl.substring(authorityEndIndex);
        if (sourceId.isEmpty()) {
            return "/";
        }
        return sourceId;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle mapsBundle = new Bundle();
        mapsBundle.putSerializable("placementRequests", this.mPlacementRequests);
        mapsBundle.putSerializable("queryParameters", this.mQueryParameters);
        dest.writeBundle(mapsBundle);
    }
}

