/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.monitor;

import android.util.SparseArray;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.taboola.android.monitor.TBMobileLoaderChange;
import com.taboola.android.monitor.TBSuspendMonitor;
import com.taboola.android.monitor.TBUrlParamsChange;
import com.taboola.android.utils.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class TBSdkFeature
implements Serializable {
    private static final String TAG = "TBSdkFeature";
    @SerializedName(value="type")
    private final int sdkFeatureType;

    TBSdkFeature(int type) {
        this.sdkFeatureType = type;
    }

    public Integer getKey() {
        return this.sdkFeatureType;
    }

    public static SparseArray<TBSdkFeature> parseSdkFeatures(String sdkFeaturesString) {
        return Parser.parseSdkFeatures(sdkFeaturesString);
    }

    private static class Parser {
        static List<Class<? extends TBSdkFeature>> CLASS_LIST = new ArrayList<Class<? extends TBSdkFeature>>();
        private static Gson mGson;

        private Parser() {
        }

        private static SparseArray<TBSdkFeature> parseSdkFeatures(String sdkFeaturesString) {
            SparseArray sdkFeatures = new SparseArray();
            try {
                JSONObject sdkFeaturesJsonObject = new JSONObject(sdkFeaturesString);
                for (Class<? extends TBSdkFeature> clazz : CLASS_LIST) {
                    Parser.setFeature(sdkFeaturesJsonObject, clazz, (SparseArray<TBSdkFeature>)sdkFeatures);
                }
            }
            catch (Exception e) {
                Logger.e(TBSdkFeature.TAG, e.toString(), e);
            }
            return sdkFeatures;
        }

        private static void setFeature(JSONObject jsonObject, Class<? extends TBSdkFeature> clazz, SparseArray<TBSdkFeature> sdkFeatures) {
            try {
                int keyInt = clazz.getField("KEY").getInt(null);
                JSONObject sdkFeatureJsonObject = jsonObject.optJSONObject(String.valueOf(keyInt));
                if (sdkFeatureJsonObject != null) {
                    TBSdkFeature t = (TBSdkFeature)mGson.fromJson(sdkFeatureJsonObject.toString(), clazz);
                    sdkFeatures.put(keyInt, (Object)t);
                }
            }
            catch (Exception e) {
                Logger.e(TBSdkFeature.TAG, e.toString(), e);
            }
        }

        static {
            CLASS_LIST.add(TBMobileLoaderChange.class);
            CLASS_LIST.add(TBSuspendMonitor.class);
            CLASS_LIST.add(TBUrlParamsChange.class);
            mGson = new Gson();
        }
    }
}

