/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.WebView;
import com.taboola.android.listeners.ScrollToTopListener;
import com.taboola.android.utils.SdkDetailsHelper;

public class TaboolaWebView
extends WebView {
    float mOldPointY = 0.0f;
    float mDeltaY;
    final int[] mViewLocation = new int[2];
    int mTopScrollview = -1;
    boolean mShouldInterceptScroll = false;
    boolean mScrolledToTop;
    ScrollToTopListener mScrollTopListener;

    public TaboolaWebView(Context context) {
        super(context);
    }

    public TaboolaWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TaboolaWebView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public boolean isScrolledToTop() {
        return this.mScrolledToTop;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        View scrollviewParent = SdkDetailsHelper.getParentScrollView((View)this);
        if (scrollviewParent != null) {
            int[] loc = new int[2];
            scrollviewParent.getLocationOnScreen(loc);
            this.mTopScrollview = loc[1];
        }
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        boolean bl = this.mScrolledToTop = this.getScrollY() == 0;
        if (this.mScrollTopListener != null && this.mScrolledToTop && t - oldt <= 0) {
            this.mScrollTopListener.onTaboolaWidgetOnTop();
        }
        super.onScrollChanged(l, t, oldl, oldt);
    }

    public void registerScrollToTopListener(ScrollToTopListener scrollListener) {
        this.mScrollTopListener = scrollListener;
    }

    public void unregisterScrollToTopListener() {
        this.mScrollTopListener = null;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mShouldInterceptScroll && this.mTopScrollview > -1) {
            this.getLocationOnScreen(this.mViewLocation);
            if (this.mViewLocation[1] <= this.mTopScrollview) {
                switch (event.getAction()) {
                    case 0: {
                        this.mOldPointY = event.getY();
                        break;
                    }
                    case 2: {
                        this.mDeltaY = this.mOldPointY - event.getY();
                        break;
                    }
                    default: {
                        return super.onTouchEvent(event);
                    }
                }
                if (!this.canScrollVertically(-1) && this.mDeltaY < 0.0f) {
                    this.requestDisallowInterceptTouchEvent(false);
                } else {
                    this.requestDisallowInterceptTouchEvent(true);
                }
            }
        }
        return super.onTouchEvent(event);
    }
}

