/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.utils.io;

import com.syntaxphoenix.syntaxapi.utils.io.Serializer;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;

public interface TextSerializer<T>
extends Serializer<T> {
    public void toWriter(T var1, Writer var2) throws IOException;

    default public char[] toCharArray(T object) throws IOException {
        CharArrayWriter writer = new CharArrayWriter();
        this.toWriter(object, writer);
        return writer.toCharArray();
    }

    default public String toString(T object) throws IOException {
        StringWriter writer = new StringWriter();
        this.toWriter(object, writer);
        return ((Object)writer).toString();
    }

    @Override
    default public void toStream(T object, OutputStream stream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(stream);
        this.toWriter(object, writer);
        ((Writer)writer).flush();
    }

    @Override
    default public void toFile(T object, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            this.toWriter(object, writer);
        }
    }
}

