/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.utils.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public interface Serializer<T> {
    public void toStream(T var1, OutputStream var2) throws IOException;

    default public void toFile(T object, File file) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(file);
             BufferedOutputStream buffStream = new BufferedOutputStream(stream);){
            this.toStream(object, buffStream);
        }
    }

    default public byte[] toBytes(T object, int capacity) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(capacity);
        this.toStream(object, stream);
        stream.close();
        return stream.toByteArray();
    }

    default public byte[] toBytes(T object) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.toStream(object, stream);
        stream.close();
        return stream.toByteArray();
    }
}

