/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.utils.io;

import com.syntaxphoenix.syntaxapi.utils.io.Deserializer;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

public interface TextDeserializer<T>
extends Deserializer<T> {
    public T fromReader(Reader var1) throws IOException;

    default public T fromCharArray(char[] chars) throws IOException {
        return this.fromReader(new CharArrayReader(chars));
    }

    default public T fromString(String str) throws IOException {
        return this.fromReader(new StringReader(str));
    }

    @Override
    default public T fromStream(InputStream stream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            T t = this.fromReader(reader);
            return t;
        }
    }

    @Override
    default public T fromFile(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            T t = this.fromReader(reader);
            return t;
        }
    }
}

