/*
 * Decompiled with CFR 0.152.
 */
package com.sygic.maps.uikit.views.navigation.speed;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import com.sygic.maps.uikit.views.R;
import com.sygic.maps.uikit.views.common.extensions.ViewExtensionsKt;
import com.sygic.maps.uikit.views.navigation.speed.SpeedProgressViewKt;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001>B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0014J\u0018\u00109\u001a\u0002062\u0006\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u0007H\u0014J\u0010\u0010<\u001a\u0002062\u0006\u0010=\u001a\u00020'H\u0002R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0019@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018R&\u0010\"\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00078\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R&\u0010(\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020'8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010/\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0016\"\u0004\b1\u0010\u0018R$\u00102\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010$\"\u0004\b4\u0010&\u00a8\u0006?"}, d2={"Lcom/sygic/maps/uikit/views/navigation/speed/SpeedProgressView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "backgroundPaint", "Lcom/sygic/maps/uikit/views/navigation/speed/SpeedProgressView$SegmentPaint;", "backgroundPath", "Landroid/graphics/Path;", "foregroundPaint", "foregroundPath", "oval", "Landroid/graphics/RectF;", "value", "", "progress", "getProgress", "()F", "setProgress", "(F)V", "", "roundSegmentEdges", "getRoundSegmentEdges", "()Z", "setRoundSegmentEdges", "(Z)V", "segmentAngle", "getSegmentAngle", "setSegmentAngle", "segmentBackgroundColor", "getSegmentBackgroundColor", "()I", "setSegmentBackgroundColor", "(I)V", "", "segmentForegroundColors", "getSegmentForegroundColors", "()[I", "setSegmentForegroundColors", "([I)V", "segmentForegroundGradient", "Landroid/graphics/Shader;", "segmentSpacing", "getSegmentSpacing", "setSegmentSpacing", "segmentThickness", "getSegmentThickness", "setSegmentThickness", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "updateSegmentForegroundGradient", "colors", "SegmentPaint", "uikit-views-2.9.0_release"})
public final class SpeedProgressView
extends View {
    private final RectF oval;
    private final Path foregroundPath;
    private final Path backgroundPath;
    private final SegmentPaint foregroundPaint;
    private final SegmentPaint backgroundPaint;
    private float progress;
    private boolean roundSegmentEdges;
    private Shader segmentForegroundGradient;
    @ColorInt
    @NotNull
    private int[] segmentForegroundColors;
    @ColorInt
    private int segmentBackgroundColor;
    private float segmentAngle;
    private int segmentThickness;
    private float segmentSpacing;
    private HashMap _$_findViewCache;

    public final float getProgress() {
        return this.progress;
    }

    public final void setProgress(float value) {
        this.progress = value < 0.0f ? 0.0f : (value > 100.0f ? 100.0f : value);
        this.invalidate();
    }

    public final boolean getRoundSegmentEdges() {
        return this.roundSegmentEdges;
    }

    public final void setRoundSegmentEdges(boolean value) {
        this.roundSegmentEdges = value;
        this.foregroundPaint.setStrokeCap(value ? Paint.Cap.ROUND : Paint.Cap.BUTT);
        this.backgroundPaint.setStrokeCap(value ? Paint.Cap.ROUND : Paint.Cap.BUTT);
        this.invalidate();
    }

    @NotNull
    public final int[] getSegmentForegroundColors() {
        return this.segmentForegroundColors;
    }

    public final void setSegmentForegroundColors(@NotNull int[] value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.segmentForegroundColors = value;
        this.updateSegmentForegroundGradient(value);
        this.invalidate();
    }

    public final int getSegmentBackgroundColor() {
        return this.segmentBackgroundColor;
    }

    public final void setSegmentBackgroundColor(int value) {
        this.segmentBackgroundColor = value;
        this.backgroundPaint.setColor(value);
        this.invalidate();
    }

    public final float getSegmentAngle() {
        return this.segmentAngle;
    }

    public final void setSegmentAngle(float value) {
        this.segmentAngle = value;
        this.invalidate();
    }

    public final int getSegmentThickness() {
        return this.segmentThickness;
    }

    public final void setSegmentThickness(int value) {
        this.segmentThickness = value;
        this.foregroundPaint.setStrokeWidth(value);
        this.backgroundPaint.setStrokeWidth(value);
        this.invalidate();
    }

    public final float getSegmentSpacing() {
        return this.segmentSpacing;
    }

    public final void setSegmentSpacing(float value) {
        this.segmentSpacing = value;
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int n = View.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int n2 = View.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        boolean bl = false;
        int min = Math.min(n, n2);
        this.setMeasuredDimension(min, min);
        this.updateSegmentForegroundGradient(this.segmentForegroundColors);
        this.oval.set((float)this.segmentThickness / (float)2, (float)this.segmentThickness / (float)2, (float)min - (float)this.segmentThickness / (float)2, (float)min - (float)this.segmentThickness / (float)2);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.rotate(90.0f, (float)this.getWidth() / (float)2, (float)this.getHeight() / (float)2);
        float stepAngle = this.segmentAngle * this.segmentSpacing;
        float stepWithSpacing = this.segmentAngle + stepAngle;
        float rest = 270.0f % stepWithSpacing;
        float startEndGap = rest / (float)2;
        float drawStartPoint = 45.0f + startEndGap;
        Object object = this.backgroundPath;
        Canvas canvas2 = canvas;
        boolean bl = false;
        boolean bl2 = false;
        Path $this$apply22 = object;
        boolean bl3 = false;
        $this$apply22.reset();
        float drawEndPoint2 = 315.0f - startEndGap - stepWithSpacing;
        SpeedProgressViewKt.access$addArcs($this$apply22, this.oval, drawStartPoint, drawEndPoint2, stepAngle, stepWithSpacing, this.segmentAngle);
        Path path = object;
        canvas2.drawPath(path, (Paint)this.backgroundPaint);
        object = this.segmentForegroundColors;
        bl = false;
        Object object2 = object;
        boolean $this$apply22 = false;
        if (!(((Path)object2).length == 0)) {
            boolean bl4;
            Shader drawEndPoint2;
            object = this.foregroundPaint;
            bl = false;
            boolean bl5 = false;
            Object $this$apply = object;
            boolean bl6 = false;
            Shader shader = this.segmentForegroundGradient;
            if (shader != null) {
                drawEndPoint2 = shader;
                bl4 = false;
                boolean bl7 = false;
                Shader it = drawEndPoint2;
                boolean bl8 = false;
                $this$apply.setShader(it);
                $this$apply.setAntiAlias(true);
            } else {
                drawEndPoint2 = $this$apply;
                bl4 = false;
                boolean bl9 = false;
                Shader $this$run = drawEndPoint2;
                boolean bl10 = false;
                $this$run.setColor(ArraysKt.first((int[])this.segmentForegroundColors));
            }
            object = this.foregroundPath;
            canvas2 = canvas;
            bl = false;
            bl5 = false;
            $this$apply = object;
            boolean bl11 = false;
            $this$apply.reset();
            float angle = 270.0f * this.progress / 100.0f + 45.0f;
            float drawEndPoint3 = angle - startEndGap;
            if (this.progress == 100.0f) {
                drawEndPoint3 -= stepWithSpacing;
            }
            SpeedProgressViewKt.access$addArcs($this$apply, this.oval, drawStartPoint, drawEndPoint3, stepAngle, stepWithSpacing, this.segmentAngle);
            path = object;
            canvas2.drawPath(path, (Paint)this.foregroundPaint);
        }
    }

    private final void updateSegmentForegroundGradient(int[] colors) {
        this.segmentForegroundGradient = colors.length >= 2 ? (Shader)new SweepGradient((float)this.getMeasuredWidth() / (float)2, (float)this.getMeasuredHeight() / (float)2, colors, null) : null;
    }

    @JvmOverloads
    public SpeedProgressView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            super(context, attrs, defStyleAttr, defStyleRes);
            this.oval = new RectF();
            this.foregroundPath = new Path();
            this.backgroundPath = new Path();
            this.foregroundPaint = new SegmentPaint();
            this.backgroundPaint = new SegmentPaint();
            this.segmentForegroundColors = new int[0];
            this.segmentBackgroundColor = ViewExtensionsKt.getColor(this, R.color.speedProgressBackgroundColor);
            this.segmentAngle = this.getResources().getInteger(R.integer.speedProgressViewSegmentAngle);
            this.segmentThickness = this.getResources().getDimensionPixelSize(R.dimen.speedProgressViewSegmentThickness);
            this.segmentSpacing = this.getResources().getFraction(R.fraction.speedProgressViewSegmentSpacing, 1, 1);
            AttributeSet attributeSet = attrs;
            if (attributeSet == null) break block0;
            AttributeSet attributeSet2 = attributeSet;
            boolean bl = false;
            boolean bl2 = false;
            AttributeSet attributeSet3 = attributeSet2;
            boolean bl3 = false;
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet3, R.styleable.SpeedProgressView, defStyleAttr, defStyleRes);
            boolean bl4 = false;
            boolean bl5 = false;
            TypedArray it = typedArray;
            boolean bl6 = false;
            this.setRoundSegmentEdges(it.getBoolean(R.styleable.SpeedProgressView_roundSegmentEdges, this.roundSegmentEdges));
            this.setSegmentBackgroundColor(it.getInt(R.styleable.SpeedProgressView_segmentBackgroundColor, this.segmentBackgroundColor));
            int[] nArray = this.getResources().getIntArray(it.getResourceId(R.styleable.SpeedProgressView_segmentForegroundColors, R.array.speedProgressForegroundColors));
            Intrinsics.checkExpressionValueIsNotNull((Object)nArray, (String)"resources.getIntArray(\n \u2026      )\n                )");
            this.setSegmentForegroundColors(nArray);
            this.setSegmentAngle(it.getInt(R.styleable.SpeedProgressView_segmentAngle, (int)this.segmentAngle));
            this.setSegmentThickness(it.getDimensionPixelSize(R.styleable.SpeedProgressView_segmentThickness, this.segmentThickness));
            this.setSegmentSpacing(it.getFraction(R.styleable.SpeedProgressView_segmentSpacing, 1, 1, this.segmentSpacing));
            typedArray.recycle();
        }
    }

    public /* synthetic */ SpeedProgressView(Context context, AttributeSet attributeSet, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            attributeSet = null;
        }
        if ((n3 & 4) != 0) {
            n = R.attr.speedProgressViewStyle;
        }
        if ((n3 & 8) != 0) {
            n2 = R.style.SygicSpeedProgressViewStyle;
        }
        this(context, attributeSet, n, n2);
    }

    @JvmOverloads
    public SpeedProgressView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0, 8, null);
    }

    @JvmOverloads
    public SpeedProgressView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 0, 12, null);
    }

    @JvmOverloads
    public SpeedProgressView(@NotNull Context context) {
        this(context, null, 0, 0, 14, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/sygic/maps/uikit/views/navigation/speed/SpeedProgressView$SegmentPaint;", "Landroid/graphics/Paint;", "(Lcom/sygic/maps/uikit/views/navigation/speed/SpeedProgressView;)V", "uikit-views-2.9.0_release"})
    public final class SegmentPaint
    extends Paint {
        public SegmentPaint() {
            super(1);
            this.setStyle(Paint.Style.STROKE);
        }
    }
}

