/*
 * Decompiled with CFR 0.152.
 */
package com.sygic.maps.uikit.views.navigation.lanes;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.core.content.ContextCompat;
import androidx.core.util.Pools;
import com.sygic.maps.uikit.views.R;
import com.sygic.maps.uikit.views.common.extensions.ContextExtensionsKt;
import com.sygic.maps.uikit.views.common.extensions.ResourcesExtensionsKt;
import com.sygic.maps.uikit.views.navigation.lanes.data.SimpleLanesData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u001cH\u0002J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0007H\u0016J\b\u0010&\u001a\u00020\u001eH\u0014J\u001b\u0010'\u001a\u00020\u001e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a2\u0006\u0002\u0010\u0013R\u0010\u0010\n\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/sygic/maps/uikit/views/navigation/lanes/SimpleLanesView;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "highlightedColor", "laneViewSize", "value", "", "Lcom/sygic/maps/uikit/views/navigation/lanes/data/SimpleLanesData;", "lanesData", "getLanesData", "()[Lcom/sygic/maps/uikit/views/navigation/lanes/data/SimpleLanesData;", "setLanesData", "([Lcom/sygic/maps/uikit/views/navigation/lanes/data/SimpleLanesData;)V", "[Lcom/sygic/maps/uikit/views/navigation/lanes/data/SimpleLanesData;", "layoutMargin", "layoutMarginBottom", "layoutMarginEnd", "layoutMarginStart", "layoutMarginTop", "viewPool", "Landroidx/core/util/Pools$SimplePool;", "Landroid/widget/ImageView;", "addView", "", "child", "Landroid/view/View;", "index", "params", "Landroid/view/ViewGroup$LayoutParams;", "createLaneView", "getChildAt", "onAttachedToWindow", "setLanesInternal", "lanes", "uikit-views-2.9.0_release"})
public class SimpleLanesView
extends LinearLayout {
    @NotNull
    private SimpleLanesData[] lanesData;
    private int layoutMargin;
    private int layoutMarginTop;
    private int layoutMarginBottom;
    private int layoutMarginStart;
    private int layoutMarginEnd;
    @ColorInt
    private final int highlightedColor;
    private final int laneViewSize;
    private final Pools.SimplePool<ImageView> viewPool;
    private HashMap _$_findViewCache;

    @NotNull
    public final SimpleLanesData[] getLanesData() {
        return this.lanesData;
    }

    public final void setLanesData(@NotNull SimpleLanesData[] value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.lanesData = value;
        this.setLanesInternal(value);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
        boolean bl = false;
        boolean bl2 = false;
        ViewGroup.MarginLayoutParams $this$with = marginLayoutParams;
        boolean bl3 = false;
        if (this.layoutMargin >= 0) {
            $this$with.setMargins(this.layoutMargin, this.layoutMargin, this.layoutMargin, this.layoutMargin);
        } else {
            $this$with.setMargins(this.layoutMarginStart, this.layoutMarginTop, this.layoutMarginEnd, this.layoutMarginBottom);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setLanesInternal(SimpleLanesData[] lanes) {
        int i;
        int n;
        int lanesCount = lanes.length;
        if (lanesCount < this.getChildCount()) {
            int n2 = this.getChildCount() - 1;
            if (n2 >= (n = lanesCount)) {
                while (true) {
                    this.viewPool.release((Object)this.getChildAt(i));
                    this.removeViewAt(i);
                    if (i != n) {
                        --i;
                        continue;
                    }
                    break;
                }
            }
        } else if (lanesCount > this.getChildCount()) {
            n = lanesCount;
            for (i = this.getChildCount(); i < n; ++i) {
                ImageView imageView = (ImageView)this.viewPool.acquire();
                this.addView(imageView != null ? (View)imageView : (View)this.createLaneView());
            }
        }
        Object[] $this$forEachIndexed$iv = ArraysKt.reversedArray((Object[])lanes);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Drawable[] drawables;
            Drawable drawable2;
            Collection collection;
            void $this$mapTo$iv$iv;
            void lane;
            int n3 = index$iv++;
            SimpleLanesData simpleLanesData = (SimpleLanesData)item$iv;
            int i2 = n3;
            boolean bl = false;
            Iterable $this$map$iv = lane.getDirections();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                int n4 = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv;
                boolean bl2 = false;
                drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)it);
                collection.add(drawable2);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new Drawable[0]) == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            LayerDrawable layerDrawable = new LayerDrawable(drawables);
            collection = this.getChildAt(i2);
            boolean bl3 = false;
            boolean bl4 = false;
            LayerDrawable $this$apply = layerDrawable;
            boolean bl5 = false;
            $this$apply.mutate();
            if (lane.getHighlighted()) {
                $this$apply.setTintMode(PorterDuff.Mode.SRC_ATOP);
                $this$apply.setTint(this.highlightedColor);
            }
            drawable2 = layerDrawable;
            collection.setImageDrawable(drawable2);
        }
    }

    private final ImageView createLaneView() {
        ImageView imageView = new ImageView(this.getContext());
        boolean bl = false;
        boolean bl2 = false;
        ImageView $this$apply = imageView;
        boolean bl3 = false;
        $this$apply.setBackgroundColor(0);
        $this$apply.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.laneViewSize, this.laneViewSize));
        $this$apply.setScaleType(ImageView.ScaleType.FIT_CENTER);
        return imageView;
    }

    @NotNull
    public ImageView getChildAt(int index) {
        View view = super.getChildAt(index);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.ImageView");
        }
        return (ImageView)view;
    }

    public void addView(@NotNull View child, int index, @NotNull ViewGroup.LayoutParams params) {
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        if (!(child instanceof ImageView)) {
            throw (Throwable)new UnsupportedOperationException("You can't add views to " + ((Object)((Object)this)).getClass().getName());
        }
        super.addView(child, index, params);
    }

    @JvmOverloads
    public SimpleLanesView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            super(context, attrs, defStyleAttr, defStyleRes);
            SimpleLanesView simpleLanesView = this;
            SimpleLanesData[] simpleLanesDataArray = new SimpleLanesData[]{};
            simpleLanesView.lanesData = simpleLanesDataArray;
            this.highlightedColor = ContextExtensionsKt.getColorFromAttr$default(context, R.attr.navigationTextColorTertiary, null, false, 6, null);
            this.laneViewSize = this.getResources().getDimensionPixelSize(R.dimen.simpleLaneSize);
            this.viewPool = new Pools.SimplePool(10);
            this.setOrientation(0);
            this.setGravity(1);
            Resources resources = this.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
            int n = (int)ResourcesExtensionsKt.dpToPixels(resources, 8.0f);
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            this.setPadding(it, it, it, it);
            AttributeSet attributeSet = attrs;
            if (attributeSet == null) break block0;
            AttributeSet attributeSet2 = attributeSet;
            bl = false;
            bl2 = false;
            AttributeSet attributeSet3 = attributeSet2;
            boolean bl4 = false;
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet3, R.styleable.SimpleLanesView, defStyleAttr, defStyleRes);
            boolean bl5 = false;
            boolean bl6 = false;
            TypedArray it2 = typedArray;
            boolean bl7 = false;
            this.layoutMargin = it2.getDimensionPixelSize(R.styleable.SimpleLanesView_android_layout_margin, -1);
            this.layoutMarginTop = it2.getDimensionPixelSize(R.styleable.SimpleLanesView_android_layout_marginTop, 0);
            this.layoutMarginBottom = it2.getDimensionPixelSize(R.styleable.SimpleLanesView_android_layout_marginBottom, 0);
            this.layoutMarginStart = it2.getDimensionPixelSize(R.styleable.SimpleLanesView_android_layout_marginStart, 0);
            this.layoutMarginEnd = it2.getDimensionPixelSize(R.styleable.SimpleLanesView_android_layout_marginEnd, 0);
            typedArray.recycle();
        }
    }

    public /* synthetic */ SimpleLanesView(Context context, AttributeSet attributeSet, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            attributeSet = null;
        }
        if ((n3 & 4) != 0) {
            n = R.attr.lanesViewStyle;
        }
        if ((n3 & 8) != 0) {
            n2 = R.style.SygicLanesViewStyle;
        }
        this(context, attributeSet, n, n2);
    }

    @JvmOverloads
    public SimpleLanesView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0, 8, null);
    }

    @JvmOverloads
    public SimpleLanesView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 0, 12, null);
    }

    @JvmOverloads
    public SimpleLanesView(@NotNull Context context) {
        this(context, null, 0, 0, 14, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

