/*
 * Decompiled with CFR 0.152.
 */
package com.sygic.maps.uikit.views.common.utils;

import com.sygic.maps.uikit.views.common.extensions.FloatExtensionsKt;
import com.sygic.maps.uikit.views.common.units.DistanceUnit;
import com.sygic.maps.uikit.views.common.utils.Distance$WhenMappings;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/sygic/maps/uikit/views/common/utils/Distance;", "", "()V", "DECIMAL_FORMAT", "Ljava/text/DecimalFormat;", "IMPERIALS_FEET_DISTANCE_UNIT", "", "IMPERIALS_MI_DISTANCE_UNIT", "IMPERIALS_YARD_DISTANCE_UNIT", "METRIC_KM_DISTANCE_UNIT", "METRIC_M_DISTANCE_UNIT", "M_TO_FT_CONVERSION_RATIO", "", "M_TO_KM_CONVERSION_RATIO", "M_TO_MI_CONVERSION_RATIO", "M_TO_YD_CONVERSION_RATIO", "getDistanceInMilesWithUnits", "meters", "", "smallUnitConversionRatio", "smallUnitText", "roundSmallUnits", "", "getFormattedDistance", "distanceUnit", "Lcom/sygic/maps/uikit/views/common/units/DistanceUnit;", "distanceInMeters", "roundDistance", "distance", "uikit-views-2.9.0_release"})
public final class Distance {
    private static final String METRIC_KM_DISTANCE_UNIT = "km";
    private static final String METRIC_M_DISTANCE_UNIT = "m";
    private static final String IMPERIALS_MI_DISTANCE_UNIT = "mi";
    private static final String IMPERIALS_FEET_DISTANCE_UNIT = "ft";
    private static final String IMPERIALS_YARD_DISTANCE_UNIT = "yd";
    private static final float M_TO_KM_CONVERSION_RATIO = 0.001f;
    private static final float M_TO_MI_CONVERSION_RATIO = 6.2E-4f;
    private static final float M_TO_FT_CONVERSION_RATIO = 3.28084f;
    private static final float M_TO_YD_CONVERSION_RATIO = 1.09361f;
    private static final DecimalFormat DECIMAL_FORMAT;
    public static final Distance INSTANCE;

    @NotNull
    public final String getFormattedDistance(@NotNull DistanceUnit distanceUnit, int distanceInMeters, boolean roundSmallUnits) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)((Object)distanceUnit), (String)"distanceUnit");
        switch (Distance$WhenMappings.$EnumSwitchMapping$0[distanceUnit.ordinal()]) {
            case 1: {
                float kilometers = (float)distanceInMeters * 0.001f;
                if (kilometers >= (float)10) {
                    string2 = MathKt.roundToInt((float)kilometers) + " km";
                    break;
                }
                if (kilometers >= 1.0f) {
                    string2 = DECIMAL_FORMAT.format(kilometers) + " km";
                    break;
                }
                if (roundSmallUnits) {
                    string2 = this.getFormattedDistance(distanceUnit, this.roundDistance(distanceInMeters), false);
                    break;
                }
                string2 = distanceInMeters + " m";
                break;
            }
            case 2: {
                string2 = this.getDistanceInMilesWithUnits(distanceInMeters, 1.09361f, IMPERIALS_YARD_DISTANCE_UNIT, roundSmallUnits);
                break;
            }
            case 3: {
                string2 = this.getDistanceInMilesWithUnits(distanceInMeters, 3.28084f, IMPERIALS_FEET_DISTANCE_UNIT, roundSmallUnits);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    public static /* synthetic */ String getFormattedDistance$default(Distance distance, DistanceUnit distanceUnit, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return distance.getFormattedDistance(distanceUnit, n, bl);
    }

    private final String getDistanceInMilesWithUnits(int meters, float smallUnitConversionRatio, String smallUnitText, boolean roundSmallUnits) {
        String string2;
        float miles = (float)meters * 6.2E-4f;
        int smallUnitsValue = MathKt.roundToInt((float)((float)meters * smallUnitConversionRatio));
        if (miles >= (float)10) {
            string2 = MathKt.roundToInt((float)miles) + " mi";
        } else if (smallUnitsValue >= 1000) {
            int roundedMiles = (int)miles;
            float rest = FloatExtensionsKt.getDecimal(miles);
            string2 = rest < 0.3f ? (roundedMiles == 0 ? "\u00bc mi" : roundedMiles + " mi") : (rest < 0.6f ? (roundedMiles == 0 ? "\u00bd mi" : roundedMiles + " \u00bd mi") : roundedMiles + 1 + " mi");
        } else {
            string2 = "" + (roundSmallUnits ? this.roundDistance(smallUnitsValue) : smallUnitsValue) + ' ' + smallUnitText;
        }
        return string2;
    }

    private final int roundDistance(int distance) {
        int n;
        if (distance < 5) {
            n = 0;
        } else if (distance < 30) {
            int n2 = distance + 2;
            boolean bl = false;
            boolean bl2 = false;
            int it = n2;
            boolean bl3 = false;
            n = it - it % 5;
        } else if (distance < 250) {
            int n3 = distance + 5;
            boolean bl = false;
            boolean bl4 = false;
            int it = n3;
            boolean bl5 = false;
            n = it - it % 10;
        } else if (distance < 800) {
            int n4 = distance + 25;
            boolean bl = false;
            boolean bl6 = false;
            int it = n4;
            boolean bl7 = false;
            n = it - it % 50;
        } else if (distance < 10000) {
            int n5 = distance + 50;
            boolean bl = false;
            boolean bl8 = false;
            int it = n5;
            boolean bl9 = false;
            n = it - it % 100;
        } else {
            int n6 = distance + 500;
            boolean bl = false;
            boolean bl10 = false;
            int it = n6;
            boolean bl11 = false;
            n = it - it % 1000;
        }
        return n;
    }

    private Distance() {
    }

    static {
        Distance distance;
        INSTANCE = distance = new Distance();
        DECIMAL_FORMAT = new DecimalFormat("#.#", new DecimalFormatSymbols());
    }
}

