/*
 * Decompiled with CFR 0.152.
 */
package com.sygic.maps.uikit.views.common.extensions;

import android.content.ActivityNotFoundException;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.location.LocationManager;
import android.net.Uri;
import android.text.TextUtils;
import android.util.TypedValue;
import android.widget.Toast;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.appcompat.app.AppCompatActivity;
import com.sygic.maps.uikit.views.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u001e\u0010\t\u001a\u00020\n*\u00020\u00022\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u00020\n*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011\u001a*\u0010\u0012\u001a\u00020\f*\u00020\u00022\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u000eH\u0007\u001a(\u0010\u0016\u001a\u00020\u0011*\u00020\u00022\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u000e\u001a\n\u0010\u0017\u001a\u00020\u000e*\u00020\u0002\u001a\u0014\u0010\u0018\u001a\u00020\n*\u00020\u00022\b\b\u0001\u0010\u0010\u001a\u00020\f\u001a\u001a\u0010\u0019\u001a\u00020\n*\u00020\u00022\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b\u001a\u0012\u0010\u001d\u001a\u00020\n*\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0011\u001a\u0012\u0010\u001f\u001a\u00020\n*\u00020\u00022\u0006\u0010 \u001a\u00020\u0011\u001a\u0012\u0010!\u001a\u00020\n*\u00020\u00022\u0006\u0010\"\u001a\u00020\u0011\u001a\u0014\u0010#\u001a\u00020\n*\u00020\u00022\b\b\u0001\u0010\u0010\u001a\u00020\f\"\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006$"}, d2={"clipboardManager", "Landroid/content/ClipboardManager;", "Landroid/content/Context;", "getClipboardManager", "(Landroid/content/Context;)Landroid/content/ClipboardManager;", "locationManager", "Landroid/location/LocationManager;", "getLocationManager", "(Landroid/content/Context;)Landroid/location/LocationManager;", "applyStyle", "", "resId", "", "force", "", "copyToClipboard", "text", "", "getColorFromAttr", "typedValue", "Landroid/util/TypedValue;", "resolveRefs", "getStringFromAttr", "isRtl", "longToast", "openActivity", "targetClass", "Ljava/lang/Class;", "Landroidx/appcompat/app/AppCompatActivity;", "openEmail", "mailto", "openPhone", "phoneNumber", "openUrl", "url", "shortToast", "uikit-views-1.0.0_release"})
public final class ContextExtensionsKt {
    public static final void applyStyle(@NotNull Context $receiver, @StyleRes int resId, boolean force) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        $receiver.getTheme().applyStyle(resId, force);
    }

    public static /* synthetic */ void applyStyle$default(Context context, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        ContextExtensionsKt.applyStyle(context, n, bl);
    }

    @ColorInt
    public static final int getColorFromAttr(@NotNull Context $receiver, @AttrRes int resId, @NotNull TypedValue typedValue, boolean resolveRefs) {
        TypedValue typedValue2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)typedValue, (String)"typedValue");
        TypedValue it = typedValue2 = typedValue;
        boolean bl = false;
        $receiver.getTheme().resolveAttribute(resId, it, resolveRefs);
        return it.data;
    }

    @ColorInt
    public static /* synthetic */ int getColorFromAttr$default(Context context, int n, TypedValue typedValue, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            typedValue = new TypedValue();
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return ContextExtensionsKt.getColorFromAttr(context, n, typedValue, bl);
    }

    @NotNull
    public static final String getStringFromAttr(@NotNull Context $receiver, @AttrRes int resId, @NotNull TypedValue typedValue, boolean resolveRefs) {
        TypedValue typedValue2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)typedValue, (String)"typedValue");
        TypedValue it = typedValue2 = typedValue;
        boolean bl = false;
        $receiver.getTheme().resolveAttribute(resId, it, resolveRefs);
        if (it.type == 3 && it.string != null) {
            return ((Object)it.string).toString();
        }
        return "";
    }

    @NotNull
    public static /* synthetic */ String getStringFromAttr$default(Context context, int n, TypedValue typedValue, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            typedValue = new TypedValue();
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return ContextExtensionsKt.getStringFromAttr(context, n, typedValue, bl);
    }

    public static final void openActivity(@NotNull Context $receiver, @NotNull Class<? extends AppCompatActivity> targetClass) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(targetClass, (String)"targetClass");
        $receiver.startActivity(new Intent($receiver, targetClass));
    }

    public static final boolean isRtl(@NotNull Context $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Resources resources = $receiver.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"this.resources");
        Configuration configuration = resources.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"this.resources.configuration");
        return configuration.getLayoutDirection() == 1;
    }

    public static final void openUrl(@NotNull Context $receiver, @NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (!TextUtils.isEmpty((CharSequence)url)) {
            String parsedUrl = url;
            if (!StringsKt.startsWith$default((String)url, (String)"http://", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)url, (String)"https://", (boolean)false, (int)2, null)) {
                parsedUrl = "http://" + url;
            }
            try {
                $receiver.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)parsedUrl)));
            }
            catch (ActivityNotFoundException e) {
                ContextExtensionsKt.longToast($receiver, R.string.no_browser_client);
            }
        }
    }

    public static final void openEmail(@NotNull Context $receiver, @NotNull String mailto) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)mailto, (String)"mailto");
        if (!TextUtils.isEmpty((CharSequence)mailto)) {
            Intent emailIntent = new Intent("android.intent.action.SENDTO");
            emailIntent.setData(Uri.parse((String)("mailto:" + mailto)));
            emailIntent.putExtra("android.intent.extra.EMAIL", new String[]{mailto});
            emailIntent.addFlags(0x10000000);
            try {
                $receiver.startActivity(Intent.createChooser((Intent)emailIntent, (CharSequence)$receiver.getString(R.string.send_email)));
            }
            catch (ActivityNotFoundException e) {
                ContextExtensionsKt.longToast($receiver, R.string.no_email_client);
            }
        }
    }

    public static final void openPhone(@NotNull Context $receiver, @NotNull String phoneNumber) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)phoneNumber, (String)"phoneNumber");
        if (!TextUtils.isEmpty((CharSequence)phoneNumber)) {
            Intent phoneIntent = new Intent("android.intent.action.DIAL");
            phoneIntent.setData(Uri.parse((String)("tel:" + phoneNumber)));
            try {
                $receiver.startActivity(Intent.createChooser((Intent)phoneIntent, null));
            }
            catch (ActivityNotFoundException e) {
                ContextExtensionsKt.longToast($receiver, R.string.no_phone_client);
            }
        }
    }

    public static final void copyToClipboard(@NotNull Context $receiver, @NotNull String text) {
        block1: {
            ClipboardManager clipboardManager;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Context $receiver$iv = $receiver;
            boolean $i$f$getClipboardManager = false;
            Object object = $receiver$iv.getSystemService("clipboard");
            if (!(object instanceof ClipboardManager)) {
                object = null;
            }
            ClipboardManager clipboardManager2 = (ClipboardManager)object;
            if (clipboardManager2 == null) break block1;
            ClipboardManager it = clipboardManager = clipboardManager2;
            boolean bl = false;
            it.setPrimaryClip(ClipData.newPlainText((CharSequence)text, (CharSequence)text));
            ContextExtensionsKt.longToast($receiver, R.string.copied_to_clipboard);
        }
    }

    public static final void shortToast(@NotNull Context $receiver, @StringRes int text) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Toast.makeText((Context)$receiver, (int)text, (int)0).show();
    }

    public static final void longToast(@NotNull Context $receiver, @StringRes int text) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Toast.makeText((Context)$receiver, (int)text, (int)1).show();
    }

    @Nullable
    public static final LocationManager getLocationManager(@NotNull Context $receiver) {
        int $i$f$getLocationManager = 0;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Object object = $receiver.getSystemService("location");
        if (!(object instanceof LocationManager)) {
            object = null;
        }
        return (LocationManager)object;
    }

    @Nullable
    public static final ClipboardManager getClipboardManager(@NotNull Context $receiver) {
        int $i$f$getClipboardManager = 0;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Object object = $receiver.getSystemService("clipboard");
        if (!(object instanceof ClipboardManager)) {
            object = null;
        }
        return (ClipboardManager)object;
    }
}

