/*
 * Decompiled with CFR 0.152.
 */
package com.sygic.maps.module.navigation.viewmodel;

import android.app.Application;
import android.os.Bundle;
import androidx.annotation.LayoutRes;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import com.sygic.maps.module.common.theme.ThemeManager;
import com.sygic.maps.module.common.viewmodel.ThemeSupportedViewModel;
import com.sygic.maps.module.navigation.R;
import com.sygic.maps.module.navigation.actionmenu.SoundsOffActionMenuItem;
import com.sygic.maps.module.navigation.actionmenu.SoundsOnActionMenuItem;
import com.sygic.maps.module.navigation.component.NavigationFragmentInitConstantsKt;
import com.sygic.maps.module.navigation.infobar.InternalLeftInfobarClickListener;
import com.sygic.maps.module.navigation.infobar.NavigationDefaultLeftInfobarButton;
import com.sygic.maps.module.navigation.infobar.NavigationDefaultRightInfobarButton;
import com.sygic.maps.module.navigation.infobar.NavigationDefaultUnlockedLeftInfobarButton;
import com.sygic.maps.module.navigation.listener.EventListener;
import com.sygic.maps.module.navigation.listener.EventListenerWrapper;
import com.sygic.maps.module.navigation.types.SignpostType;
import com.sygic.maps.module.navigation.viewmodel.NavigationFragmentViewModel;
import com.sygic.maps.module.navigation.viewmodel.NavigationFragmentViewModel$WhenMappings;
import com.sygic.maps.module.navigation.viewmodel.NavigationFragmentViewModelKt;
import com.sygic.maps.module.navigation.viewmodel.NavigationFragmentViewModelKt$sam$androidx_lifecycle_Observer$0;
import com.sygic.maps.uikit.viewmodels.common.extensions.SdkExtensionsKt;
import com.sygic.maps.uikit.viewmodels.common.location.LocationManager;
import com.sygic.maps.uikit.viewmodels.common.navigation.preview.RouteDemonstrationManager;
import com.sygic.maps.uikit.viewmodels.common.navigation.preview.state.DemonstrationState;
import com.sygic.maps.uikit.viewmodels.common.permission.PermissionsManager;
import com.sygic.maps.uikit.viewmodels.common.regional.RegionalManager;
import com.sygic.maps.uikit.viewmodels.common.sdk.model.ExtendedCameraModel;
import com.sygic.maps.uikit.viewmodels.common.sdk.model.ExtendedMapDataModel;
import com.sygic.maps.uikit.viewmodels.common.utils.LocationUtilsKt;
import com.sygic.maps.uikit.viewmodels.navigation.infobar.button.InfobarButtonType;
import com.sygic.maps.uikit.viewmodels.navigation.infobar.button.OnInfobarButtonClickListener;
import com.sygic.maps.uikit.viewmodels.navigation.infobar.button.OnInfobarButtonClickListenerWrapper;
import com.sygic.maps.uikit.views.common.extensions.AndroidViewModelExtensionsKt;
import com.sygic.maps.uikit.views.common.extensions.BundleExtensionsKt;
import com.sygic.maps.uikit.views.common.extensions.LiveDataExtensionsKt;
import com.sygic.maps.uikit.views.common.livedata.SingleLiveEvent;
import com.sygic.maps.uikit.views.common.toast.InfoToastComponent;
import com.sygic.maps.uikit.views.common.units.DistanceUnit;
import com.sygic.maps.uikit.views.common.utils.TextHolder;
import com.sygic.maps.uikit.views.common.utils.UniqueMutableLiveData;
import com.sygic.maps.uikit.views.navigation.actionmenu.data.ActionMenuData;
import com.sygic.maps.uikit.views.navigation.actionmenu.data.ActionMenuItem;
import com.sygic.maps.uikit.views.navigation.actionmenu.listener.ActionMenuItemClickListener;
import com.sygic.maps.uikit.views.navigation.actionmenu.listener.ActionMenuItemsProviderWrapper;
import com.sygic.maps.uikit.views.navigation.infobar.buttons.InfobarButton;
import com.sygic.sdk.map.Camera;
import com.sygic.sdk.map.MapView;
import com.sygic.sdk.map.object.MapRoute;
import com.sygic.sdk.map.object.ViewObject;
import com.sygic.sdk.navigation.NavigationManager;
import com.sygic.sdk.navigation.listeners.NoAudioInstructionListener;
import com.sygic.sdk.navigation.listeners.NoAudioWarningListener;
import com.sygic.sdk.route.RouteInfo;
import com.sygic.sdk.route.Waypoint;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ed\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0003LOR\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005BY\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\b\u0010i\u001a\u00020jH\u0014J\u0010\u0010k\u001a\u00020j2\u0006\u0010l\u001a\u00020mH\u0016J\u0010\u0010n\u001a\u00020j2\u0006\u0010l\u001a\u00020mH\u0016J\b\u0010o\u001a\u00020jH\u0016J\r\u0010p\u001a\u0004\u0018\u00010j\u00a2\u0006\u0002\u0010qJ\u0012\u0010r\u001a\u00020j2\b\b\u0001\u0010s\u001a\u00020`H\u0016J\u0010\u0010t\u001a\u00020j2\u0006\u0010l\u001a\u00020mH\u0016J\r\u0010u\u001a\u0004\u0018\u00010j\u00a2\u0006\u0002\u0010qJ\u0012\u0010v\u001a\u00020j2\b\b\u0001\u0010s\u001a\u00020`H\u0016J\u0012\u0010w\u001a\u00020j2\b\u0010Z\u001a\u0004\u0018\u00010[H\u0016J\u0010\u0010x\u001a\u00020j2\u0006\u0010l\u001a\u00020mH\u0016J\u0010\u0010y\u001a\u00020j2\u0006\u0010l\u001a\u00020mH\u0016J\u0010\u0010z\u001a\u00020j2\u0006\u0010{\u001a\u00020|H\u0016J\u0018\u0010}\u001a\u00020j2\u0006\u0010~\u001a\u00020/2\u0006\u0010Z\u001a\u00020[H\u0002J\u0010\u0010\u007f\u001a\u00020j2\u0006\u0010Z\u001a\u00020[H\u0002J\u001d\u0010\u0080\u0001\u001a\u00020j2\u0007\u0010\u0081\u0001\u001a\u00020@2\t\u0010\u0082\u0001\u001a\u0004\u0018\u00010AH\u0002R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001e\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020#@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020#0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010!R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010!R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010!R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R$\u00104\u001a\u0002032\u0006\u00102\u001a\u0002038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010!R\u001c\u0010>\u001a\u0010\u0012\u0004\u0012\u00020@\u0012\u0006\u0012\u0004\u0018\u00010A0?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010B\u001a\b\u0012\u0004\u0012\u00020/0.\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u00101R\u0011\u0010D\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u0017\u0010F\u001a\b\u0012\u0004\u0012\u00020/0.\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u00101R\u0019\u0010H\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010I0.\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u00101R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010K\u001a\u00020LX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010MR\u0010\u0010N\u001a\u00020OX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010PR\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010Q\u001a\u00020RX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010SR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010T\u001a\b\u0012\u0004\u0012\u00020/0.\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u00101R\u0017\u0010V\u001a\b\u0012\u0004\u0012\u00020/0.\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u00101R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010X\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010I0.\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u00101R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010Z\u001a\b\u0012\u0004\u0012\u00020[0.\u00a2\u0006\b\n\u0000\u001a\u0004\b\\\u00101R\u0017\u0010]\u001a\b\u0012\u0004\u0012\u00020/0.\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u00101R\u0016\u0010_\u001a\u00020`8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010bR\u0011\u0010c\u001a\u00020d\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010fR\u0017\u0010g\u001a\b\u0012\u0004\u0012\u00020/0.\u00a2\u0006\b\n\u0000\u001a\u0004\bh\u00101\u00a8\u0006\u0083\u0001"}, d2={"Lcom/sygic/maps/module/navigation/viewmodel/NavigationFragmentViewModel;", "Lcom/sygic/maps/module/common/viewmodel/ThemeSupportedViewModel;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "Lcom/sygic/sdk/navigation/NavigationManager$OnRouteChangedListener;", "Lcom/sygic/sdk/navigation/NavigationManager$OnWaypointPassedListener;", "Lcom/sygic/sdk/map/Camera$ModeChangedListener;", "app", "Landroid/app/Application;", "arguments", "Landroid/os/Bundle;", "themeManager", "Lcom/sygic/maps/module/common/theme/ThemeManager;", "cameraModel", "Lcom/sygic/maps/uikit/viewmodels/common/sdk/model/ExtendedCameraModel;", "mapDataModel", "Lcom/sygic/maps/uikit/viewmodels/common/sdk/model/ExtendedMapDataModel;", "regionalManager", "Lcom/sygic/maps/uikit/viewmodels/common/regional/RegionalManager;", "locationManager", "Lcom/sygic/maps/uikit/viewmodels/common/location/LocationManager;", "permissionsManager", "Lcom/sygic/maps/uikit/viewmodels/common/permission/PermissionsManager;", "navigationManager", "Lcom/sygic/sdk/navigation/NavigationManager;", "routeDemonstrationManager", "Lcom/sygic/maps/uikit/viewmodels/common/navigation/preview/RouteDemonstrationManager;", "(Landroid/app/Application;Landroid/os/Bundle;Lcom/sygic/maps/module/common/theme/ThemeManager;Lcom/sygic/maps/uikit/viewmodels/common/sdk/model/ExtendedCameraModel;Lcom/sygic/maps/uikit/viewmodels/common/sdk/model/ExtendedMapDataModel;Lcom/sygic/maps/uikit/viewmodels/common/regional/RegionalManager;Lcom/sygic/maps/uikit/viewmodels/common/location/LocationManager;Lcom/sygic/maps/uikit/viewmodels/common/permission/PermissionsManager;Lcom/sygic/sdk/navigation/NavigationManager;Lcom/sygic/maps/uikit/viewmodels/common/navigation/preview/RouteDemonstrationManager;)V", "actionMenuData", "Lcom/sygic/maps/uikit/views/navigation/actionmenu/data/ActionMenuData;", "actionMenuHideObservable", "Landroidx/lifecycle/LiveData;", "", "getActionMenuHideObservable", "()Landroidx/lifecycle/LiveData;", "<set-?>", "Lcom/sygic/maps/uikit/views/navigation/actionmenu/listener/ActionMenuItemClickListener;", "actionMenuItemClickListener", "getActionMenuItemClickListener", "()Lcom/sygic/maps/uikit/views/navigation/actionmenu/listener/ActionMenuItemClickListener;", "actionMenuItemClickListenerObservable", "getActionMenuItemClickListenerObservable", "actionMenuShowObservable", "getActionMenuShowObservable", "activityFinishObservable", "getActivityFinishObservable", "currentSpeedEnabled", "Landroidx/lifecycle/MutableLiveData;", "", "getCurrentSpeedEnabled", "()Landroidx/lifecycle/MutableLiveData;", "value", "Lcom/sygic/maps/uikit/views/common/units/DistanceUnit;", "distanceUnit", "getDistanceUnit", "()Lcom/sygic/maps/uikit/views/common/units/DistanceUnit;", "setDistanceUnit", "(Lcom/sygic/maps/uikit/views/common/units/DistanceUnit;)V", "eventListener", "Lcom/sygic/maps/module/navigation/listener/EventListener;", "infoToastObservable", "Lcom/sygic/maps/uikit/views/common/toast/InfoToastComponent;", "getInfoToastObservable", "infobarButtonListenersMap", "", "Lcom/sygic/maps/uikit/viewmodels/navigation/infobar/button/InfobarButtonType;", "Lcom/sygic/maps/uikit/viewmodels/navigation/infobar/button/OnInfobarButtonClickListener;", "infobarEnabled", "getInfobarEnabled", "isLanesViewEmbedded", "()Z", "lanesViewEnabled", "getLanesViewEnabled", "leftInfobarButton", "Lcom/sygic/maps/uikit/views/navigation/infobar/buttons/InfobarButton;", "getLeftInfobarButton", "navigationDefaultLeftInfobarClickListener", "com/sygic/maps/module/navigation/viewmodel/NavigationFragmentViewModel$navigationDefaultLeftInfobarClickListener$1", "Lcom/sygic/maps/module/navigation/viewmodel/NavigationFragmentViewModel$navigationDefaultLeftInfobarClickListener$1;", "navigationDefaultRightInfobarClickListener", "com/sygic/maps/module/navigation/viewmodel/NavigationFragmentViewModel$navigationDefaultRightInfobarClickListener$1", "Lcom/sygic/maps/module/navigation/viewmodel/NavigationFragmentViewModel$navigationDefaultRightInfobarClickListener$1;", "navigationUnlockedLeftInfobarClickListener", "com/sygic/maps/module/navigation/viewmodel/NavigationFragmentViewModel$navigationUnlockedLeftInfobarClickListener$1", "Lcom/sygic/maps/module/navigation/viewmodel/NavigationFragmentViewModel$navigationUnlockedLeftInfobarClickListener$1;", "previewControlsEnabled", "getPreviewControlsEnabled", "previewMode", "getPreviewMode", "rightInfobarButton", "getRightInfobarButton", "routeInfo", "Lcom/sygic/sdk/route/RouteInfo;", "getRouteInfo", "signpostEnabled", "getSignpostEnabled", "signpostLayout", "", "getSignpostLayout", "()I", "signpostType", "Lcom/sygic/maps/module/navigation/types/SignpostType;", "getSignpostType", "()Lcom/sygic/maps/module/navigation/types/SignpostType;", "speedLimitEnabled", "getSpeedLimitEnabled", "onCleared", "", "onCreate", "owner", "Landroidx/lifecycle/LifecycleOwner;", "onDestroy", "onFinishReached", "onLeftInfobarButtonClick", "()Lkotlin/Unit;", "onMovementModeChanged", "mode", "onResume", "onRightInfobarButtonClick", "onRotationModeChanged", "onRouteChanged", "onStart", "onStop", "onWaypointPassed", "waypoint", "Lcom/sygic/sdk/route/Waypoint;", "processRoutePreview", "previewActive", "setRouteInfo", "updateInfobarListenersMap", "buttonType", "listener", "module-navigation-1.4.1_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class NavigationFragmentViewModel
extends ThemeSupportedViewModel
implements DefaultLifecycleObserver,
NavigationManager.OnRouteChangedListener,
NavigationManager.OnWaypointPassedListener,
Camera.ModeChangedListener {
    @LayoutRes
    private final int signpostLayout;
    @NotNull
    private final SignpostType signpostType;
    @NotNull
    private final MutableLiveData<Boolean> signpostEnabled;
    @NotNull
    private final MutableLiveData<Boolean> infobarEnabled;
    @NotNull
    private final MutableLiveData<Boolean> previewControlsEnabled;
    @NotNull
    private final MutableLiveData<Boolean> currentSpeedEnabled;
    @NotNull
    private final MutableLiveData<Boolean> speedLimitEnabled;
    @NotNull
    private final MutableLiveData<Boolean> lanesViewEnabled;
    @NotNull
    private final MutableLiveData<InfobarButton> leftInfobarButton;
    @NotNull
    private final MutableLiveData<InfobarButton> rightInfobarButton;
    @NotNull
    private final MutableLiveData<Boolean> previewMode;
    @NotNull
    private final MutableLiveData<RouteInfo> routeInfo;
    @NotNull
    private final LiveData<InfoToastComponent> infoToastObservable;
    @NotNull
    private final LiveData<ActionMenuData> actionMenuShowObservable;
    @NotNull
    private final LiveData<Object> actionMenuHideObservable;
    @NotNull
    private final LiveData<ActionMenuItemClickListener> actionMenuItemClickListenerObservable;
    @NotNull
    private final LiveData<Object> activityFinishObservable;
    private final Map<InfobarButtonType, OnInfobarButtonClickListener> infobarButtonListenersMap;
    private final navigationDefaultLeftInfobarClickListener.1 navigationDefaultLeftInfobarClickListener;
    private final navigationUnlockedLeftInfobarClickListener.1 navigationUnlockedLeftInfobarClickListener;
    private final navigationDefaultRightInfobarClickListener.1 navigationDefaultRightInfobarClickListener;
    private ActionMenuData actionMenuData;
    private EventListener eventListener;
    @NotNull
    private ActionMenuItemClickListener actionMenuItemClickListener;
    private final ExtendedCameraModel cameraModel;
    private final ExtendedMapDataModel mapDataModel;
    private final RegionalManager regionalManager;
    private final LocationManager locationManager;
    private final PermissionsManager permissionsManager;
    private final NavigationManager navigationManager;
    private final RouteDemonstrationManager routeDemonstrationManager;

    public final int getSignpostLayout() {
        return this.signpostLayout;
    }

    @NotNull
    public final SignpostType getSignpostType() {
        return this.signpostType;
    }

    @NotNull
    public final MutableLiveData<Boolean> getSignpostEnabled() {
        return this.signpostEnabled;
    }

    @NotNull
    public final MutableLiveData<Boolean> getInfobarEnabled() {
        return this.infobarEnabled;
    }

    @NotNull
    public final MutableLiveData<Boolean> getPreviewControlsEnabled() {
        return this.previewControlsEnabled;
    }

    @NotNull
    public final MutableLiveData<Boolean> getCurrentSpeedEnabled() {
        return this.currentSpeedEnabled;
    }

    @NotNull
    public final MutableLiveData<Boolean> getSpeedLimitEnabled() {
        return this.speedLimitEnabled;
    }

    @NotNull
    public final MutableLiveData<Boolean> getLanesViewEnabled() {
        return this.lanesViewEnabled;
    }

    @NotNull
    public final MutableLiveData<InfobarButton> getLeftInfobarButton() {
        return this.leftInfobarButton;
    }

    @NotNull
    public final MutableLiveData<InfobarButton> getRightInfobarButton() {
        return this.rightInfobarButton;
    }

    @NotNull
    public final MutableLiveData<Boolean> getPreviewMode() {
        return this.previewMode;
    }

    @NotNull
    public final MutableLiveData<RouteInfo> getRouteInfo() {
        return this.routeInfo;
    }

    @NotNull
    public final LiveData<InfoToastComponent> getInfoToastObservable() {
        return this.infoToastObservable;
    }

    @NotNull
    public final LiveData<ActionMenuData> getActionMenuShowObservable() {
        return this.actionMenuShowObservable;
    }

    @NotNull
    public final LiveData<Object> getActionMenuHideObservable() {
        return this.actionMenuHideObservable;
    }

    @NotNull
    public final LiveData<ActionMenuItemClickListener> getActionMenuItemClickListenerObservable() {
        return this.actionMenuItemClickListenerObservable;
    }

    @NotNull
    public final LiveData<Object> getActivityFinishObservable() {
        return this.activityFinishObservable;
    }

    public final boolean isLanesViewEmbedded() {
        Object object = this.signpostEnabled.getValue();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)object != false && this.signpostType == SignpostType.FULL;
    }

    @NotNull
    public final ActionMenuItemClickListener getActionMenuItemClickListener() {
        return this.actionMenuItemClickListener;
    }

    @NotNull
    public final DistanceUnit getDistanceUnit() {
        Object object = this.regionalManager.getDistanceUnit().getValue();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (DistanceUnit)object;
    }

    public final void setDistanceUnit(@NotNull DistanceUnit value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.regionalManager.getDistanceUnit().setValue((Object)value);
    }

    public void onCreate(@NotNull LifecycleOwner owner) {
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            if (owner instanceof EventListenerWrapper) {
                ((EventListenerWrapper)owner).getEventListenerProvider().observe(owner, (Observer)new Observer<EventListener>(this){
                    final /* synthetic */ NavigationFragmentViewModel this$0;

                    public final void onChanged(EventListener it) {
                        NavigationFragmentViewModel.access$setEventListener$p(this.this$0, it);
                    }
                    {
                        this.this$0 = navigationFragmentViewModel;
                    }
                });
            }
            if (owner instanceof OnInfobarButtonClickListenerWrapper) {
                ((OnInfobarButtonClickListenerWrapper)owner).getInfobarButtonClickListenerProvidersMap().observe(owner, (Observer)new Observer<Map<InfobarButtonType, ? extends OnInfobarButtonClickListener>>(this){
                    final /* synthetic */ NavigationFragmentViewModel this$0;

                    public final void onChanged(Map<InfobarButtonType, ? extends OnInfobarButtonClickListener> map) {
                        Map<InfobarButtonType, ? extends OnInfobarButtonClickListener> map2 = map;
                        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"map");
                        Map<InfobarButtonType, ? extends OnInfobarButtonClickListener> $this$forEach$iv = map2;
                        boolean $i$f$forEach = false;
                        Map<InfobarButtonType, ? extends OnInfobarButtonClickListener> map3 = $this$forEach$iv;
                        boolean bl = false;
                        Iterator<Map.Entry<InfobarButtonType, ? extends OnInfobarButtonClickListener>> iterator = map3.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<InfobarButtonType, ? extends OnInfobarButtonClickListener> element$iv;
                            Map.Entry<InfobarButtonType, ? extends OnInfobarButtonClickListener> it = element$iv = iterator.next();
                            boolean bl2 = false;
                            NavigationFragmentViewModel.access$updateInfobarListenersMap(this.this$0, it.getKey(), it.getValue());
                        }
                    }
                    {
                        this.this$0 = navigationFragmentViewModel;
                    }
                });
            }
            if (owner instanceof ActionMenuItemsProviderWrapper) {
                ((ActionMenuItemsProviderWrapper)owner).getActionMenuItemsProvider().observe(owner, (Observer)new Observer<ActionMenuItemsProviderWrapper.ProviderComponent>(this){
                    final /* synthetic */ NavigationFragmentViewModel this$0;

                    public final void onChanged(ActionMenuItemsProviderWrapper.ProviderComponent it) {
                        NavigationFragmentViewModel.access$setActionMenuData$p(this.this$0, it.getActionMenuData());
                        NavigationFragmentViewModel.access$setActionMenuItemClickListener$p(this.this$0, it.getActionMenuItemClickListener());
                    }
                    {
                        this.this$0 = navigationFragmentViewModel;
                    }
                });
            }
            this.routeDemonstrationManager.getDemonstrationState().observe(owner, (Observer)new Observer<DemonstrationState>(this){
                final /* synthetic */ NavigationFragmentViewModel this$0;

                public final void onChanged(DemonstrationState it) {
                    if (this.this$0.getRouteInfo().getValue() != null) {
                        DemonstrationState demonstrationState = it;
                        if (demonstrationState != null) {
                            switch (NavigationFragmentViewModel$WhenMappings.$EnumSwitchMapping$1[demonstrationState.ordinal()]) {
                                case 1: {
                                    EventListener eventListener = NavigationFragmentViewModel.access$getEventListener$p(this.this$0);
                                    if (eventListener != null) {
                                        eventListener.onNavigationStarted((RouteInfo)this.this$0.getRouteInfo().getValue());
                                    }
                                    break;
                                }
                                case 2: {
                                    EventListener eventListener = NavigationFragmentViewModel.access$getEventListener$p(this.this$0);
                                    if (eventListener == null) break;
                                    eventListener.onNavigationFinished();
                                    break;
                                }
                            }
                        }
                    }
                }
                {
                    this.this$0 = navigationFragmentViewModel;
                }
            });
            EventListener eventListener = this.eventListener;
            if (eventListener == null) break block3;
            eventListener.onNavigationCreated();
        }
    }

    public void onStart(@NotNull LifecycleOwner owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Object object = this.previewMode.getValue();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        this.locationManager.setPositionOnMapEnabled((Boolean)object == false || (DemonstrationState)this.routeDemonstrationManager.getDemonstrationState().getValue() == DemonstrationState.ACTIVE);
        this.cameraModel.addModeChangedListener((Camera.ModeChangedListener)this);
        this.navigationManager.addOnRouteChangedListener((NavigationManager.OnRouteChangedListener)this);
        this.navigationManager.addOnWaypointPassedListener((NavigationManager.OnWaypointPassedListener)this);
        LiveDataExtensionsKt.asSingleEvent(this.actionMenuItemClickListenerObservable).setValue((Object)this.actionMenuItemClickListener);
    }

    public void onResume(@NotNull LifecycleOwner owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        this.cameraModel.setMapCenterSettings(AndroidViewModelExtensionsKt.isLandscape((AndroidViewModel)this) ? NavigationFragmentViewModelKt.access$getLANDSCAPE_MAP_CENTER_SETTING$p() : NavigationFragmentViewModelKt.access$getPORTRAIT_MAP_CENTER_SETTING$p());
    }

    public void onRouteChanged(@Nullable RouteInfo routeInfo2) {
        block1: {
            EventListener eventListener = this.eventListener;
            if (eventListener != null) {
                eventListener.onRouteChanged(routeInfo2);
            }
            SdkExtensionsKt.removeAllMapRoutes((MapView.MapDataModel)((MapView.MapDataModel)this.mapDataModel));
            RouteInfo routeInfo3 = routeInfo2;
            if (routeInfo3 == null) break block1;
            RouteInfo routeInfo4 = routeInfo3;
            boolean bl = false;
            boolean bl2 = false;
            RouteInfo it = routeInfo4;
            boolean bl3 = false;
            this.routeInfo.setValue((Object)it);
            MapView.MapDataModel mapDataModel = (MapView.MapDataModel)this.mapDataModel;
            ViewObject viewObject = MapRoute.from((RouteInfo)it).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)viewObject, (String)"MapRoute.from(it).build()");
            SdkExtensionsKt.addMapRoute((MapView.MapDataModel)mapDataModel, (MapRoute)((MapRoute)viewObject));
        }
    }

    public void onFinishReached() {
        block1: {
            SdkExtensionsKt.removeAllMapRoutes((MapView.MapDataModel)((MapView.MapDataModel)this.mapDataModel));
            this.navigationManager.stopNavigation();
            EventListener eventListener = this.eventListener;
            if (eventListener != null) {
                eventListener.onRouteFinishReached();
            }
            EventListener eventListener2 = this.eventListener;
            if (eventListener2 == null) break block1;
            eventListener2.onNavigationFinished();
        }
    }

    public void onMovementModeChanged(@Camera.MovementMode int mode) {
        if (this.infobarButtonListenersMap.get(InfobarButtonType.LEFT) instanceof InternalLeftInfobarClickListener) {
            switch (mode) {
                case 0: {
                    this.updateInfobarListenersMap(InfobarButtonType.LEFT, this.navigationUnlockedLeftInfobarClickListener);
                    break;
                }
                case 1: 
                case 2: {
                    this.updateInfobarListenersMap(InfobarButtonType.LEFT, this.navigationDefaultLeftInfobarClickListener);
                }
            }
        }
    }

    public void onWaypointPassed(@NotNull Waypoint waypoint) {
        Intrinsics.checkParameterIsNotNull((Object)waypoint, (String)"waypoint");
    }

    public void onRotationModeChanged(@Camera.RotationMode int mode) {
    }

    private final void setRouteInfo(RouteInfo routeInfo2) {
        block0: {
            ExtendedCameraModel extendedCameraModel = this.cameraModel;
            boolean bl = false;
            boolean bl2 = false;
            ExtendedCameraModel $this$apply = extendedCameraModel;
            boolean bl3 = false;
            $this$apply.setTilt(60.0f);
            $this$apply.setMovementMode(2);
            $this$apply.setRotationMode(3);
            this.navigationManager.setRouteForNavigation(routeInfo2);
            EventListener eventListener = this.eventListener;
            if (eventListener == null) break block0;
            eventListener.onNavigationStarted(routeInfo2);
        }
    }

    private final void processRoutePreview(boolean previewActive, RouteInfo routeInfo2) {
        if (previewActive) {
            this.locationManager.setPositionOnMapEnabled(false);
            this.routeDemonstrationManager.start(routeInfo2);
        } else {
            this.routeDemonstrationManager.stop();
            LocationUtilsKt.requestLocationAccess((PermissionsManager)this.permissionsManager, (LocationManager)this.locationManager, (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ NavigationFragmentViewModel this$0;

                public final void invoke() {
                    NavigationFragmentViewModel.access$getLocationManager$p(this.this$0).setPositionOnMapEnabled(true);
                }
                {
                    this.this$0 = navigationFragmentViewModel;
                    super(0);
                }
            }));
        }
    }

    private final void updateInfobarListenersMap(InfobarButtonType buttonType, OnInfobarButtonClickListener listener) {
        Map<InfobarButtonType, OnInfobarButtonClickListener> map = this.infobarButtonListenersMap;
        if (map == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<com.sygic.maps.uikit.viewmodels.navigation.infobar.button.InfobarButtonType, com.sygic.maps.uikit.viewmodels.navigation.infobar.button.OnInfobarButtonClickListener?>");
        }
        TypeIntrinsics.asMutableMap(map).put(buttonType, listener);
        switch (NavigationFragmentViewModel$WhenMappings.$EnumSwitchMapping$2[buttonType.ordinal()]) {
            case 1: {
                OnInfobarButtonClickListener onInfobarButtonClickListener = listener;
                this.leftInfobarButton.setValue(onInfobarButtonClickListener != null ? onInfobarButtonClickListener.getButton() : null);
                break;
            }
            case 2: {
                OnInfobarButtonClickListener onInfobarButtonClickListener = listener;
                this.rightInfobarButton.setValue(onInfobarButtonClickListener != null ? onInfobarButtonClickListener.getButton() : null);
            }
        }
    }

    @Nullable
    public final Unit onLeftInfobarButtonClick() {
        Unit unit;
        OnInfobarButtonClickListener onInfobarButtonClickListener = this.infobarButtonListenersMap.get(InfobarButtonType.LEFT);
        if (onInfobarButtonClickListener != null) {
            onInfobarButtonClickListener.onButtonClick();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @Nullable
    public final Unit onRightInfobarButtonClick() {
        Unit unit;
        OnInfobarButtonClickListener onInfobarButtonClickListener = this.infobarButtonListenersMap.get(InfobarButtonType.RIGHT);
        if (onInfobarButtonClickListener != null) {
            onInfobarButtonClickListener.onButtonClick();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public void onStop(@NotNull LifecycleOwner owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        this.locationManager.setPositionOnMapEnabled(false);
        this.cameraModel.removeModeChangedListener((Camera.ModeChangedListener)this);
        this.navigationManager.removeOnRouteChangedListener((NavigationManager.OnRouteChangedListener)this);
        this.navigationManager.removeOnWaypointPassedListener((NavigationManager.OnWaypointPassedListener)this);
    }

    public void onDestroy(@NotNull LifecycleOwner owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        EventListener eventListener = this.eventListener;
        if (eventListener != null) {
            eventListener.onNavigationDestroyed();
        }
        this.eventListener = null;
    }

    protected void onCleared() {
        super.onCleared();
        SdkExtensionsKt.removeAllMapRoutes((MapView.MapDataModel)((MapView.MapDataModel)this.mapDataModel));
        this.routeDemonstrationManager.destroy();
        this.navigationManager.stopNavigation();
    }

    public NavigationFragmentViewModel(@NotNull Application app, @Nullable Bundle arguments, @NotNull ThemeManager themeManager, @NotNull ExtendedCameraModel cameraModel, @NotNull ExtendedMapDataModel mapDataModel, @NotNull RegionalManager regionalManager, @NotNull LocationManager locationManager, @NotNull PermissionsManager permissionsManager, @NotNull NavigationManager navigationManager, @NotNull RouteDemonstrationManager routeDemonstrationManager) {
        int n;
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)app, (String)"app");
        Intrinsics.checkParameterIsNotNull((Object)themeManager, (String)"themeManager");
        Intrinsics.checkParameterIsNotNull((Object)cameraModel, (String)"cameraModel");
        Intrinsics.checkParameterIsNotNull((Object)mapDataModel, (String)"mapDataModel");
        Intrinsics.checkParameterIsNotNull((Object)regionalManager, (String)"regionalManager");
        Intrinsics.checkParameterIsNotNull((Object)locationManager, (String)"locationManager");
        Intrinsics.checkParameterIsNotNull((Object)permissionsManager, (String)"permissionsManager");
        Intrinsics.checkParameterIsNotNull((Object)navigationManager, (String)"navigationManager");
        Intrinsics.checkParameterIsNotNull((Object)routeDemonstrationManager, (String)"routeDemonstrationManager");
        super(app, arguments, themeManager);
        this.cameraModel = cameraModel;
        this.mapDataModel = mapDataModel;
        this.regionalManager = regionalManager;
        this.locationManager = locationManager;
        this.permissionsManager = permissionsManager;
        this.navigationManager = navigationManager;
        this.routeDemonstrationManager = routeDemonstrationManager;
        this.signpostEnabled = new MutableLiveData((Object)true);
        this.infobarEnabled = new MutableLiveData((Object)true);
        this.previewControlsEnabled = new MutableLiveData((Object)true);
        this.currentSpeedEnabled = new MutableLiveData((Object)true);
        this.speedLimitEnabled = new MutableLiveData((Object)true);
        this.lanesViewEnabled = new MutableLiveData((Object)true);
        this.leftInfobarButton = new MutableLiveData();
        this.rightInfobarButton = new MutableLiveData();
        this.previewMode = new MutableLiveData((Object)false);
        this.routeInfo = (MutableLiveData)new UniqueMutableLiveData();
        this.infoToastObservable = (LiveData)new SingleLiveEvent();
        this.actionMenuShowObservable = (LiveData)new SingleLiveEvent();
        this.actionMenuHideObservable = (LiveData)new SingleLiveEvent();
        this.actionMenuItemClickListenerObservable = (LiveData)new SingleLiveEvent();
        this.activityFinishObservable = (LiveData)new SingleLiveEvent();
        NavigationFragmentViewModel navigationFragmentViewModel = this;
        boolean bl = false;
        navigationFragmentViewModel.infobarButtonListenersMap = map = (Map)new LinkedHashMap();
        this.navigationDefaultLeftInfobarClickListener = new InternalLeftInfobarClickListener(this){
            @NotNull
            private final NavigationDefaultLeftInfobarButton button;
            final /* synthetic */ NavigationFragmentViewModel this$0;

            @NotNull
            public NavigationDefaultLeftInfobarButton getButton() {
                return this.button;
            }

            public void onButtonClick() {
                LiveDataExtensionsKt.asSingleEvent(this.this$0.getActionMenuShowObservable()).setValue((Object)NavigationFragmentViewModel.access$getActionMenuData$p(this.this$0));
            }
            {
                this.this$0 = $outer;
                this.button = new NavigationDefaultLeftInfobarButton();
            }
        };
        this.navigationUnlockedLeftInfobarClickListener = new InternalLeftInfobarClickListener(this){
            @NotNull
            private final NavigationDefaultUnlockedLeftInfobarButton button;
            final /* synthetic */ NavigationFragmentViewModel this$0;

            @NotNull
            public NavigationDefaultUnlockedLeftInfobarButton getButton() {
                return this.button;
            }

            public void onButtonClick() {
                NavigationFragmentViewModel.access$getCameraModel$p(this.this$0).setRotationMode(3);
                NavigationFragmentViewModel.access$getCameraModel$p(this.this$0).setMovementMode(2);
            }
            {
                this.this$0 = $outer;
                this.button = new NavigationDefaultUnlockedLeftInfobarButton();
            }
        };
        this.navigationDefaultRightInfobarClickListener = new OnInfobarButtonClickListener(this){
            @NotNull
            private final NavigationDefaultRightInfobarButton button;
            final /* synthetic */ NavigationFragmentViewModel this$0;

            @NotNull
            public NavigationDefaultRightInfobarButton getButton() {
                return this.button;
            }

            public void onButtonClick() {
                LiveDataExtensionsKt.asSingleEvent(this.this$0.getActivityFinishObservable()).call();
            }
            {
                this.this$0 = $outer;
                this.button = new NavigationDefaultRightInfobarButton();
            }
        };
        this.actionMenuData = new ActionMenuData(TextHolder.Companion.from(R.string.action_menu), CollectionsKt.listOf((Object[])new ActionMenuItem[]{new SoundsOnActionMenuItem(), new SoundsOffActionMenuItem()}));
        this.actionMenuItemClickListener = new ActionMenuItemClickListener(this){
            final /* synthetic */ NavigationFragmentViewModel this$0;

            public void onActionMenuItemClick(@NotNull ActionMenuItem actionMenuItem) {
                Intrinsics.checkParameterIsNotNull((Object)actionMenuItem, (String)"actionMenuItem");
                ActionMenuItem actionMenuItem2 = actionMenuItem;
                if (actionMenuItem2 instanceof SoundsOnActionMenuItem) {
                    NavigationFragmentViewModel.access$getNavigationManager$p(this.this$0).removeAudioWarningListener();
                    NavigationFragmentViewModel.access$getNavigationManager$p(this.this$0).removeAudioInstructionListener();
                    LiveDataExtensionsKt.asSingleEvent(this.this$0.getInfoToastObservable()).setValue((Object)new InfoToastComponent(R.drawable.ic_sounds_on, R.string.sounds_enabled));
                } else if (actionMenuItem2 instanceof SoundsOffActionMenuItem) {
                    NavigationFragmentViewModel.access$getNavigationManager$p(this.this$0).setAudioWarningListener((NavigationManager.AudioWarningListener)new NoAudioWarningListener());
                    NavigationFragmentViewModel.access$getNavigationManager$p(this.this$0).setAudioInstructionListener((NavigationManager.AudioInstructionListener)new NoAudioInstructionListener());
                    LiveDataExtensionsKt.asSingleEvent(this.this$0.getInfoToastObservable()).setValue((Object)new InfoToastComponent(R.drawable.ic_sounds_off, R.string.sounds_disabled));
                }
                LiveDataExtensionsKt.asSingleEvent(this.this$0.getActionMenuHideObservable()).call();
            }
            {
                this.this$0 = $outer;
            }
        };
        bl = false;
        boolean bl2 = false;
        Bundle $this$with = arguments;
        boolean bl3 = false;
        this.previewMode.setValue((Object)BundleExtensionsKt.getBoolean((Bundle)$this$with, (String)"preview_mode", (boolean)false));
        this.infobarEnabled.setValue((Object)BundleExtensionsKt.getBoolean((Bundle)$this$with, (String)"infobar_enabled", (boolean)true));
        this.previewControlsEnabled.setValue((Object)BundleExtensionsKt.getBoolean((Bundle)$this$with, (String)"preview_controls_enabled", (boolean)true));
        this.currentSpeedEnabled.setValue((Object)BundleExtensionsKt.getBoolean((Bundle)$this$with, (String)"current_speed_enabled", (boolean)true));
        this.speedLimitEnabled.setValue((Object)BundleExtensionsKt.getBoolean((Bundle)$this$with, (String)"speed_limit_enabled", (boolean)true));
        this.signpostEnabled.setValue((Object)BundleExtensionsKt.getBoolean((Bundle)$this$with, (String)"signpost_enabled", (boolean)true));
        this.lanesViewEnabled.setValue((Object)BundleExtensionsKt.getBoolean((Bundle)$this$with, (String)"lanes_view_enabled", (boolean)true));
        SignpostType signpostType = (SignpostType)BundleExtensionsKt.getParcelableValue((Bundle)$this$with, (String)"signpost_type");
        if (signpostType == null) {
            signpostType = NavigationFragmentInitConstantsKt.getSIGNPOST_TYPE_DEFAULT_VALUE();
        }
        this.signpostType = signpostType;
        switch (NavigationFragmentViewModel$WhenMappings.$EnumSwitchMapping$0[this.signpostType.ordinal()]) {
            case 1: {
                n = R.layout.layout_signpost_full_view_stub;
                break;
            }
            case 2: {
                n = R.layout.layout_signpost_simplified_view_stub;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.signpostLayout = n;
        DistanceUnit distanceUnit2 = (DistanceUnit)BundleExtensionsKt.getParcelableValue((Bundle)$this$with, (String)"distance_units");
        if (distanceUnit2 == null) {
            distanceUnit2 = NavigationFragmentInitConstantsKt.getDISTANCE_UNITS_DEFAULT_VALUE();
        }
        this.setDistanceUnit(distanceUnit2);
        RouteInfo routeInfo2 = (RouteInfo)BundleExtensionsKt.getParcelableValue((Bundle)$this$with, (String)"route_info");
        if (routeInfo2 != null) {
            RouteInfo routeInfo3 = routeInfo2;
            boolean bl4 = false;
            boolean bl5 = false;
            RouteInfo it = routeInfo3;
            boolean bl6 = false;
            this.routeInfo.setValue((Object)it);
        }
        Function1 function1 = (Function1)new Function1<RouteInfo, Unit>(this){

            public final void invoke(@NotNull RouteInfo p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                ((NavigationFragmentViewModel)((Object)this.receiver)).setRouteInfo(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(NavigationFragmentViewModel.class);
            }

            public final String getName() {
                return "setRouteInfo";
            }

            public final String getSignature() {
                return "setRouteInfo(Lcom/sygic/sdk/route/RouteInfo;)V";
            }
        };
        this.routeInfo.observeForever((Observer)new NavigationFragmentViewModelKt$sam$androidx_lifecycle_Observer$0(function1));
        LiveDataExtensionsKt.withLatestFrom((LiveData)((LiveData)this.previewMode), (LiveData)((LiveData)this.routeInfo)).observeForever((Observer)new Observer<Pair<? extends Boolean, ? extends RouteInfo>>(){

            public final void onChanged(Pair<Boolean, ? extends RouteInfo> it) {
                Object object = it.getFirst();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.first");
                boolean bl = (Boolean)object;
                Object object2 = it.getSecond();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it.second");
                this.processRoutePreview(bl, (RouteInfo)object2);
            }
        });
        this.updateInfobarListenersMap(InfobarButtonType.LEFT, this.navigationDefaultLeftInfobarClickListener);
        this.updateInfobarListenersMap(InfobarButtonType.RIGHT, this.navigationDefaultRightInfobarClickListener);
    }

    public static final /* synthetic */ EventListener access$getEventListener$p(NavigationFragmentViewModel $this) {
        return $this.eventListener;
    }

    public static final /* synthetic */ void access$setEventListener$p(NavigationFragmentViewModel $this, EventListener eventListener) {
        $this.eventListener = eventListener;
    }

    public static final /* synthetic */ void access$updateInfobarListenersMap(NavigationFragmentViewModel $this, InfobarButtonType buttonType, OnInfobarButtonClickListener listener) {
        $this.updateInfobarListenersMap(buttonType, listener);
    }

    public static final /* synthetic */ ActionMenuData access$getActionMenuData$p(NavigationFragmentViewModel $this) {
        return $this.actionMenuData;
    }

    public static final /* synthetic */ void access$setActionMenuData$p(NavigationFragmentViewModel $this, ActionMenuData actionMenuData) {
        $this.actionMenuData = actionMenuData;
    }

    public static final /* synthetic */ ActionMenuItemClickListener access$getActionMenuItemClickListener$p(NavigationFragmentViewModel $this) {
        return $this.actionMenuItemClickListener;
    }

    public static final /* synthetic */ void access$setActionMenuItemClickListener$p(NavigationFragmentViewModel $this, ActionMenuItemClickListener actionMenuItemClickListener2) {
        $this.actionMenuItemClickListener = actionMenuItemClickListener2;
    }

    public static final /* synthetic */ LocationManager access$getLocationManager$p(NavigationFragmentViewModel $this) {
        return $this.locationManager;
    }

    public static final /* synthetic */ ExtendedCameraModel access$getCameraModel$p(NavigationFragmentViewModel $this) {
        return $this.cameraModel;
    }

    public static final /* synthetic */ NavigationManager access$getNavigationManager$p(NavigationFragmentViewModel $this) {
        return $this.navigationManager;
    }
}

