/*
 * Decompiled with CFR 0.152.
 */
package com.swifttechnology.imepaysdk.presentation.view.activity;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.Window;
import android.widget.ImageView;
import android.widget.Toast;
import com.swifttechnology.imepaysdk.IMEPaymentCallbackProxy;
import com.swifttechnology.imepaysdk.R;
import com.swifttechnology.imepaysdk.presentation.abs.IMEPayActivityContract;
import com.swifttechnology.imepaysdk.presentation.view.component.IMEProgressDialog;
import com.swifttechnology.imepaysdk.presentation.view.fragment.ConfirmationFragment;
import com.swifttechnology.imepaysdk.presentation.view.fragment.MsisdnPromptFragment;
import com.swifttechnology.imepaysdk.presentation.view.fragment.OtpValidationFragment;
import com.swifttechnology.imepaysdk.presentation.view.fragment.SplashFragment;
import com.swifttechnology.imepaysdk.presentation.view.fragment.TryAgainFragment;

public final class IMEPayActivity
extends AppCompatActivity
implements OtpValidationFragment.PaymentTransactionListener,
SplashFragment.SplashFragmentListener,
TryAgainFragment.TryAgainFragmentListener,
MsisdnPromptFragment.MsisdnPromptListener,
ConfirmationFragment.OTPRequestListener,
IMEPayActivityContract {
    FragmentManager fragmentManager;
    ActionBar actionBar;
    ImageView imageView;
    Bundle data;
    private ArgsModel params;
    private IMEPaymentCallbackProxy sajiloPaymentCallback;
    private IMEProgressDialog dialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_ime_pay);
        this.data = this.getIntent().getExtras();
        this.init();
    }

    private void init() {
        this.imageView = (ImageView)this.findViewById(R.id.imageView);
        this.imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IMEPayActivity.this.onBackPressed();
            }
        });
        try {
            this.actionBar = this.getSupportActionBar();
            this.showToolbar(false);
            if (Build.VERSION.SDK_INT >= 21) {
                Window window = this.getWindow();
                window.addFlags(Integer.MIN_VALUE);
                if (Build.VERSION.SDK_INT >= 23) {
                    window.setStatusBarColor(this.getColor(R.color.ime_paycolorPrimaryDark));
                } else if (Build.VERSION.SDK_INT >= 21) {
                    window.setStatusBarColor(this.getResources().getColor(R.color.ime_paycolorPrimaryDark));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fragmentManager = this.getSupportFragmentManager();
        this.params = new ArgsModel();
        if (this.data != null) {
            try {
                this.params.setAmount(this.data.getString("amount"));
                this.params.setMerchantCode(this.data.getString("merchantCode"));
                this.params.setMerchantName(this.data.getString("merchantName"));
                this.params.setMerchantUrl(this.data.getString("merchantUrl"));
                this.params.setModule(this.data.getString("module"));
                this.params.setPassword(this.data.getString("password"));
                this.params.setUser(this.data.getString("user"));
                this.params.setRefId(this.data.getString("refId"));
                this.sajiloPaymentCallback = (IMEPaymentCallbackProxy)this.data.getSerializable("Listener");
            }
            catch (NullPointerException ex) {
                throw new IllegalArgumentException("Incomplete data is sent.");
            }
        } else {
            throw new IllegalArgumentException("No data is sent.");
        }
        MsisdnPromptFragment msisdnPromptFragment = new MsisdnPromptFragment();
        this.addFragment(R.id.activity_sajilo_pay_viewcontainer, msisdnPromptFragment, false);
    }

    protected void onResume() {
        super.onResume();
    }

    protected void onPause() {
        super.onPause();
    }

    @Override
    public void addFragment(int layoutContainerId, Fragment fragment, boolean setTransitionAnimation) {
        FragmentTransaction fragmentTransaction;
        if (fragment != null) {
            fragmentTransaction = this.fragmentManager.beginTransaction();
            if (setTransitionAnimation) {
                fragmentTransaction.setCustomAnimations(R.anim.enter_from_right, R.anim.exit_to_left, R.anim.enter_from_right, R.anim.exit_to_left);
            }
        } else {
            throw new NullPointerException("Fragment cannot be null.");
        }
        fragmentTransaction.replace(layoutContainerId, fragment);
        fragmentTransaction.commitAllowingStateLoss();
    }

    @Override
    public void replaceFragment(int layoutContainerId, Fragment fragment, boolean setTransitionAnimation) {
        FragmentTransaction fragmentTransaction;
        if (fragment != null) {
            fragmentTransaction = this.fragmentManager.beginTransaction();
            if (setTransitionAnimation) {
                fragmentTransaction.setCustomAnimations(R.anim.enter_from_right, R.anim.exit_to_left, R.anim.enter_from_right, R.anim.exit_to_left);
            }
        } else {
            throw new NullPointerException("Fragment cannot be null.");
        }
        fragmentTransaction.replace(layoutContainerId, fragment);
        fragmentTransaction.commit();
    }

    @Override
    public void showProgressBar(boolean action, String message) {
        if (action) {
            if (this.dialog != null) {
                this.dialog.dismiss();
            }
            this.dialog = new IMEProgressDialog();
            this.dialog.setMessage(message);
            this.dialog.show(this.getFragmentManager(), "IMEProgressBar");
        } else if (this.dialog != null) {
            this.dialog.dismiss();
        }
    }

    @Override
    public void showToast(String message) {
        Toast.makeText((Context)this, (CharSequence)message, (int)0).show();
    }

    @Override
    public void showExitDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setCancelable(true);
        builder.setMessage((CharSequence)"Do you really want to abort the payment?");
        builder.setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                IMEPayActivity.this.finish();
            }
        });
        builder.setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int i) {
                dialog.dismiss();
            }
        });
        builder.show();
    }

    @Override
    public ArgsModel getArguments() {
        return this.params;
    }

    @Override
    public void showToolbar(boolean action) throws Exception {
        if (action) {
            this.actionBar.show();
        } else {
            this.actionBar.hide();
        }
    }

    @Override
    public void setMsisdn(String msisdn) {
        if (this.params != null) {
            this.params.setMsisdn(msisdn);
            SplashFragment splashFragment = new SplashFragment();
            this.addFragment(R.id.activity_sajilo_pay_viewcontainer, splashFragment, true);
        }
    }

    @Override
    public void onSplashProcessCompletion(boolean success, String message) {
        if (success) {
            this.params.setToken(message);
            ConfirmationFragment confirmationFragment = new ConfirmationFragment();
            this.replaceFragment(R.id.activity_sajilo_pay_viewcontainer, confirmationFragment, true);
        } else {
            this.params.setToken("");
            this.showTryAgainFragment(700, message);
        }
    }

    @Override
    public void onOTPRequestCompletion(boolean status, String responseMessage, String walletPin) {
        if (status) {
            this.params.setPin(walletPin);
            OtpValidationFragment otpValidationFragment = new OtpValidationFragment();
            this.replaceFragment(R.id.activity_sajilo_pay_viewcontainer, otpValidationFragment, true);
        } else {
            this.showTryAgainFragment(701, responseMessage);
        }
    }

    @Override
    public void onPaymentProcessCompletion(boolean status, int responseCode, String responseMessage, String transactionId) {
        if (status) {
            this.sajiloPaymentCallback.onSuccess(responseCode, responseMessage, transactionId, this.params.getMsisdn(), this.params.getAmount(), this.params.getRefId());
            this.finish();
        } else {
            this.showTryAgainFragment(702, responseMessage);
        }
    }

    public void onBackPressed() {
        this.showExitDialog();
    }

    private void showTryAgainFragment(int fragmentId, String message) {
        int defaultFragmentId = 700;
        Bundle tryAgainData = new Bundle();
        tryAgainData.putInt("callerId", defaultFragmentId);
        tryAgainData.putString("tryAgainMessage", message);
        TryAgainFragment tryAgainFragment = new TryAgainFragment();
        tryAgainFragment.setArguments(tryAgainData);
        this.replaceFragment(R.id.activity_sajilo_pay_viewcontainer, tryAgainFragment, true);
    }

    @Override
    public void onTryAgain(int fragmentId) {
        switch (fragmentId) {
            case 700: {
                if (this.params != null) {
                    this.params.resetTemporaryData();
                }
                SplashFragment splashFragment = new SplashFragment();
                this.replaceFragment(R.id.activity_sajilo_pay_viewcontainer, splashFragment, true);
                break;
            }
            case 701: {
                ConfirmationFragment confirmationFragment = new ConfirmationFragment();
                this.replaceFragment(R.id.activity_sajilo_pay_viewcontainer, confirmationFragment, true);
            }
        }
    }

    public final class ArgsModel {
        private String merchantCode = "";
        private String merchantName = "";
        private String merchantUrl;
        private String user = "";
        private String password = "";
        private String module = "";
        private String msisdn = "";
        private String refId = "";
        private String amount = "";
        private String pin;
        private String otpCode;
        private String token = "";

        protected ArgsModel() {
        }

        public String getMerchantCode() {
            return this.merchantCode;
        }

        private void setMerchantCode(String merchantCode) {
            this.merchantCode = merchantCode;
        }

        public String getMerchantName() {
            return this.merchantName;
        }

        private void setMerchantName(String merchantName) {
            this.merchantName = merchantName;
        }

        public String getMerchantUrl() {
            return this.merchantUrl;
        }

        private void setMerchantUrl(String merchantUrl) {
            this.merchantUrl = merchantUrl;
        }

        public String getUser() {
            return this.user;
        }

        private void setUser(String user) {
            this.user = user;
        }

        public String getPassword() {
            return this.password;
        }

        private void setPassword(String password) {
            this.password = password;
        }

        public String getModule() {
            return this.module;
        }

        private void setModule(String module) {
            this.module = module;
        }

        public String getMsisdn() {
            return this.msisdn;
        }

        private void setMsisdn(String msisdn) {
            this.msisdn = msisdn;
        }

        public String getRefId() {
            return this.refId;
        }

        private void setRefId(String refId) {
            this.refId = refId;
        }

        public String getAmount() {
            return this.amount;
        }

        private void setAmount(String amount) {
            this.amount = amount;
        }

        public String getToken() {
            return this.token;
        }

        private void setToken(String token) {
            this.token = token;
        }

        private void setPin(String pin) {
            this.pin = pin;
        }

        public String getOtpCode() {
            return this.otpCode;
        }

        private void setOtpCode(String otpCode) {
            this.otpCode = otpCode;
        }

        private void resetTemporaryData() {
            this.otpCode = "";
            this.pin = "";
            this.token = "";
        }

        public String toString() {
            return "ArgsModel{merchantCode='" + this.merchantCode + '\'' + ", merchantName='" + this.merchantName + '\'' + ", merchantUrl='" + this.merchantUrl + '\'' + ", user='" + this.user + '\'' + ", password='" + this.password + '\'' + ", module='" + this.module + '\'' + ", msisdn='" + this.msisdn + '\'' + ", refId='" + this.refId + '\'' + ", amount='" + this.amount + '\'' + ", pin='" + this.pin + '\'' + ", otpCode='" + this.otpCode + '\'' + ", token='" + this.token + '\'' + '}';
        }

        public String getValue() {
            String tempPin = this.pin;
            this.pin = "";
            return tempPin;
        }
    }
}

