/*
 * Decompiled with CFR 0.152.
 */
package com.swifttechnology.imepaysdk.presentation.presenter;

import android.util.Log;
import com.swifttech.httpclient.Callback;
import com.swifttech.httpclient.HTTPResponse;
import com.swifttechnology.imepaysdk.network.SplashFragmentHTTPClient;
import com.swifttechnology.imepaysdk.presentation.abs.SplashFragmentContract;
import com.swifttechnology.imepaysdk.presentation.interactor.SplashFragmentInteractor;
import com.swifttechnology.imepaysdk.utils.GeneralUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class SplashFragmentPresenterImpl
implements SplashFragmentContract,
SplashFragmentInteractor {
    SplashFragmentContract.SplashFragmentViewContract splashFragmentViewContract;
    SplashFragmentInteractor.SplashNetworKInteractor splashNetworKInteractor;
    private String sessionAuth;
    private String sessionModule;
    private String sessionMerchantCode;
    private String sessionAmount;
    private String sessionRefId;
    private String sessionToken;
    private String sessionMerchantUrl;

    public SplashFragmentPresenterImpl(SplashFragmentContract.SplashFragmentViewContract listener) {
        this.splashFragmentViewContract = listener;
        this.splashNetworKInteractor = new SplashFragmentHTTPClient(this);
    }

    private void onTokenRecieved(String message, int Status) {
        if (Status == 1) {
            this.sessionToken = message;
            this.postToMerchant();
        } else {
            this.splashFragmentViewContract.showLoadingDialog(false, message);
            this.splashFragmentViewContract.onApplicationValidated(message, -1);
        }
    }

    private void onPostedToMerchant(String message, int Status) {
        this.splashFragmentViewContract.showLoadingDialog(false, message);
        if (Status == 1) {
            this.splashFragmentViewContract.onApplicationValidated(this.sessionToken, Status);
        } else {
            this.splashFragmentViewContract.onApplicationValidated(message, Status);
        }
    }

    @Override
    public void validateApplication(String uname, String password, String merchantCode, String merchantUrl, String module, String amount, String refId) {
        this.splashFragmentViewContract.showLoadingDialog(true, "");
        this.sessionAuth = "Basic " + GeneralUtils.getConvertedStringBase64(uname, password);
        this.sessionModule = GeneralUtils.getConvertedStringBase64(module);
        this.sessionMerchantCode = merchantCode;
        this.sessionMerchantUrl = merchantUrl;
        this.sessionAmount = amount;
        this.sessionRefId = refId;
        this.splashNetworKInteractor.getToken(this.sessionAuth, this.sessionModule, this.sessionMerchantCode, this.sessionAmount, this.sessionRefId, new ApplicationValidationCallback());
    }

    private void postToMerchant() {
        this.splashNetworKInteractor.postToMerchant(this.sessionToken, this.sessionAuth, this.sessionModule, this.sessionMerchantCode, this.sessionMerchantUrl, this.sessionAmount, this.sessionRefId, new PostToMerchantCallback());
    }

    @Override
    public void onFragmentDestroy() {
        this.sessionToken = "";
        this.sessionAmount = "";
        this.sessionMerchantCode = "";
        this.sessionMerchantUrl = "";
        this.sessionAuth = "";
        this.sessionModule = "";
        this.sessionRefId = "";
    }

    public class PostToMerchantCallback
    implements Callback {
        @Override
        public void onSuccess(HTTPResponse response) {
            JSONObject jsonObject = null;
            int appResponseCode = -1;
            String message = "";
            try {
                Log.d((String)"Response Pay", (String)("Response ==" + response.getResponseBody()));
                jsonObject = new JSONObject(response.getResponseBody());
                appResponseCode = jsonObject.getInt("ResponseCode");
                message = jsonObject.getString("ResponseDescription");
            }
            catch (JSONException e) {
                e.printStackTrace();
                appResponseCode = -1;
            }
            switch (appResponseCode) {
                case -1: {
                    SplashFragmentPresenterImpl.this.onPostedToMerchant("Response could not be parsed. (ErrorCode: x102).", -1);
                    break;
                }
                case 1: {
                    SplashFragmentPresenterImpl.this.onPostedToMerchant(message + " (ErrorCode: x102).", -1);
                    break;
                }
                case 0: {
                    SplashFragmentPresenterImpl.this.onPostedToMerchant(message, 1);
                }
            }
        }

        @Override
        public void onFailed(int responseCode) {
            switch (responseCode) {
                case 403: {
                    SplashFragmentPresenterImpl.this.onPostedToMerchant("Connection Forbidden. (ErrorCode: x102).", -1);
                    break;
                }
                case 500: {
                    SplashFragmentPresenterImpl.this.onPostedToMerchant("Internal Server Error. (ErrorCode: x102).", -1);
                    break;
                }
                case 401: {
                    SplashFragmentPresenterImpl.this.onPostedToMerchant("Unauthorized. (ErrorCode: x102).", -1);
                    break;
                }
                default: {
                    SplashFragmentPresenterImpl.this.onPostedToMerchant("Your request could not be processed. Please contact IME pay support if you are getting this message frequently. (ErrorCode: x102).", -1);
                }
            }
        }

        @Override
        public void onConnectionNotEstablished(String message) {
            SplashFragmentPresenterImpl.this.onPostedToMerchant("Connection could not be established. (ErrorCode: x102).", -1);
        }
    }

    public class ApplicationValidationCallback
    implements Callback {
        @Override
        public void onSuccess(HTTPResponse response) {
            JSONObject jsonObject = null;
            int appResponseCode = -1;
            String token = "";
            try {
                jsonObject = new JSONObject(response.getResponseBody());
                appResponseCode = jsonObject.getInt("ResponseCode");
                token = jsonObject.getString("TokenId");
            }
            catch (JSONException e) {
                e.printStackTrace();
                appResponseCode = -1;
            }
            switch (appResponseCode) {
                case -1: {
                    SplashFragmentPresenterImpl.this.onTokenRecieved("Response could not be parsed. (ErrorCode: x101).", -1);
                    break;
                }
                case 1: {
                    SplashFragmentPresenterImpl.this.onTokenRecieved("Token is not generated. (ErrorCode: x101).", -1);
                    break;
                }
                case 0: {
                    SplashFragmentPresenterImpl.this.onTokenRecieved(token, 1);
                }
            }
        }

        @Override
        public void onFailed(int responseCode) {
            switch (responseCode) {
                case 403: {
                    SplashFragmentPresenterImpl.this.onTokenRecieved("Connection Forbidden. (ErrorCode: x101).", -1);
                    break;
                }
                case 500: {
                    SplashFragmentPresenterImpl.this.onTokenRecieved("Internal Server Error. (ErrorCode: x101).", -1);
                    break;
                }
                case 401: {
                    SplashFragmentPresenterImpl.this.onTokenRecieved("Unauthorized. (ErrorCode: x101).", -1);
                    break;
                }
                default: {
                    SplashFragmentPresenterImpl.this.onTokenRecieved("Your request could not be processed. Please contact IME pay support if you are getting this message frequently. (ErrorCode: x101).", -1);
                }
            }
        }

        @Override
        public void onConnectionNotEstablished(String message) {
            SplashFragmentPresenterImpl.this.onTokenRecieved("Connection could not be established. (ErrorCode: x101).", -1);
        }
    }
}

