/*
 * Decompiled with CFR 0.152.
 */
package com.swifttechnology.imepaysdk.presentation.presenter;

import android.os.Handler;
import android.os.Looper;
import com.swifttech.httpclient.Callback;
import com.swifttech.httpclient.HTTPResponse;
import com.swifttechnology.imepaysdk.network.OTPValidationFragmentHTTPClient;
import com.swifttechnology.imepaysdk.presentation.abs.OTPValidationFragmentContract;
import com.swifttechnology.imepaysdk.presentation.interactor.OTPValidationFragmentInteractor;
import com.swifttechnology.imepaysdk.utils.GeneralUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class OTPValidationFragmentPresenterImpl
implements OTPValidationFragmentContract,
OTPValidationFragmentInteractor {
    private OTPValidationFragmentContract.OTPValidationFragmentViewContract confirmationFragmentViewContract;
    private OTPValidationFragmentInteractor.OTPValidationNetworkInteractor confirmationNetworKInteractor;
    private String _uname = "";
    private String _password = "";
    private String _merchantCode = "";
    private String _refId = "";
    private String _msisdn = "";
    private String _module = "";
    private String _transactionId = "";
    private boolean firstTimeConfirm = true;
    private String TAG = "PAYMENTHTTP";

    public OTPValidationFragmentPresenterImpl(OTPValidationFragmentContract.OTPValidationFragmentViewContract listener) {
        this.confirmationFragmentViewContract = listener;
        this.confirmationNetworKInteractor = new OTPValidationFragmentHTTPClient(this);
    }

    @Override
    public void validateOTP(String otp, String msisdn, String module, String merchantCode, String username, String password) {
        this._uname = username;
        this._password = password;
        this._merchantCode = merchantCode;
        String auth = "Basic " + GeneralUtils.getConvertedStringBase64(username, password);
        String module_val = GeneralUtils.getConvertedStringBase64(module);
        this.confirmationNetworKInteractor.validateOTP(otp, msisdn, auth, module_val, this._merchantCode, new OTPValidateCallback());
    }

    @Override
    public void validatePaymentParams(String uname, String password, String merchantCode, String module, String amount, String refId, String msisdn, String pin, String tokenId) {
        this._uname = uname;
        this._password = password;
        this._merchantCode = merchantCode;
        this._refId = refId;
        this._msisdn = msisdn;
        this._module = module;
        this.confirmationFragmentViewContract.showLoadingDialog(true, "Processing Payment Request...");
        if (tokenId.length() == 0) {
            this.confirmationFragmentViewContract.showLoadingDialog(false, "");
            this.confirmationFragmentViewContract.onPaymentResultRecieved("", "Token is not generated.", -1);
            return;
        }
        String auth = "Basic " + GeneralUtils.getConvertedStringBase64(uname, password);
        String module_val = GeneralUtils.getConvertedStringBase64(this._module);
        this.confirmationNetworKInteractor.performPayment(auth, merchantCode, module_val, amount, refId, msisdn, pin, tokenId, new PaymentCallback());
    }

    private void confirmPayment(String transactionId) {
        String auth = "Basic " + GeneralUtils.getConvertedStringBase64(this._uname, this._password);
        String module_val = GeneralUtils.getConvertedStringBase64(this._module);
        this.confirmationNetworKInteractor.confirmPayment(auth, this._merchantCode, module_val, transactionId, this._refId, this._msisdn, new ConfirmCallback());
    }

    public class OTPValidateCallback
    implements Callback {
        @Override
        public void onSuccess(HTTPResponse response) {
            int appResponseCode = -1;
            String appResponseString = "";
            String transactionId = "";
            try {
                JSONObject jsonObject = new JSONObject(response.getResponseBody());
                appResponseCode = jsonObject.getInt("ResponseCode");
                appResponseString = jsonObject.getString("ResponseDescription");
            }
            catch (JSONException e) {
                e.printStackTrace();
                appResponseCode = -1;
            }
            switch (appResponseCode) {
                case 1: {
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.showLoadingDialog(false, "");
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onOTPValidation(false, appResponseString);
                    break;
                }
                case 0: {
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.showLoadingDialog(false, "");
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onOTPValidation(true, null);
                }
            }
        }

        @Override
        public void onFailed(int responseCode) {
            OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.showLoadingDialog(false, "");
            switch (responseCode) {
                case 403: {
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onOTPValidation(false, "Connection Forbidden.");
                    break;
                }
                case 500: {
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onOTPValidation(false, "Internal Server Error.");
                    break;
                }
                case 401: {
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onOTPValidation(false, "Unauthorized.");
                    break;
                }
                default: {
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onOTPValidation(false, "Your request could not be processed. Please contact IME pay support if you are getting this message frequently.");
                }
            }
        }

        @Override
        public void onConnectionNotEstablished(String message) {
            OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.showLoadingDialog(false, "");
            OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onOTPValidation(false, "Connection could not be established.");
        }
    }

    public class ConfirmCallback
    implements Callback {
        @Override
        public void onSuccess(HTTPResponse response) {
            JSONObject jsonObject = null;
            int appResponseCode = -1;
            String appResponseString = "";
            try {
                jsonObject = new JSONObject(response.getResponseBody());
                appResponseCode = jsonObject.getInt("ResponseCode");
                appResponseString = jsonObject.getString("ResponseDescription");
            }
            catch (JSONException e) {
                e.printStackTrace();
                appResponseCode = -1;
            }
            switch (appResponseCode) {
                case -1: {
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.showLoadingDialog(false, "");
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onPaymentResultRecieved("", "Response could not be parsed.", -1);
                    break;
                }
                case 1: {
                    if (OTPValidationFragmentPresenterImpl.this.firstTimeConfirm) {
                        OTPValidationFragmentPresenterImpl.this.firstTimeConfirm = false;
                        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                OTPValidationFragmentPresenterImpl.this.confirmPayment(OTPValidationFragmentPresenterImpl.this._transactionId);
                            }
                        }, 5000L);
                        break;
                    }
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.showLoadingDialog(false, "");
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onPaymentResultRecieved(OTPValidationFragmentPresenterImpl.this._transactionId, appResponseString, 101);
                    break;
                }
                case 0: {
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.showLoadingDialog(false, "");
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onPaymentResultRecieved(OTPValidationFragmentPresenterImpl.this._transactionId, appResponseString, 100);
                }
            }
        }

        @Override
        public void onFailed(int responseCode) {
            OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.showLoadingDialog(false, "");
            switch (responseCode) {
                case 403: {
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onPaymentResultRecieved("", "Connection Forbidden.", -1);
                    break;
                }
                case 500: {
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onPaymentResultRecieved("", "Internal Server Error.", -1);
                    break;
                }
                case 401: {
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onPaymentResultRecieved("", "Unauthorized.", -1);
                    break;
                }
                default: {
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onPaymentResultRecieved("", "Your request could not be processed. Please contact IME pay support if you are getting this message frequently.", -1);
                }
            }
        }

        @Override
        public void onConnectionNotEstablished(String message) {
            OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.showLoadingDialog(false, "");
            OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onPaymentResultRecieved("", "Connection could not be established.", -1);
        }
    }

    public class PaymentCallback
    implements Callback {
        @Override
        public void onSuccess(HTTPResponse response) {
            int appResponseCode = -1;
            String appResponseString = "";
            String transactionId = "";
            try {
                JSONObject jsonObject = new JSONObject(response.getResponseBody());
                appResponseCode = jsonObject.getInt("ResponseCode");
                appResponseString = jsonObject.getString("ResponseDescription");
                transactionId = jsonObject.getString("TransactionId");
            }
            catch (JSONException e) {
                e.printStackTrace();
                appResponseCode = -1;
            }
            switch (appResponseCode) {
                case -1: {
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.showLoadingDialog(false, "");
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onPaymentResultRecieved("", "Response could not be parsed.", -1);
                    break;
                }
                case 1: {
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.showLoadingDialog(false, "");
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onPaymentResultRecieved("", appResponseString, -1);
                    break;
                }
                case 0: {
                    OTPValidationFragmentPresenterImpl.this._transactionId = transactionId;
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.showLoadingDialog(false, "");
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.showLoadingDialog(true, "Confirming Payment Request...");
                    new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            OTPValidationFragmentPresenterImpl.this.confirmPayment(OTPValidationFragmentPresenterImpl.this._transactionId);
                        }
                    }, 5000L);
                }
            }
        }

        @Override
        public void onFailed(int responseCode) {
            OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.showLoadingDialog(false, "");
            switch (responseCode) {
                case 403: {
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onPaymentResultRecieved("", "Connection Forbidden.", -1);
                    break;
                }
                case 500: {
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onPaymentResultRecieved("", "Internal Server Error.", -1);
                    break;
                }
                case 401: {
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onPaymentResultRecieved("", "Unauthorized.", -1);
                    break;
                }
                default: {
                    OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onPaymentResultRecieved("", "Your request could not be processed. Please contact IME pay support if you are getting this message frequently.", -1);
                }
            }
        }

        @Override
        public void onConnectionNotEstablished(String message) {
            OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.showLoadingDialog(false, "");
            OTPValidationFragmentPresenterImpl.this.confirmationFragmentViewContract.onPaymentResultRecieved("", "Connection could not be established.", -1);
        }
    }
}

