/*
 * Decompiled with CFR 0.152.
 */
package com.swifttechnology.imepaysdk.network;

import android.util.Log;
import com.swifttech.httpclient.HTTPClient;
import com.swifttechnology.imepaysdk.UrlConfig;
import com.swifttechnology.imepaysdk.presentation.interactor.SplashFragmentInteractor;
import com.swifttechnology.imepaysdk.presentation.presenter.SplashFragmentPresenterImpl;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class SplashFragmentHTTPClient
implements SplashFragmentInteractor.SplashNetworKInteractor {
    private SplashFragmentInteractor splashFragmentInteractor;
    private String TAG = "SPLASHHTTP";

    public SplashFragmentHTTPClient(SplashFragmentInteractor caller) {
        this.splashFragmentInteractor = caller;
    }

    @Override
    public void getToken(String auth, String module, String merchantCode, String amount, String refId, SplashFragmentPresenterImpl.ApplicationValidationCallback applicationValidationCallback) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("MerchantCode", (Object)merchantCode);
            jsonObject.put("Amount", (Object)amount);
            jsonObject.put("RefId", (Object)refId);
        }
        catch (JSONException ex) {
            Log.d((String)this.TAG, (String)ex.getMessage());
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", auth);
        header.put("Module", module);
        header.put("Content-Type", "application/json;charset=UTF-8");
        Runnable paymentTask = HTTPClient.request(UrlConfig.getBaseURL() + "Web/GetToken", header, "POST", jsonObject.toString(), applicationValidationCallback);
        HTTPClient.enqueue(paymentTask);
    }

    @Override
    public void postToMerchant(String token, String auth, String module, String merchantCode, String merchantUrl, String amount, String refId, SplashFragmentPresenterImpl.PostToMerchantCallback postToMerchantCallback) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("TokenId", (Object)token);
            jsonObject.put("Amount", (Object)amount);
            jsonObject.put("ReferenceId", (Object)refId);
            jsonObject.put("MerchantCode", (Object)merchantCode);
        }
        catch (JSONException ex) {
            Log.d((String)this.TAG, (String)ex.getMessage());
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", auth);
        header.put("Module", module);
        header.put("Content-Type", "application/json;charset=UTF-8");
        Runnable paymentTask = HTTPClient.request(merchantUrl, header, "POST", jsonObject.toString(), postToMerchantCallback);
        HTTPClient.enqueue(paymentTask);
    }
}

