/*
 * Decompiled with CFR 0.152.
 */
package com.swifttechnology.imepaysdk;

import android.content.Context;
import android.content.Intent;
import com.swifttechnology.imepaysdk.ENVIRONMENT;
import com.swifttechnology.imepaysdk.IMEPaymentCallback;
import com.swifttechnology.imepaysdk.IMEPaymentCallbackProxy;
import com.swifttechnology.imepaysdk.UrlConfig;
import com.swifttechnology.imepaysdk.presentation.view.activity.IMEPayActivity;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public final class IMEPayment {
    private Context context = null;
    private static IMEPaymentCallback IMEPaymentCallback = null;

    public IMEPayment(Context _context, ENVIRONMENT environment) {
        this.context = _context;
        if (environment == ENVIRONMENT.LIVE) {
            UrlConfig.setPlatformLive(true);
        } else {
            UrlConfig.setPlatformLive(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void performPayment(String merchantCode, String merchantName, String merchantUrl, String amount, String refId, String module, String user, String password, IMEPaymentCallback paymentCallback) {
        try {
            new URL(merchantUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The merchant Url is not valid");
        }
        if (merchantCode == null || merchantCode.length() > 9) throw new IllegalArgumentException("Invalid Merchant Code.");
        if (merchantName == null || merchantName.length() < 1) throw new IllegalArgumentException("Invalid Merchant Name.");
        if (!this.validateCurrency(amount)) throw new IllegalArgumentException("Invalid Amount: " + amount + ". Please enter proper amount");
        if (refId == null) {
            throw new IllegalArgumentException("Invalid Reference Id.");
        }
        if (module == null || merchantName.length() < 1) throw new IllegalArgumentException("Invalid Module.");
        if (user == null || user.length() < 1) throw new IllegalArgumentException("Invalid User.");
        if (password == null || password.length() < 1) {
            throw new IllegalArgumentException("Invalid password.");
        }
        Intent intent = new Intent(this.context, IMEPayActivity.class);
        intent.putExtra("merchantCode", merchantCode);
        intent.putExtra("merchantName", merchantName);
        intent.putExtra("merchantUrl", merchantUrl);
        intent.putExtra("amount", amount);
        intent.putExtra("refId", refId);
        intent.putExtra("module", module);
        intent.putExtra("user", user);
        intent.putExtra("password", password);
        IMEPaymentCallback = paymentCallback;
        intent.putExtra("Listener", (Serializable)new MainCallback());
        intent.addFlags(0x10000000);
        intent.addFlags(131072);
        this.context.startActivity(intent);
    }

    private boolean validateCurrency(String amount) {
        if (amount == null || amount.length() < 1) {
            return false;
        }
        String regex = amount.contains(".") ? "[\\d]*\\.[\\d]+" : "[\\d]+";
        return amount.matches(regex);
    }

    static class MainCallback
    extends IMEPaymentCallbackProxy {
        MainCallback() {
        }

        @Override
        public void onSuccess(int responseCode, String responseDescription, String transactionId, String msisdn, String amount, String refId) {
            if (IMEPaymentCallback == null) {
                throw new NullPointerException("IMEPaymentCallback cannot be null");
            }
            IMEPaymentCallback.onSuccess(responseCode, responseDescription, transactionId, msisdn, amount, refId);
        }
    }
}

