/*
 * Decompiled with CFR 0.152.
 */
package com.swifttech.httpclient;

import com.swifttech.httpclient.Callback;
import com.swifttech.httpclient.HTTPClient;
import com.swifttech.httpclient.HTTPResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public final class PostTask
implements Runnable {
    HttpURLConnection httpURLConnection = null;
    URL urlObj = null;
    Map<String, String> header = null;
    String body = null;
    OutputStreamWriter outputStream;
    InputStreamReader inputStream;
    Callback callback;

    protected PostTask(URL url, Map<String, String> head, String bdy, Callback listener) {
        this.urlObj = url;
        this.header = head;
        this.body = bdy;
        this.callback = listener;
    }

    @Override
    public void run() {
        block10: {
            try {
                this.httpURLConnection = (HttpURLConnection)this.urlObj.openConnection();
                this.httpURLConnection.setRequestMethod("POST");
                this.httpURLConnection.setConnectTimeout(15000);
                this.httpURLConnection.setDoInput(true);
                this.httpURLConnection.setDoOutput(true);
                if (this.header != null) {
                    for (Map.Entry<String, String> me : this.header.entrySet()) {
                        this.httpURLConnection.setRequestProperty(me.getKey().toString(), me.getValue().toString());
                    }
                }
                this.httpURLConnection.connect();
                if (this.body == null) {
                    this.body = "";
                }
                this.outputStream = new OutputStreamWriter(this.httpURLConnection.getOutputStream());
                this.outputStream.write(this.body);
                this.outputStream.flush();
                StringBuilder sb = new StringBuilder();
                final HTTPResponse response = new HTTPResponse();
                final int rcode = this.httpURLConnection.getResponseCode();
                if (rcode > 199 && rcode < 300) {
                    this.inputStream = new InputStreamReader(this.httpURLConnection.getInputStream());
                    BufferedReader br = new BufferedReader(this.inputStream);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                    br.close();
                    response.setResponseCode(rcode);
                    response.setResponseBody(sb.toString());
                    this.httpURLConnection.disconnect();
                    if (this.callback != null) {
                        HTTPClient.getMainThreadHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    PostTask.this.callback.onSuccess(response);
                                }
                                catch (IllegalStateException illegalStateException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                } else {
                    this.httpURLConnection.disconnect();
                    if (this.callback != null) {
                        HTTPClient.getMainThreadHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    PostTask.this.callback.onFailed(rcode);
                                }
                                catch (IllegalStateException illegalStateException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                }
            }
            catch (IOException exception) {
                this.httpURLConnection.disconnect();
                if (this.callback == null) break block10;
                HTTPClient.getMainThreadHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PostTask.this.callback.onConnectionNotEstablished(exception.getMessage());
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                });
            }
        }
    }
}

