/*
 * Decompiled with CFR 0.152.
 */
package com.sw.compat.webview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.webkit.WebView;
import com.sw.compat.webview.CompatWebViewClient;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class CompatWebView
extends WebView {
    private static final String DEFAULT_SCHEME = "CompatScheme";
    private static final String JAVASCRIPT_ANNOTATION = "@android.webkit.JavascriptInterface()";
    private String scheme;
    private HashMap<String, Object> injectHashMap = new HashMap();

    public CompatWebView(Context context) {
        this(context, null);
    }

    public CompatWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.scheme = DEFAULT_SCHEME.toLowerCase();
        this.removeJavascriptInterface("searchBoxJavaBridge_");
        this.removeJavascriptInterface("accessibility");
        this.removeJavascriptInterface("accessibilityTraversal");
        this.setWebViewClient(new CompatWebViewClient());
    }

    public void setScheme(String scheme) {
        if (TextUtils.isEmpty((CharSequence)scheme)) {
            return;
        }
        this.scheme = scheme.toLowerCase();
    }

    public String getScheme() {
        return this.scheme;
    }

    public void compatEvaluateJavascript(String javascript) {
        if (Build.VERSION.SDK_INT <= 18) {
            this.loadUrl("javascript:" + javascript);
        } else {
            this.evaluateJavascript(javascript, null);
        }
    }

    @SuppressLint(value={"JavascriptInterface", "AddJavascriptInterface"})
    public void compatAddJavascriptInterface(Object object, String name) {
        if (Build.VERSION.SDK_INT >= 17) {
            this.addJavascriptInterface(object, name);
        } else {
            this.injectHashMap.put(name, object);
        }
    }

    private void injectJsInterfaceForCompat(Object object, String name) {
        Class<?> clazz = object.getClass();
        Method[] methods = clazz.getMethods();
        if (methods == null) {
            return;
        }
        StringBuilder sb = new StringBuilder("window.").append(name).append(" = {};");
        for (Method method : methods) {
            int i;
            if (!CompatWebView.checkMethodValid(method)) continue;
            sb.append("window.").append(name).append(".");
            sb.append(method.getName()).append(" = function(");
            Class<?>[] parameterTypes = method.getParameterTypes();
            int paramSize = parameterTypes.length;
            ArrayList<String> paramList = new ArrayList<String>();
            for (i = 0; i < paramSize; ++i) {
                String tmp = "param" + i;
                sb.append(tmp);
                paramList.add(tmp);
                if (i >= paramSize - 1) continue;
                sb.append(",");
            }
            sb.append("){schemeEncode = encodeURIComponent(\"").append(name).append("?fun=").append(method.getName());
            if (paramList.size() == 0) {
                sb.append("\"");
            } else {
                for (i = 0; i < paramList.size(); ++i) {
                    sb.append("&").append((String)paramList.get(i)).append("=\"+").append((String)paramList.get(i));
                    if (i >= paramSize - 1) continue;
                    sb.append("+\"");
                }
            }
            sb.append("); window.location.href =\"").append(this.scheme).append("://\"").append("+schemeEncode;};");
        }
        this.compatEvaluateJavascript(sb.toString());
    }

    private static boolean checkMethodValid(Method method) {
        Annotation[] annotations = method.getAnnotations();
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!JAVASCRIPT_ANNOTATION.equals(annotation.toString())) continue;
                return true;
            }
        }
        return false;
    }

    boolean shouldOverrideUrlLoading(String url) {
        try {
            String urlDecode = URLDecoder.decode(url, "UTF-8");
            if (urlDecode.startsWith(this.scheme)) {
                JavaMethod javaMethod = this.decodeMethodFromUri(urlDecode);
                if (javaMethod == null) {
                    return false;
                }
                return javaMethod.invoke(this.injectHashMap);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return false;
    }

    void onPageFinished() {
        for (String name : this.injectHashMap.keySet()) {
            Object object = this.injectHashMap.get(name);
            this.injectJsInterfaceForCompat(object, name);
        }
    }

    private JavaMethod decodeMethodFromUri(String url) {
        if (url == null) {
            return null;
        }
        Uri decodeUri = Uri.parse((String)url);
        String dScheme = decodeUri.getScheme();
        String authority = decodeUri.getAuthority();
        Set params = decodeUri.getQueryParameterNames();
        if (!this.scheme.equals(dScheme) || authority == null || !params.contains("fun")) {
            return null;
        }
        JavaMethod javaMethod = new JavaMethod();
        javaMethod.object = authority;
        javaMethod.methodName = decodeUri.getQueryParameter("fun");
        for (String name : params) {
            if ("fun".equals(name)) continue;
            javaMethod.params.put(name, decodeUri.getQueryParameter(name));
        }
        return javaMethod;
    }

    private static class JavaMethod {
        String object;
        String methodName;
        LinkedHashMap<String, String> params = new LinkedHashMap();
        private boolean isFindMethod = false;

        private JavaMethod() {
        }

        private List<Class<?>> getParamTypes(String obj) {
            ArrayList allTypes = new ArrayList();
            allTypes.add(String.class);
            if (TextUtils.isDigitsOnly((CharSequence)obj)) {
                allTypes.add(Integer.TYPE);
                allTypes.add(Long.TYPE);
                allTypes.add(Short.TYPE);
                allTypes.add(Float.TYPE);
                allTypes.add(Double.TYPE);
            } else if (this.isFloatOrDouble(obj)) {
                allTypes.add(Float.TYPE);
                allTypes.add(Double.TYPE);
            } else if (obj.length() == 1) {
                allTypes.add(Character.TYPE);
            }
            return allTypes;
        }

        private boolean isFloatOrDouble(String str) {
            if (null == str || "".equals(str)) {
                return false;
            }
            Pattern pattern = Pattern.compile("^[-\\+]?[.\\d]*$");
            return pattern.matcher(str).matches();
        }

        private Object convertByType(String obj, Class<?> type) {
            if (type == String.class) {
                return obj;
            }
            if (type == Integer.TYPE) {
                return Integer.parseInt(obj);
            }
            if (type == Long.TYPE) {
                return Long.parseLong(obj);
            }
            if (type == Short.TYPE) {
                return Short.parseShort(obj);
            }
            if (type == Float.TYPE) {
                return Float.valueOf(Float.parseFloat(obj));
            }
            if (type == Double.TYPE) {
                return Double.parseDouble(obj);
            }
            if (type == Character.TYPE && obj != null && obj.length() == 1) {
                return Character.valueOf(obj.charAt(0));
            }
            return obj;
        }

        boolean invoke(HashMap<String, Object> injectHashMap) {
            Class[] paramType = new Class[this.params.size()];
            Object[] paramObj = new Object[this.params.size()];
            this.dfs(injectHashMap, 0, paramType, paramObj);
            return this.isFindMethod;
        }

        private void dfs(HashMap<String, Object> injectHashMap, int index, Class<?>[] paramType, Object[] paramObj) {
            if (this.isFindMethod) {
                return;
            }
            if (index == this.params.size()) {
                this.tryToInvoke(injectHashMap, paramType, paramObj);
                return;
            }
            String key = (String)this.params.keySet().toArray()[index];
            List<Class<?>> keyTypes = this.getParamTypes(this.params.get(key));
            for (int i = 0; i < keyTypes.size(); ++i) {
                paramType[index] = keyTypes.get(i);
                paramObj[index] = this.convertByType(this.params.get(key), keyTypes.get(i));
                this.dfs(injectHashMap, index + 1, paramType, paramObj);
            }
        }

        private void tryToInvoke(HashMap<String, Object> injectHashMap, Class<?>[] paramType, Object[] paramObj) {
            Object injectInstance = injectHashMap.get(this.object);
            if (injectInstance == null) {
                return;
            }
            Class<?> clazz = injectInstance.getClass();
            try {
                Method method = clazz.getMethod(this.methodName, paramType);
                if (CompatWebView.checkMethodValid(method)) {
                    method.setAccessible(true);
                    method.invoke(injectInstance, paramObj);
                    this.isFindMethod = true;
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        public String toString() {
            return "JavaMethod{object='" + this.object + '\'' + ", methodName='" + this.methodName + '\'' + ", params=" + this.params + '}';
        }
    }
}

