/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.client.impl;

import com.suse.salt.netapi.config.ClientConfig;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import javax.xml.bind.DatatypeConverter;

public class RequestFactory {
    private static final RequestFactory INSTANCE = new RequestFactory();

    private RequestFactory() {
    }

    public static RequestFactory getInstance() {
        return INSTANCE;
    }

    public HttpURLConnection initConnection(String method, String endpoint, ClientConfig config) throws IOException {
        HttpURLConnection connection;
        URL url = config.get(ClientConfig.URL).resolve(endpoint).toURL();
        String proxyHost = config.get(ClientConfig.PROXY_HOSTNAME);
        if (proxyHost != null) {
            int proxyPort = config.get(ClientConfig.PROXY_PORT);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            connection = (HttpURLConnection)url.openConnection(proxy);
            String proxyUsername = config.get(ClientConfig.PROXY_USERNAME);
            String proxyPassword = config.get(ClientConfig.PROXY_PASSWORD);
            if (proxyUsername != null && proxyPassword != null) {
                String encoded = DatatypeConverter.printBase64Binary((byte[])(proxyUsername + ':' + proxyPassword).getBytes());
                connection.addRequestProperty("Proxy-Authorization", encoded);
            }
        } else {
            connection = (HttpURLConnection)url.openConnection();
        }
        connection.setRequestMethod(method);
        connection.setRequestProperty("Accept", "application/json");
        String token = config.get(ClientConfig.TOKEN);
        if (token != null) {
            connection.setRequestProperty("X-Auth-Token", token);
        }
        return connection;
    }
}

