/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.event;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.datatypes.Event;
import com.suse.salt.netapi.parser.JsonParser;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JobReturnEvent {
    private static final Pattern PATTERN = Pattern.compile("^salt/job/([^/]+)/ret/([^/]+)$");
    private final String jobId;
    private final String minionId;
    private final Data data;
    private static final Gson GSON = JsonParser.GSON;

    private JobReturnEvent(String jobIdIn, String minionIdIn, Data dataIn) {
        this.jobId = jobIdIn;
        this.minionId = minionIdIn;
        this.data = dataIn;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getMinionId() {
        return this.minionId;
    }

    public Data getData() {
        return this.data;
    }

    public static Optional<JobReturnEvent> parse(Event event) {
        Matcher matcher = PATTERN.matcher(event.getTag());
        if (matcher.matches()) {
            Data data = event.getData(Data.class);
            JobReturnEvent result = new JobReturnEvent(matcher.group(1), matcher.group(2), data);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public static class Data {
        @SerializedName(value="_stamp")
        private String timestamp;
        private String cmd;
        private String fun;
        @SerializedName(value="fun_args")
        private Object funArgs;
        private String id;
        private String jid;
        private Optional<String> schedule = Optional.empty();
        private String out;
        private int retcode = 0;
        private boolean success = false;
        private Optional<JsonElement> metadata = Optional.empty();
        @SerializedName(value="return")
        private JsonElement result;

        public String getTimestamp() {
            return this.timestamp;
        }

        public String getCmd() {
            return this.cmd;
        }

        public String getFun() {
            return this.fun;
        }

        public Object getFunArgs() {
            return this.funArgs;
        }

        public String getId() {
            return this.id;
        }

        public String getJid() {
            return this.jid;
        }

        public String getOut() {
            return this.out;
        }

        public int getRetcode() {
            return this.retcode;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public Object getResult() {
            return GSON.fromJson(this.result, Object.class);
        }

        public <R> R getResult(Class<R> dataType) {
            return (R)GSON.fromJson(this.result, dataType);
        }

        public <R> R getResult(TypeToken<R> dataType) {
            return (R)GSON.fromJson(this.result, dataType.getType());
        }

        public Optional<Object> getMetadata() {
            return this.metadata.flatMap(md -> {
                try {
                    return Optional.ofNullable(GSON.fromJson(md, Object.class));
                }
                catch (JsonSyntaxException ex) {
                    return Optional.empty();
                }
            });
        }

        public <R> Optional<R> getMetadata(Class<R> dataType) {
            return this.metadata.flatMap(md -> {
                try {
                    return Optional.ofNullable(GSON.fromJson(md, dataType));
                }
                catch (JsonSyntaxException ex) {
                    return Optional.empty();
                }
            });
        }

        public <R> Optional<R> getMetadata(TypeToken<R> dataType) {
            return this.metadata.flatMap(md -> {
                try {
                    return Optional.ofNullable(GSON.fromJson(md, dataType.getType()));
                }
                catch (JsonSyntaxException ex) {
                    return Optional.empty();
                }
            });
        }

        public Optional<String> getSchedule() {
            return this.schedule;
        }
    }
}

