/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.client.impl;

import com.suse.salt.netapi.client.Connection;
import com.suse.salt.netapi.client.impl.RequestFactory;
import com.suse.salt.netapi.config.ClientConfig;
import com.suse.salt.netapi.exception.SaltException;
import com.suse.salt.netapi.parser.JsonParser;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;

public class JDKConnection<T>
implements Connection<T> {
    private final String endpoint;
    private final ClientConfig config;
    private final JsonParser<T> parser;

    public JDKConnection(String endpointIn, JsonParser<T> parserIn, ClientConfig configIn) {
        this.endpoint = endpointIn;
        this.config = configIn;
        this.parser = parserIn;
    }

    @Override
    public T getResult(String data) throws SaltException {
        return this.request("POST", data);
    }

    @Override
    public T getResult() throws SaltException {
        return this.request("GET", null);
    }

    private T request(String method, String data) throws SaltException {
        HttpURLConnection connection = null;
        try {
            int responseCode;
            int socketTimeout;
            connection = RequestFactory.getInstance().initConnection(method, this.endpoint, this.config);
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            int connectTimeout = this.config.get(ClientConfig.CONNECT_TIMEOUT);
            if (connectTimeout >= 0) {
                connection.setConnectTimeout(connectTimeout);
            }
            if ((socketTimeout = this.config.get(ClientConfig.SOCKET_TIMEOUT).intValue()) >= 0) {
                connection.setReadTimeout(socketTimeout);
            }
            if (data != null) {
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("Content-Length", Integer.toString(data.getBytes().length));
                DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
                outputStream.writeBytes(data);
                outputStream.flush();
                outputStream.close();
            }
            if ((responseCode = connection.getResponseCode()) == 200 || responseCode == 202) {
                T t = this.parser.parse(connection.getInputStream());
                return t;
            }
            try {
                throw new SaltException("Response code: " + responseCode);
            }
            catch (IOException e) {
                throw new SaltException(e);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

