/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.event;

import com.suse.salt.netapi.datatypes.Event;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MinionStartEvent {
    private static final Pattern PATTERN = Pattern.compile("^salt/minion/([^/]+)/start$");
    private final String minionId;
    private final Map<String, Object> data;

    public MinionStartEvent(String minionId, Map<String, Object> data) {
        this.minionId = minionId;
        this.data = data;
    }

    public String getMinionId() {
        return this.minionId;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public static Optional<MinionStartEvent> parse(Event event) {
        Matcher matcher = PATTERN.matcher(event.getTag());
        if (matcher.matches()) {
            MinionStartEvent result = new MinionStartEvent(matcher.group(1), event.getData());
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

