/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.AuthModule;
import com.suse.salt.netapi.calls.Call;
import com.suse.salt.netapi.calls.Client;
import com.suse.salt.netapi.calls.SaltSSHConfig;
import com.suse.salt.netapi.calls.SaltSSHUtils;
import com.suse.salt.netapi.client.AsyncHttpClient;
import com.suse.salt.netapi.datatypes.AuthMethod;
import com.suse.salt.netapi.datatypes.Token;
import com.suse.salt.netapi.datatypes.cherrypy.Stats;
import com.suse.salt.netapi.datatypes.target.Target;
import com.suse.salt.netapi.event.EventListener;
import com.suse.salt.netapi.event.WebSocketEventStream;
import com.suse.salt.netapi.exception.SaltException;
import com.suse.salt.netapi.parser.JsonParser;
import com.suse.salt.netapi.results.Result;
import com.suse.salt.netapi.results.SSHRawResult;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public class SaltClient {
    private final AsyncHttpClient asyncHttpClient;
    private final URI uri;
    private final Gson gson = new GsonBuilder().create();

    public SaltClient(URI url, AsyncHttpClient asyncHttpClient) {
        this.uri = url.resolve("/");
        this.asyncHttpClient = asyncHttpClient;
    }

    public CompletionStage<Token> login(String username, String password, AuthModule eauth) {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("username", username);
        props.put("password", password);
        props.put("eauth", eauth.getValue());
        String payload = this.gson.toJson(props);
        CompletionStage<Token> result = this.asyncHttpClient.post(this.uri.resolve("login"), payload, JsonParser.TOKEN).thenApply(r -> {
            Token token = (Token)((List)r.getResult()).get(0);
            return token;
        });
        return result;
    }

    public CompletionStage<Boolean> logout() {
        return this.asyncHttpClient.post(this.uri.resolve("logout"), "", JsonParser.STRING).thenApply(s -> "Your token has been cleared".contentEquals((CharSequence)s.getResult()));
    }

    public <T> CompletionStage<Map<String, Object>> run(String username, String password, AuthModule eauth, String client, Target<T> target, String function, List<Object> args, Map<String, Object> kwargs) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("username", username);
        props.put("password", password);
        props.put("eauth", eauth.getValue());
        props.put("client", client);
        props.putAll(target.getProps());
        props.put("fun", function);
        props.put("arg", args);
        props.put("kwarg", kwargs);
        List list = Collections.singletonList(props);
        String payload = this.gson.toJson(list);
        CompletionStage<Map<String, Object>> result = this.asyncHttpClient.post(this.uri.resolve("run"), payload, JsonParser.RUN_RESULTS).thenApply(s -> (Map)((List)s.getResult()).get(0));
        return result;
    }

    public <T> CompletionStage<Map<String, Result<SSHRawResult>>> runRawSSHCommand(String command, Target<T> target, SaltSSHConfig cfg) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("client", Client.SSH.getValue());
        props.putAll(target.getProps());
        props.put("fun", command);
        props.put("raw_shell", true);
        SaltSSHUtils.mapConfigPropsToArgs(cfg, props);
        List<HashMap<String, Object>> list = Collections.singletonList(props);
        String payload = this.gson.toJson(list);
        CompletionStage<Map<String, Result<SSHRawResult>>> result = this.asyncHttpClient.post(this.uri.resolve("run"), payload, JsonParser.RUNSSHRAW_RESULTS).thenApply(r -> (Map)((List)r.getResult()).get(0));
        return result;
    }

    public CompletionStage<Stats> stats() {
        return this.asyncHttpClient.get(this.uri.resolve("stats"), JsonParser.STATS);
    }

    public WebSocketEventStream events(Token token, long sessionIdleTimeout, long idleTimeout, int maxMsgSize, EventListener ... listeners) throws SaltException {
        return new WebSocketEventStream(this.uri, token, sessionIdleTimeout, idleTimeout, maxMsgSize, listeners);
    }

    public <R> CompletionStage<R> call(Call<?> call, Client client, Optional<Target<?>> target, Map<String, Object> custom, TypeToken<R> type, AuthMethod auth) {
        HashMap<String, String> headers = new HashMap<String, String>();
        HashMap<String, Object> props = new HashMap<String, Object>();
        auth.getInternal().consume(token -> headers.put("X-Auth-Token", token.getToken()), pass -> {
            props.put("username", pass.getUsername());
            props.put("password", pass.getPassword());
            props.put("eauth", pass.getModule().getValue());
        });
        target.ifPresent(t -> props.putAll(t.getProps()));
        props.put("client", client.getValue());
        props.putAll(call.getPayload());
        props.putAll(custom);
        List list = Collections.singletonList(props);
        String payload = this.gson.toJson(list);
        URI endpoint = auth.getInternal().isRight() ? this.uri.resolve("run") : this.uri;
        return this.asyncHttpClient.post(endpoint, headers, payload, new JsonParser<R>(type));
    }
}

