/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.datatypes;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Batch {
    private String batch;
    private Optional<Double> delay;
    private Optional<Integer> presencePingTimeout;
    private Optional<Integer> presencePingGatherJobTimeout;

    private Batch(BatchBuilder builder) {
        this.batch = builder.batch;
        this.delay = builder.delay;
        this.presencePingTimeout = builder.presencePingTimeout;
        this.presencePingGatherJobTimeout = builder.presencePingGatherJobTimeout;
    }

    public String toString() {
        return this.batch;
    }

    public String getBatch() {
        return this.batch;
    }

    public Optional<Double> getDelay() {
        return this.delay;
    }

    public Optional<Integer> getPresencePingTimeout() {
        return this.presencePingTimeout;
    }

    public Optional<Integer> getPresencePingGatherJobTimeout() {
        return this.presencePingGatherJobTimeout;
    }

    public Map<String, Object> getParams() {
        HashMap<String, Object> customArgs = new HashMap<String, Object>();
        customArgs.put("batch", this.batch);
        this.delay.ifPresent(d -> customArgs.put("batch_delay", d));
        this.presencePingTimeout.ifPresent(d -> customArgs.put("batch_presence_ping_timeout", d));
        this.presencePingGatherJobTimeout.ifPresent(d -> customArgs.put("batch_presence_ping_gather_job_timeout", d));
        return customArgs;
    }

    public static Batch asPercent(int value) {
        return Batch.custom().withBatchAsPercent(value).build();
    }

    public static Batch asAmount(int value) {
        return Batch.custom().withBatchAsAmount(value).build();
    }

    public static BatchBuilder custom() {
        return new BatchBuilder();
    }

    public static class BatchBuilder {
        private String batch;
        private Optional<Double> delay = Optional.empty();
        private Optional<Integer> presencePingTimeout = Optional.empty();
        private Optional<Integer> presencePingGatherJobTimeout = Optional.empty();

        private BatchBuilder() {
        }

        public BatchBuilder withBatchAsAmount(int value) {
            if (value <= 0) {
                throw new IllegalArgumentException("Expected value greater than 0 to make a valid batch amount");
            }
            this.batch = Integer.toString(value);
            return this;
        }

        public BatchBuilder withBatchAsPercent(int value) {
            if (value <= 0 || value > 100) {
                throw new IllegalArgumentException("Expected value greater than 0 and less than or equal to 100 to make valid batch as a percent.");
            }
            this.batch = Integer.toString(value);
            return this;
        }

        public BatchBuilder withDelay(Double delayIn) {
            this.delay = Optional.of(delayIn);
            return this;
        }

        public BatchBuilder withPresencePingTimeout(Integer presencePingTimeoutIn) {
            this.presencePingTimeout = Optional.of(presencePingTimeoutIn);
            return this;
        }

        public BatchBuilder withPresencePingGatherJobTimeout(Integer presencePingGatherJobTimeoutIn) {
            this.presencePingGatherJobTimeout = Optional.of(presencePingGatherJobTimeoutIn);
            return this;
        }

        public Batch build() {
            return new Batch(this);
        }
    }
}

