/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.event;

import com.suse.salt.netapi.datatypes.Event;
import com.suse.salt.netapi.datatypes.Token;
import com.suse.salt.netapi.event.AbstractEventStream;
import com.suse.salt.netapi.event.EventListener;
import com.suse.salt.netapi.exception.MessageTooBigException;
import com.suse.salt.netapi.exception.SaltException;
import com.suse.salt.netapi.parser.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

@ClientEndpoint
public class WebSocketEventStream
extends AbstractEventStream {
    private final int defaultBufferSize = 1024;
    private final int maxMessageLength;
    private final StringBuilder messageBuffer = new StringBuilder(1024);
    private final WebSocketContainer websocketContainer = ContainerProvider.getWebSocketContainer();
    private Session session;

    public WebSocketEventStream(URI uri, Token token, long sessionIdleTimeout, long idleTimeout, int maxMsgSize, EventListener ... listeners) throws SaltException {
        this.maxMessageLength = maxMsgSize > 0 ? maxMsgSize : Integer.MAX_VALUE;
        Arrays.asList(listeners).forEach(this::addEventListener);
        this.initializeStream(uri.resolve("/"), token, sessionIdleTimeout, idleTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeStream(URI uri, Token token, long sessionIdleTimeout, long idleTimeout) throws SaltException {
        try {
            URI adjustedURI = new URI(uri.getScheme() == "https" ? "wss" : "ws", uri.getSchemeSpecificPart(), uri.getFragment()).resolve("ws/" + token.getToken());
            this.websocketContainer.setDefaultMaxSessionIdleTimeout(sessionIdleTimeout);
            WebSocketContainer webSocketContainer = this.websocketContainer;
            synchronized (webSocketContainer) {
                this.session = this.websocketContainer.connectToServer((Object)this, adjustedURI);
                this.session.setMaxIdleTimeout(idleTimeout);
            }
        }
        catch (IOException | URISyntaxException | DeploymentException e) {
            throw new SaltException(e);
        }
    }

    @Override
    public boolean isEventStreamClosed() {
        return this.session == null || !this.session.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "The listener has closed the event stream"));
    }

    private void close(CloseReason closeReason) throws IOException {
        if (!this.isEventStreamClosed()) {
            this.session.close(closeReason);
        }
    }

    @OnOpen
    public void onOpen(Session session, EndpointConfig config) throws IOException {
        this.session = session;
        session.getBasicRemote().sendText("websocket client ready");
    }

    @OnMessage
    public void onMessage(String partialMessage, boolean last) throws MessageTooBigException {
        if (partialMessage.length() > this.maxMessageLength - this.messageBuffer.length()) {
            throw new MessageTooBigException(this.maxMessageLength);
        }
        if (last) {
            String message;
            if (this.messageBuffer.length() == 0) {
                message = partialMessage;
            } else {
                this.messageBuffer.append(partialMessage);
                message = this.messageBuffer.toString();
                this.messageBuffer.setLength(1024);
                this.messageBuffer.trimToSize();
                this.messageBuffer.setLength(0);
            }
            if (!message.equals("server received message")) {
                Event event = JsonParser.EVENTS.parse(message.substring(6));
                this.notifyListeners(event);
            }
        } else {
            this.messageBuffer.append(partialMessage);
        }
    }

    @OnError
    public void onError(Throwable throwable) throws IOException {
        this.close(new CloseReason((CloseReason.CloseCode)(throwable instanceof MessageTooBigException ? CloseReason.CloseCodes.TOO_BIG : CloseReason.CloseCodes.CLOSED_ABNORMALLY), throwable.getMessage()));
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        this.session = session;
        this.clearListeners(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
    }
}

