/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.event;

import com.suse.salt.netapi.datatypes.Event;
import com.suse.salt.netapi.event.EventListener;
import com.suse.salt.netapi.event.EventStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractEventStream
implements EventStream {
    private final List<EventListener> listeners = new CopyOnWriteArrayList<EventListener>();

    @Override
    public void addEventListener(EventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeEventListener(EventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public int getListenerCount() {
        return this.listeners.size();
    }

    protected void notifyListeners(Event event) {
        for (EventListener listener : this.listeners) {
            listener.notify(event);
        }
    }

    protected void clearListeners(int code, String phrase) {
        this.listeners.forEach(listener -> listener.eventStreamClosed(code, phrase));
        this.listeners.clear();
    }
}

