/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.calls;

import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.calls.AbstractCall;
import com.suse.salt.netapi.calls.Client;
import com.suse.salt.netapi.calls.LocalAsyncResult;
import com.suse.salt.netapi.calls.RunnerAsyncResult;
import com.suse.salt.netapi.calls.RunnerCall;
import com.suse.salt.netapi.calls.SaltSSHConfig;
import com.suse.salt.netapi.calls.SaltSSHUtils;
import com.suse.salt.netapi.calls.runner.Jobs;
import com.suse.salt.netapi.client.SaltClient;
import com.suse.salt.netapi.datatypes.AuthMethod;
import com.suse.salt.netapi.datatypes.Batch;
import com.suse.salt.netapi.datatypes.Event;
import com.suse.salt.netapi.datatypes.target.SSHTarget;
import com.suse.salt.netapi.datatypes.target.Target;
import com.suse.salt.netapi.errors.GenericError;
import com.suse.salt.netapi.event.EventListener;
import com.suse.salt.netapi.event.EventStream;
import com.suse.salt.netapi.event.JobReturnEvent;
import com.suse.salt.netapi.event.RunnerReturnEvent;
import com.suse.salt.netapi.results.Result;
import com.suse.salt.netapi.results.Return;
import com.suse.salt.netapi.results.SSHResult;
import com.suse.salt.netapi.utils.ClientUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;

public class LocalCall<R>
extends AbstractCall<R> {
    private final Optional<List<?>> arg;
    private final Optional<Map<String, ?>> kwarg;
    private final Optional<?> metadata;
    private final Optional<Integer> timeout;
    private final Optional<Integer> gatherJobTimeout;

    public LocalCall(String functionName, Optional<List<?>> arg, Optional<Map<String, ?>> kwarg, TypeToken<R> returnType, Optional<?> metadata, Optional<Integer> timeout, Optional<Integer> gatherJobTimeout) {
        super(functionName, returnType);
        this.arg = arg;
        this.kwarg = kwarg;
        this.metadata = metadata;
        this.timeout = timeout;
        this.gatherJobTimeout = gatherJobTimeout;
    }

    public LocalCall(String functionName, Optional<List<?>> arg, Optional<Map<String, ?>> kwarg, TypeToken<R> returnType, Optional<Integer> timeout, Optional<Integer> gatherJobTimeout) {
        this(functionName, arg, kwarg, returnType, Optional.empty(), timeout, gatherJobTimeout);
    }

    public LocalCall(String functionName, Optional<List<?>> arg, Optional<Map<String, ?>> kwarg, TypeToken<R> returnType, Optional<?> metadata) {
        this(functionName, arg, kwarg, returnType, metadata, Optional.empty(), Optional.empty());
    }

    public LocalCall(String functionName, Optional<List<?>> arg, Optional<Map<String, ?>> kwarg, TypeToken<R> returnType) {
        this(functionName, arg, kwarg, returnType, Optional.empty());
    }

    public LocalCall<R> withMetadata(Object metadata) {
        return new LocalCall(this.getFunction(), this.arg, this.kwarg, this.getReturnType(), Optional.of(metadata), this.timeout, this.gatherJobTimeout);
    }

    public LocalCall<R> withoutMetadata() {
        return new LocalCall(this.getFunction(), this.arg, this.kwarg, this.getReturnType(), Optional.empty(), this.timeout, this.gatherJobTimeout);
    }

    public LocalCall<R> withTimeouts(Optional<Integer> timeout, Optional<Integer> gatherJobTimeout) {
        return new LocalCall(this.getFunction(), this.arg, this.kwarg, this.getReturnType(), this.metadata, timeout, gatherJobTimeout);
    }

    public LocalCall<R> withoutTimeouts() {
        return new LocalCall(this.getFunction(), this.arg, this.kwarg, this.getReturnType(), this.metadata, Optional.empty(), Optional.empty());
    }

    @Override
    public Map<String, Object> getPayload() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("fun", this.getFunction());
        this.arg.ifPresent(arg -> payload.put("arg", arg));
        this.kwarg.ifPresent(kwarg -> payload.put("kwarg", kwarg));
        this.metadata.ifPresent(m -> payload.put("metadata", m));
        this.timeout.ifPresent(timeout -> payload.put("timeout", timeout));
        this.gatherJobTimeout.ifPresent(gatherJobTimeout -> payload.put("gather_job_timeout", gatherJobTimeout));
        return payload;
    }

    public CompletionStage<LocalAsyncResult<R>> callAsync(SaltClient client, Target<?> target, AuthMethod auth) {
        return client.call(this, Client.LOCAL_ASYNC, Optional.of(target), Collections.emptyMap(), new TypeToken<Return<List<LocalAsyncResult<R>>>>(){}, auth).thenApply(wrapper -> {
            LocalAsyncResult result = (LocalAsyncResult)((List)wrapper.getResult()).get(0);
            result.setType(this.getReturnType());
            return result;
        });
    }

    public CompletionStage<Map<String, CompletionStage<Result<R>>>> callAsync(SaltClient client, Target<?> target, AuthMethod auth, EventStream events, CompletionStage<GenericError> cancel) {
        return this.callAsync(localCall -> localCall.callAsync(client, target, auth), runnerCall -> runnerCall.callAsync(client, auth), events, cancel);
    }

    public CompletionStage<Map<String, CompletionStage<Result<R>>>> callAsync(Function<LocalCall<R>, CompletionStage<LocalAsyncResult<R>>> localAsync, Function<RunnerCall<Map<String, R>>, CompletionStage<RunnerAsyncResult<Map<String, R>>>> runnerAsync, EventStream events, CompletionStage<GenericError> cancel) {
        return localAsync.apply(this).thenApply(lar -> {
            TypeToken returnTypeToken = this.getReturnType();
            ParameterizedType result = ClientUtils.parameterizedType(null, Result.class, new Type[]{returnTypeToken.getType()});
            TypeToken typeToken = TypeToken.get((Type)result);
            Map<String, CompletableFuture> futures = lar.getMinions().stream().collect(Collectors.toMap(mid -> mid, mid -> new CompletableFuture()));
            EventListener listener = new EventListener((LocalAsyncResult)lar, typeToken, futures){
                final /* synthetic */ LocalAsyncResult val$lar;
                final /* synthetic */ TypeToken val$typeToken;
                final /* synthetic */ Map val$futures;
                {
                    this.val$lar = localAsyncResult;
                    this.val$typeToken = typeToken;
                    this.val$futures = map;
                }

                @Override
                public void notify(Event event) {
                    Optional<JobReturnEvent> jobReturnEvent = JobReturnEvent.parse(event);
                    if (jobReturnEvent.isPresent()) {
                        jobReturnEvent.ifPresent(e -> LocalCall.onJobReturn(this.val$lar.getJid(), e, this.val$typeToken, this.val$futures));
                    } else {
                        RunnerReturnEvent.parse(event).ifPresent(e -> LocalCall.onRunnerReturn(this.val$lar.getJid(), e, this.val$typeToken, this.val$futures));
                    }
                }

                @Override
                public void eventStreamClosed(int code, String phrase) {
                    Result error = Result.error(new GenericError("EventStream closed with reason " + phrase));
                    this.val$futures.values().forEach(f -> f.complete(error));
                }
            };
            CompletableFuture<Void> allResolves = CompletableFuture.allOf((CompletableFuture[])futures.entrySet().stream().map(entry -> ((CompletableFuture)entry.getValue()).handle((v, e) -> 0)).toArray(CompletableFuture[]::new));
            allResolves.whenComplete((v, e) -> events.removeEventListener(listener));
            cancel.whenComplete((v, e) -> {
                if (v != null) {
                    Result error = Result.error(v);
                    futures.values().forEach(f -> f.complete(error));
                } else if (e != null) {
                    futures.values().forEach(f -> f.completeExceptionally((Throwable)e));
                }
            });
            events.addEventListener(listener);
            runnerAsync.apply(Jobs.lookupJid(lar));
            return futures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (CompletionStage)e.getValue()));
        });
    }

    public CompletionStage<Map<String, Result<R>>> callSync(SaltClient client, Target<?> target, AuthMethod auth) {
        return this.callSyncHelperNonBlock(client, target, auth, Optional.empty()).thenApply(r -> (Map)r.get(0));
    }

    public CompletionStage<List<Map<String, Result<R>>>> callSync(SaltClient client, Target<?> target, AuthMethod auth, Batch batch) {
        return this.callSyncHelperNonBlock(client, target, auth, Optional.of(batch));
    }

    private CompletionStage<List<Map<String, Result<R>>>> callSyncHelperNonBlock(SaltClient client, Target<?> target, AuthMethod auth, Optional<Batch> batch) {
        HashMap<String, Object> customArgs = new HashMap<String, Object>();
        customArgs.putAll(this.getPayload());
        customArgs.putAll(target.getProps());
        batch.ifPresent(v -> customArgs.put("batch", v.toString()));
        Client clientType = batch.isPresent() ? Client.LOCAL_BATCH : Client.LOCAL;
        ParameterizedType xor = ClientUtils.parameterizedType(null, Result.class, new Type[]{this.getReturnType().getType()});
        ParameterizedType map = ClientUtils.parameterizedType(null, Map.class, new Type[]{String.class, xor});
        ParameterizedType listType = ClientUtils.parameterizedType(null, List.class, new Type[]{map});
        ParameterizedType wrapperType = ClientUtils.parameterizedType(null, Return.class, new Type[]{listType});
        TypeToken typeToken = TypeToken.get((Type)wrapperType);
        return client.call(this, clientType, Optional.of(target), customArgs, typeToken, auth).thenApply(Return::getResult);
    }

    public CompletionStage<Map<String, Result<SSHResult<R>>>> callSyncSSH(SaltClient client, SSHTarget<?> target, SaltSSHConfig cfg, AuthMethod auth) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.putAll(this.getPayload());
        args.putAll(target.getProps());
        SaltSSHUtils.mapConfigPropsToArgs(cfg, args);
        ParameterizedType xor = ClientUtils.parameterizedType(null, Result.class, new Type[]{ClientUtils.parameterizedType(null, SSHResult.class, new Type[]{this.getReturnType().getType()})});
        ParameterizedType map = ClientUtils.parameterizedType(null, Map.class, new Type[]{String.class, xor});
        ParameterizedType listType = ClientUtils.parameterizedType(null, List.class, new Type[]{map});
        ParameterizedType wrapperType = ClientUtils.parameterizedType(null, Return.class, new Type[]{listType});
        return client.call(this, Client.SSH, Optional.of(target), args, TypeToken.get((Type)wrapperType), auth).thenApply(wrapper -> (Map)((List)wrapper.getResult()).get(0));
    }

    private static <R> void onRunnerReturn(String jid, RunnerReturnEvent rre, TypeToken<Result<R>> tt, Map<String, CompletableFuture<Result<R>>> targets) {
        Jobs.Info result;
        RunnerReturnEvent.Data data = rre.getData();
        if (data.getFun().contentEquals("runner.jobs.list_job") && (result = data.getResult(Jobs.Info.class)).getJid().equals(jid)) {
            targets.forEach((mid, f) -> result.getResult((String)mid, tt).ifPresent(f::complete));
        }
    }

    private static <R> void onJobReturn(String jid, JobReturnEvent jre, TypeToken<Result<R>> tt, Map<String, CompletableFuture<Result<R>>> targets) {
        CompletableFuture<Result<R>> f;
        if (jre.getJobId().contentEquals(jid) && (f = targets.get(jre.getMinionId())) != null) {
            f.complete(jre.getData().getResult(tt));
        }
    }
}

