/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.results;

import com.suse.salt.netapi.errors.SaltError;
import com.suse.salt.netapi.utils.Xor;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class Result<R> {
    private final Xor<SaltError, R> xor;

    public static <T> Result<T> success(T r) {
        return new Result<T>(Xor.right(r));
    }

    public static <T> Result<T> error(SaltError e) {
        return new Result(Xor.left(e));
    }

    public Result(Xor<SaltError, R> xor) {
        this.xor = xor;
    }

    public Optional<SaltError> error() {
        return this.xor.left();
    }

    public Optional<R> result() {
        return this.xor.right();
    }

    public <T> T fold(Function<? super SaltError, ? extends T> mapError, Function<? super R, ? extends T> mapResult) {
        return this.xor.fold(mapError, mapResult);
    }

    public void consume(Consumer<? super SaltError> consumerError, Consumer<? super R> consumerResult) {
        this.xor.consume(consumerError, consumerResult);
    }

    public <T> Result<T> map(Function<? super R, ? extends T> mapper) {
        return new Result<T>(this.xor.map(mapper));
    }

    public <T> Result<T> flatMap(Function<? super R, Result<T>> mapper) {
        return this.xor.fold((? super L e) -> new Result(Xor.left(e)), mapper);
    }

    public Xor<SaltError, R> toXor() {
        return this.xor;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Result other = (Result)obj;
        return this.xor.equals(other.xor);
    }

    public String toString() {
        return this.xor.fold((? super L error) -> "Error(" + error + ")", (? super R result) -> "Result(" + result + ")");
    }
}

