/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.calls;

import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.AuthModule;
import com.suse.salt.netapi.calls.Call;
import com.suse.salt.netapi.calls.Client;
import com.suse.salt.netapi.calls.RunnerAsyncResult;
import com.suse.salt.netapi.client.SaltClient;
import com.suse.salt.netapi.exception.SaltException;
import com.suse.salt.netapi.results.Return;
import com.suse.salt.netapi.utils.ClientUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RunnerCall<R>
implements Call<R> {
    private final String functionName;
    private final Optional<Map<String, ?>> kwargs;
    private final TypeToken<R> returnType;

    public RunnerCall(String functionName, Optional<Map<String, ?>> kwargs, TypeToken<R> returnType) {
        this.functionName = functionName;
        this.kwargs = kwargs;
        this.returnType = returnType;
    }

    public TypeToken<R> getReturnType() {
        return this.returnType;
    }

    @Override
    public Map<String, Object> getPayload() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("fun", this.functionName);
        this.kwargs.ifPresent(kwargs -> payload.put("kwargs", kwargs));
        return payload;
    }

    public RunnerAsyncResult<R> callAsync(SaltClient client) throws SaltException {
        Return wrapper = (Return)client.call(this, Client.RUNNER_ASYNC, "/", new TypeToken<Return<List<RunnerAsyncResult<R>>>>(){});
        RunnerAsyncResult result = (RunnerAsyncResult)((List)wrapper.getResult()).get(0);
        result.setType(this.getReturnType());
        return result;
    }

    public RunnerAsyncResult<R> callAsync(SaltClient client, String username, String password, AuthModule authModule) throws SaltException {
        HashMap<String, Object> customArgs = new HashMap<String, Object>();
        customArgs.putAll(this.getPayload());
        customArgs.put("username", username);
        customArgs.put("password", password);
        customArgs.put("eauth", authModule.getValue());
        Return wrapper = (Return)client.call(this, Client.RUNNER_ASYNC, "/run", Optional.of(customArgs), new TypeToken<Return<List<RunnerAsyncResult<R>>>>(){});
        RunnerAsyncResult result = (RunnerAsyncResult)((List)wrapper.getResult()).get(0);
        result.setType(this.getReturnType());
        return result;
    }

    public R callSync(SaltClient client, String username, String password, AuthModule authModule) throws SaltException {
        HashMap<String, Object> customArgs = new HashMap<String, Object>();
        customArgs.putAll(this.getPayload());
        customArgs.put("username", username);
        customArgs.put("password", password);
        customArgs.put("eauth", authModule.getValue());
        ParameterizedType listType = ClientUtils.parameterizedType(null, List.class, new Type[]{this.getReturnType().getType()});
        ParameterizedType wrapperType = ClientUtils.parameterizedType(null, Return.class, new Type[]{listType});
        Return wrapper = (Return)client.call(this, Client.RUNNER, "/run", Optional.of(customArgs), TypeToken.get((Type)wrapperType));
        return (R)((List)wrapper.getResult()).get(0);
    }

    public R callSync(SaltClient client) throws SaltException {
        ParameterizedType listType = ClientUtils.parameterizedType(null, List.class, new Type[]{this.getReturnType().getType()});
        ParameterizedType wrapperType = ClientUtils.parameterizedType(null, Return.class, new Type[]{listType});
        Return wrapper = (Return)client.call(this, Client.RUNNER, "/", TypeToken.get((Type)wrapperType));
        return (R)((List)wrapper.getResult()).get(0);
    }
}

