/*
 * Decompiled with CFR 0.152.
 */
package com.surveymonkey.surveymonkeyandroidsdk.utils;

public class SMError
extends Error {
    public int errorCode;
    public String description;
    public String domain;
    private Exception exception;

    public SMError(String string2, ErrorType errorType, Exception exception, String string3) {
        this.domain = string2;
        this.errorCode = errorType.getValue();
        this.description = string3;
        this.exception = exception;
    }

    public static SMError sdkClientErrorFromCode(ErrorType errorType, Exception exception) {
        String string2 = "";
        if (a.a[errorType.ordinal()] == 1) {
            string2 = "The user canceled out of the survey.";
        }
        return new SMError("SurveyMonkeySDK_ClientError", errorType, exception, string2);
    }

    public static SMError sdkServerErrorFromCode(ErrorType errorType, Exception exception) {
        String string2 = "";
        switch (a.a[errorType.ordinal()]) {
            default: {
                break;
            }
            case 11: {
                string2 = "Internal server error.";
                break;
            }
            case 10: {
                string2 = "Custom link no longer exists.";
                break;
            }
            case 9: {
                string2 = "The user canceled out of the survey.";
                break;
            }
            case 8: {
                string2 = "Response limit exceeded for your plan. Upgrade to access more responses through the SDK.";
                break;
            }
            case 7: {
                string2 = "This survey has been deleted.";
                break;
            }
            case 6: {
                string2 = "There was a problem retrieving the user's response to this survey.";
                break;
            }
            case 5: {
                string2 = "The collector for this survey has been closed.";
                break;
            }
            case 4: {
                string2 = "There was an error parsing the response from the server.";
                break;
            }
            case 3: {
                string2 = "There was an error connecting to the server.";
                break;
            }
            case 2: {
                string2 = "Could not retrieve your respondent. Be sure you're using an SDK Collector.";
            }
        }
        return new SMError("SurveyMonkeySDK_ServerError", errorType, exception, string2);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDescription() {
        if (this.exception == null) {
            return "Domain: " + this.domain + " Code: " + this.errorCode + " SMDescription: " + this.description;
        }
        return "Domain: " + this.domain + " Code: " + this.errorCode + " Description: " + this.exception.getLocalizedMessage() + " SMDescription: " + this.description;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Exception getException() {
        return this.exception;
    }

    public static final class ErrorType
    extends Enum<ErrorType> {
        public static final /* enum */ ErrorType ERROR_CODE_TOKEN;
        public static final /* enum */ ErrorType ERROR_CODE_BAD_CONNECTION;
        public static final /* enum */ ErrorType ERROR_CODE_RESPONSE_PARSE_FAILED;
        public static final /* enum */ ErrorType ERROR_CODE_COLLECTOR_CLOSED;
        public static final /* enum */ ErrorType ERROR_CODE_RETRIEVING_RESPONSE;
        public static final /* enum */ ErrorType ERROR_CODE_SURVEY_DELETED;
        public static final /* enum */ ErrorType ERROR_CODE_RESPONSE_LIMIT_HIT;
        public static final /* enum */ ErrorType ERROR_CODE_RESPONDENT_EXITED_SURVEY;
        public static final /* enum */ ErrorType ERROR_CODE_NONEXISTENT_LINK;
        public static final /* enum */ ErrorType ERROR_CODE_INTERNAL_SERVER_ERROR;
        public static final /* enum */ ErrorType ERROR_CODE_USER_CANCELED;
        private static final /* synthetic */ ErrorType[] $VALUES;
        public final int mValue;

        public static ErrorType[] values() {
            return (ErrorType[])$VALUES.clone();
        }

        public static ErrorType valueOf(String string2) {
            return Enum.valueOf(ErrorType.class, string2);
        }

        public ErrorType(int n2) {
            this.mValue = n2;
        }

        static {
            ErrorType errorType;
            ErrorType errorType2;
            ErrorType errorType3;
            ErrorType errorType4;
            ErrorType errorType5;
            ErrorType errorType6;
            ErrorType errorType7;
            ErrorType errorType8;
            ErrorType errorType9;
            ErrorType errorType10;
            ErrorType errorType11;
            ErrorType errorType12 = errorType11;
            ERROR_CODE_TOKEN = new ErrorType(1);
            ErrorType errorType13 = errorType10;
            ERROR_CODE_BAD_CONNECTION = new ErrorType(2);
            ErrorType errorType14 = errorType9;
            ERROR_CODE_RESPONSE_PARSE_FAILED = new ErrorType(3);
            ErrorType errorType15 = errorType8;
            ERROR_CODE_COLLECTOR_CLOSED = new ErrorType(4);
            ErrorType errorType16 = errorType7;
            ERROR_CODE_RETRIEVING_RESPONSE = new ErrorType(5);
            ErrorType errorType17 = errorType6;
            ERROR_CODE_SURVEY_DELETED = new ErrorType(6);
            ErrorType errorType18 = errorType5;
            ERROR_CODE_RESPONSE_LIMIT_HIT = new ErrorType(7);
            ErrorType errorType19 = errorType4;
            ERROR_CODE_RESPONDENT_EXITED_SURVEY = new ErrorType(8);
            ErrorType errorType20 = errorType3;
            ERROR_CODE_NONEXISTENT_LINK = new ErrorType(9);
            ErrorType errorType21 = errorType2;
            ERROR_CODE_INTERNAL_SERVER_ERROR = new ErrorType(10);
            ErrorType errorType22 = errorType;
            ERROR_CODE_USER_CANCELED = new ErrorType(1);
            $VALUES = new ErrorType[]{errorType12, errorType13, errorType14, errorType15, errorType16, errorType17, errorType18, errorType19, errorType20, errorType21, errorType22};
        }

        public int getValue() {
            return this.mValue;
        }
    }

    public static class ErrorDescription {
        public static final String ERROR_CODE_TOKEN_DESCRIPTION = "Could not retrieve your respondent. Be sure you're using an SDK Collector.";
        public static final String ERROR_CODE_BAD_CONNECTION_DESCRIPTION = "There was an error connecting to the server.";
        public static final String ERROR_CODE_RESPONSE_PARSE_FAILED_DESCRIPTION = "There was an error parsing the response from the server.";
        public static final String ERROR_CODE_COLLECTOR_CLOSED_DESCRIPTION = "The collector for this survey has been closed.";
        public static final String ERROR_CODE_RETRIEVING_RESPONSE_DESCRIPTION = "There was a problem retrieving the user's response to this survey.";
        public static final String ERROR_CODE_SURVEY_DELETED_DESCRIPTION = "This survey has been deleted.";
        public static final String ERROR_CODE_RESPONSE_LIMIT_HIT_DESCRIPTION = "Response limit exceeded for your plan. Upgrade to access more responses through the SDK.";
        public static final String ERROR_CODE_RESPONDENT_EXITED_SURVEY_DESCRIPTION = "The user canceled out of the survey.";
        public static final String ERROR_CODE_NONEXISTENT_LINK_DESCRIPTION = "Custom link no longer exists.";
        public static final String ERROR_CODE_INTERNAL_SERVER_ERROR_DESCRIPTION = "Internal server error.";
    }

    public static class Domain {
        public static final String SDK_SERVER_DOMAIN = "SurveyMonkeySDK_ServerError";
        public static final String SDK_CLIENT_DOMAIN = "SurveyMonkeySDK_ClientError";
    }
}

