/*
 * Decompiled with CFR 0.152.
 */
package com.surveymonkey.surveymonkeyandroidsdk.model;

import com.surveymonkey.surveymonkeyandroidsdk.model.SMQuestionResponse;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SMRespondent {
    private static final String RESPONDENT_ID = "respondent_id";
    private static final String COMPLETION_STATUS = "completion_status";
    private static final String DATE_START = "date_start";
    private static final String DATE_MODIFIED = "date_modified";
    private static final String RESPONSES = "responses";
    private static final String[] SM_COMPLETION_STATUSES = new String[]{"partially", "completed"};
    private static final String PAPI_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private SMCompletionStatus mCompletionStatus;
    private Calendar mDateModified;
    private Calendar mDateStarted;
    private String mRespondentID;
    private ArrayList<SMQuestionResponse> mQuestionResponses;

    public SMRespondent(JSONObject object) {
        ArrayList arrayList;
        JSONObject jSONObject = object;
        SMRespondent sMRespondent = this;
        sMRespondent.mRespondentID = object.getString(RESPONDENT_ID);
        sMRespondent.mCompletionStatus = SMCompletionStatus.values()[Arrays.asList(SM_COMPLETION_STATUSES).indexOf(object.getString(COMPLETION_STATUS))];
        this.mDateStarted = this.a(object.getString(DATE_START));
        this.mDateModified = this.a(object.getString(DATE_MODIFIED));
        object = arrayList;
        arrayList = new ArrayList();
        JSONArray jSONArray = jSONObject.getJSONArray(RESPONSES);
        int n = 0;
        while (true) {
            if (n >= jSONArray.length()) break;
            ((ArrayList)object).add(new SMQuestionResponse(jSONArray.getJSONObject(n)));
            ++n;
        }
        try {
            this.mQuestionResponses = object;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public ArrayList getQuestionResponses() {
        return this.mQuestionResponses;
    }

    public SMCompletionStatus getCompletionStatus() {
        return this.mCompletionStatus;
    }

    public Calendar getDateModified() {
        return this.mDateModified;
    }

    public Calendar getDateStarted() {
        return this.mDateStarted;
    }

    public String getRespondentID() {
        return this.mRespondentID;
    }

    public String getDescription() {
        int n = 0;
        ArrayList<SMQuestionResponse> arrayList = this.mQuestionResponses;
        if (arrayList != null) {
            n = arrayList.size();
        }
        return "<SMRespondent: " + this + "; respondentID='" + this.mRespondentID + "'; " + n + " questionResponses>";
    }

    public final Calendar a(String object) {
        Object object2 = null;
        if (object != null && !((String)object).equals("")) {
            GregorianCalendar gregorianCalendar;
            SimpleDateFormat simpleDateFormat;
            String string2;
            try {
                string2 = object;
                simpleDateFormat = new SimpleDateFormat(PAPI_DATE_FORMAT);
            }
            catch (ParseException parseException) {}
            int n = ((String)object).length();
            object = simpleDateFormat.parse(string2.substring(0, n - 2));
            GregorianCalendar gregorianCalendar2 = gregorianCalendar;
            Object object3 = object;
            gregorianCalendar2();
            try {
                gregorianCalendar.setTime((Date)object3);
                object2 = gregorianCalendar2;
            }
            catch (ParseException parseException) {
                object2 = gregorianCalendar2;
            }
        }
        return object2;
    }

    public static final class SMCompletionStatus
    extends Enum<SMCompletionStatus> {
        public static final /* enum */ SMCompletionStatus SMCompletionStatusPartiallyComplete;
        public static final /* enum */ SMCompletionStatus SMCompletionStatusComplete;
        private static final /* synthetic */ SMCompletionStatus[] $VALUES;
        public final int mValue;

        public static SMCompletionStatus[] values() {
            return (SMCompletionStatus[])$VALUES.clone();
        }

        public static SMCompletionStatus valueOf(String string2) {
            return Enum.valueOf(SMCompletionStatus.class, string2);
        }

        public SMCompletionStatus(int n2) {
            this.mValue = n2;
        }

        static {
            SMCompletionStatus sMCompletionStatus;
            SMCompletionStatus sMCompletionStatus2;
            SMCompletionStatus sMCompletionStatus3 = sMCompletionStatus2;
            SMCompletionStatusPartiallyComplete = new SMCompletionStatus(0);
            SMCompletionStatus sMCompletionStatus4 = sMCompletionStatus;
            SMCompletionStatusComplete = new SMCompletionStatus(1);
            $VALUES = new SMCompletionStatus[]{sMCompletionStatus3, sMCompletionStatus4};
        }

        public int getValue() {
            return this.mValue;
        }
    }
}

