/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.util;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;

public class DisplayUtil {
    public static DisplayMetrics getMetrics(Context mContext) {
        DisplayMetrics metric = new DisplayMetrics();
        ((Activity)mContext).getWindowManager().getDefaultDisplay().getMetrics(metric);
        return metric;
    }

    public static int getScreenWidth(Context mContext) {
        return DisplayUtil.getMetrics((Context)mContext).widthPixels;
    }

    public static int getScreenHeight(Context mContext) {
        return DisplayUtil.getMetrics((Context)mContext).heightPixels;
    }

    public static boolean inRangeOfView(View view, MotionEvent ev) {
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        return !(ev.getX() < (float)location[0] || ev.getX() > (float)(location[0] + view.getWidth()) || ev.getY() < (float)location[1]) && !(ev.getY() > (float)(location[1] + view.getHeight()));
    }

    public static boolean newInRangeOfView(View view, MotionEvent ev) {
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        return !(ev.getRawX() < (float)location[0] || ev.getRawX() > (float)(location[0] + view.getWidth()) || ev.getRawY() < (float)location[1]) && !(ev.getRawY() > (float)(location[1] + view.getHeight()));
    }

    public static void calcDPI(Context mContext) {
        DisplayMetrics metric = DisplayUtil.getMetrics(mContext);
        int width = metric.widthPixels;
        int height = metric.heightPixels;
        float density = metric.density;
        int densityDpi = metric.densityDpi;
    }

    public static int px2dip(float pxValue, Context mContext) {
        float scale = DisplayUtil.getMetrics((Context)mContext).density;
        int dip = (int)(pxValue / scale + 0.5f);
        return dip;
    }

    public static int dip2px(float dipValue, Context mContext) {
        float scale = DisplayUtil.getMetrics((Context)mContext).density;
        int px = (int)(dipValue * scale + 0.5f);
        return px;
    }

    public static int px2sp(float pxValue, Context mContext) {
        float fontScale = DisplayUtil.getMetrics((Context)mContext).scaledDensity;
        int sp = (int)(pxValue / fontScale + 0.5f);
        return sp;
    }

    public static int sp2px(float spValue, Context mContext) {
        float fontScale = DisplayUtil.getMetrics((Context)mContext).scaledDensity;
        int px = (int)(spValue * fontScale + 0.5f);
        return px;
    }
}

