/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.base.fragment;

import com.app.annotation.Presenter;
import com.supcon.common.com_router.router.PresenterRouter;
import com.supcon.common.view.base.fragment.BaseFragment;
import com.supcon.common.view.base.presenter.BasePresenter;
import com.supcon.common.view.contract.IBaseView;
import com.supcon.common.view.util.InstanceUtil;
import com.supcon.common.view.util.LogUtil;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public abstract class BasePresenterFragment
extends BaseFragment {
    protected PresenterRouter presenterRouter;
    private List<BasePresenter> mPresenters = new ArrayList<BasePresenter>();

    @Override
    protected void onInit() {
        super.onInit();
        this.initPresenter();
    }

    protected void initPresenter() {
        Annotation[] annotations;
        this.presenterRouter = new PresenterRouter();
        for (Annotation annotation : annotations = this.getClass().getAnnotations()) {
            Class[] presenters;
            if (!(annotation instanceof Presenter)) continue;
            for (Class presenter : presenters = ((Presenter)annotation).value()) {
                if (!(this instanceof IBaseView)) continue;
                BasePresenter basePresenter = (BasePresenter)InstanceUtil.getInstance(presenter);
                this.presenterRouter.register((Object)basePresenter);
                this.addPresenter(basePresenter);
                LogUtil.d("presenter " + presenter.getName() + " added!");
            }
        }
    }

    private void addPresenter(BasePresenter basePresenter) {
        basePresenter.attachView(this);
        this.mPresenters.add(basePresenter);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        for (BasePresenter presenter : this.mPresenters) {
            if (presenter == null) continue;
            presenter.detachView();
        }
    }
}

