/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.base.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.supcon.common.view.base.adapter.BaseRecyclerViewAdapter;
import com.supcon.common.view.base.adapter.IListAdapter;
import com.supcon.common.view.base.adapter.viewholder.BaseRecyclerViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseListDataRecyclerViewAdapter<T>
extends BaseRecyclerViewAdapter<T>
implements IListAdapter<T> {
    protected List<T> list;
    protected boolean isEnableLoadMore = false;
    protected BaseRecyclerViewHolder<T> moreViewHolder;

    public BaseListDataRecyclerViewAdapter(Context context) {
        super(context);
    }

    public BaseListDataRecyclerViewAdapter(Context context, List<T> list) {
        super(context);
        this.list = list;
    }

    public void setLoadMoreView(View moreView) {
        this.isEnableLoadMore = moreView != null;
        this.moreViewHolder = moreView != null ? new BaseRecyclerViewHolder<T>(moreView){

            @Override
            protected int layoutId() {
                return 0;
            }

            @Override
            protected void update(T data) {
                this.itemView.callOnClick();
            }
        } : null;
        if (this.getListSize() > 0) {
            this.notifyDataSetChanged();
        }
    }

    public int getItemCount() {
        int count = this.getListSize();
        if (this.isEnableLoadMore && count > 0) {
            ++count;
        }
        return count;
    }

    protected int getListSize() {
        return this.list != null ? this.list.size() : 0;
    }

    @Override
    public void setList(List<T> list) {
        this.list = list;
    }

    @Override
    public T getItem(int i) {
        if (this.list != null && i >= 0 && i < this.list.size()) {
            return this.list.get(i);
        }
        return null;
    }

    public long getItemId(int i) {
        return 0L;
    }

    @Override
    public List<T> getList() {
        return this.list;
    }

    @Override
    public void addData(T t) {
        if (this.list == null) {
            this.list = new ArrayList<T>();
        }
        this.list.add(t);
    }

    @Override
    public void addList(List<T> list) {
        if (this.list == null) {
            this.list = list;
        } else if (list != null) {
            this.list.addAll(list);
        }
    }

    @Override
    public void remove(int index) {
        if (this.list != null && index >= 0 && this.list.size() > index) {
            this.list.remove(index);
        }
    }

    @Override
    public void remove(T t) {
        for (int i = 0; this.list != null && i < this.list.size(); ++i) {
            if (!this.compareEqual(this.list.get(i), t)) continue;
            this.list.remove(i);
            break;
        }
    }

    @Override
    public void clear() {
        if (this.list != null) {
            this.list.clear();
        }
    }

    protected boolean compareEqual(T t, T t1) {
        return t == t1;
    }

    @Override
    public void onBindViewHolder(BaseRecyclerViewHolder<T> holder, int position) {
        if (position == this.getListSize()) {
            // empty if block
        }
        super.onBindViewHolder(holder, position);
    }

    public int getItemViewType(int position) {
        if (position == this.getListSize()) {
            return -2;
        }
        return this.getItemViewType(position, this.list.get(position));
    }

    @Override
    public BaseRecyclerViewHolder<T> onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == -2) {
            return this.moreViewHolder;
        }
        return super.onCreateViewHolder(parent, viewType);
    }

    public int getItemViewType(int position, T t) {
        return super.getItemViewType(position);
    }
}

