package com.supcon.common.view.view.picker;

import android.app.Activity;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.supcon.common.view.view.picker.framework.ConfirmPopup;
import com.supcon.common.view.view.picker.widget.WheelView;

/**
 * 滑轮选择器
 */
@SuppressWarnings("WeakerAccess")
public abstract class WheelPicker extends ConfirmPopup<View> {
    /**
     * The Line space multiplier.
     */
    protected float lineSpaceMultiplier = WheelView.LINE_SPACE_MULTIPLIER;
    /**
     * The Text padding.
     */
    protected int textPadding = WheelView.TEXT_PADDING;
    /**
     * The Text size.
     */
    protected int textSize = WheelView.TEXT_SIZE;
    /**
     * The Typeface.
     */
    protected Typeface typeface = Typeface.DEFAULT;
    /**
     * The Text color normal.
     */
    protected int textColorNormal = WheelView.TEXT_COLOR_NORMAL;
    /**
     * The Text color focus.
     */
    protected int textColorFocus = WheelView.TEXT_COLOR_FOCUS;
    /**
     * The Label text color.
     */
    protected int labelTextColor = WheelView.TEXT_COLOR_FOCUS;
    /**
     * The Offset.
     */
    protected int offset = WheelView.ITEM_OFF_SET;
    /**
     * The Cycle disable.
     */
    protected boolean cycleDisable = true;
    /**
     * The Use weight.
     */
    protected boolean useWeight = true;
    /**
     * The Text size auto fit.
     */
    protected boolean textSizeAutoFit = true;
    /**
     * The Divider config.
     */
    protected WheelView.DividerConfig dividerConfig = new WheelView.DividerConfig();

    /**
     * Instantiates a new Wheel picker.
     *
     * @param activity the activity
     */
    public WheelPicker(Activity activity) {
        super(activity);
    }

    /**
     * 可用于设置每项的高度，范围为2-4
     *
     * @param multiplier the multiplier
     */
    public final void setLineSpaceMultiplier(@FloatRange(from = 2, to = 4) float multiplier) {
        lineSpaceMultiplier = multiplier;
    }

    /**
     * Use {@link #setTextPadding(int)} instead
     *
     * @param textPadding the text padding
     */
    @Deprecated
    public void setPadding(int textPadding) {
        this.textPadding = textPadding;
    }

    /**
     * 可用于设置每项的宽度，单位为dp
     *
     * @param textPadding the text padding
     */
    public void setTextPadding(int textPadding) {
        this.textPadding = textPadding;
    }

    /**
     * 设置文字大小
     *
     * @param textSize the text size
     */
    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    /**
     * 设置文字颜色
     *
     * @param textColorFocus  the text color focus
     * @param textColorNormal the text color normal
     */
    public void setTextColor(@ColorInt int textColorFocus, @ColorInt int textColorNormal) {
        this.textColorFocus = textColorFocus;
        this.textColorNormal = textColorNormal;
    }

    /**
     * 设置文字颜色
     *
     * @param textColor the text color
     */
    public void setTextColor(@ColorInt int textColor) {
        this.textColorFocus = textColor;
    }

    /**
     * Sets label text color.
     *
     * @param labelTextColor the label text color
     */
    public void setLabelTextColor(int labelTextColor) {
        this.labelTextColor = labelTextColor;
    }

    /**
     * 设置分隔阴影是否可见
     *
     * @param shadowVisible the shadow visible
     */
    public void setShadowVisible(boolean shadowVisible) {
        if (null == dividerConfig) {
            dividerConfig = new WheelView.DividerConfig();
        }
        dividerConfig.setShadowVisible(shadowVisible);
    }

    /**
     * 设置分隔阴影颜色及透明度
     *
     * @param color the color
     */
    public void setShadowColor(@ColorInt int color) {
        setShadowColor(color, 100);
    }

    /**
     * 设置分隔阴影颜色及透明度
     *
     * @param color the color
     * @param alpha the alpha
     */
    public void setShadowColor(@ColorInt int color, @IntRange(from = 1, to = 255) int alpha) {
        if (null == dividerConfig) {
            dividerConfig = new WheelView.DividerConfig();
        }
        dividerConfig.setShadowColor(color);
        dividerConfig.setShadowAlpha(alpha);
    }

    /**
     * 设置分隔线是否可见
     *
     * @param visible the visible
     */
    public void setDividerVisible(boolean visible) {
        if (null == dividerConfig) {
            dividerConfig = new WheelView.DividerConfig();
        }
        dividerConfig.setVisible(visible);
    }

    /**
     * Sets line visible.
     *
     * @param visible the visible
     * @deprecated use {@link #setDividerVisible(boolean)} instead
     */
    @Deprecated
    public void setLineVisible(boolean visible) {
        setDividerVisible(visible);
    }

    /**
     * Sets line color.
     *
     * @param color the color
     * @deprecated use {@link #setDividerColor(int)} instead
     */
    @Deprecated
    public void setLineColor(@ColorInt int color) {
        setDividerColor(color);
    }

    /**
     * 设置分隔线颜色
     *
     * @param lineColor the line color
     */
    public void setDividerColor(@ColorInt int lineColor) {
        if (null == dividerConfig) {
            dividerConfig = new WheelView.DividerConfig();
        }
        dividerConfig.setVisible(true);
        dividerConfig.setColor(lineColor);
    }

    /**
     * 设置分隔线长度比例
     *
     * @param ratio the ratio
     */
    public void setDividerRatio(float ratio) {
        if (null == dividerConfig) {
            dividerConfig = new WheelView.DividerConfig();
        }
        dividerConfig.setRatio(ratio);
    }

    /**
     * 设置分隔线配置项，设置null将隐藏分割线及阴影
     *
     * @param config the config
     */
    public void setDividerConfig(@Nullable WheelView.DividerConfig config) {
        if (null == config) {
            dividerConfig = new WheelView.DividerConfig();
            dividerConfig.setVisible(false);
            dividerConfig.setShadowVisible(false);
        } else {
            dividerConfig = config;
        }
    }

    /**
     * Sets line config.
     *
     * @param config the config
     * @deprecated use {@link #setDividerConfig(WheelView.DividerConfig)} instead
     */
    @Deprecated
    public void setLineConfig(WheelView.DividerConfig config) {
        setDividerConfig(config);
    }

    /**
     * 设置选项偏移量，可用来要设置显示的条目数，范围为1-5。
     * 1显示3条、2显示5条、3显示7条……
     *
     * @param offset the offset
     */
    public void setOffset(@IntRange(from = 1, to = 5) int offset) {
        this.offset = offset;
    }

    /**
     * 设置是否禁用循环
     *
     * @param cycleDisable the cycle disable
     */
    public void setCycleDisable(boolean cycleDisable) {
        this.cycleDisable = cycleDisable;
    }

    /**
     * 是否使用比重来平分布局
     *
     * @param useWeight the use weight
     */
    public void setUseWeight(boolean useWeight) {
        this.useWeight = useWeight;
    }

    /**
     * 条目内容过长时是否自动减少字号来适配
     *
     * @param textSizeAutoFit the text size auto fit
     */
    public void setTextSizeAutoFit(boolean textSizeAutoFit) {
        this.textSizeAutoFit = textSizeAutoFit;
    }

    /**
     * 得到选择器视图，可内嵌到其他视图容器
     */
    @Override
    public View getContentView() {
        if (centerView == null) {
            centerView = makeCenterView();
        }
        return centerView;
    }

    /**
     * Create wheel view wheel view.
     *
     * @return the wheel view
     */
    protected WheelView createWheelView() {
        WheelView wheelView = new WheelView(activity);
        wheelView.setLineSpaceMultiplier(lineSpaceMultiplier);
        wheelView.setTextPadding(textPadding);
        wheelView.setTextSize(textSize);
        wheelView.setTypeface(typeface);
        wheelView.setTextColor(textColorNormal, textColorFocus);
        wheelView.setDividerConfig(dividerConfig);
        wheelView.setOffset(offset);
        wheelView.setCycleDisable(cycleDisable);
        wheelView.setUseWeight(useWeight);
        wheelView.setTextSizeAutoFit(textSizeAutoFit);
        return wheelView;
    }

    /**
     * Create label view text view.
     *
     * @return the text view
     */
    protected TextView createLabelView() {
        TextView labelView = new TextView(activity);
        labelView.setLayoutParams(new ViewGroup.LayoutParams(WRAP_CONTENT, WRAP_CONTENT));
        labelView.setTextColor(labelTextColor);
        labelView.setTextSize(textSize);
        return labelView;
    }

}
