package com.supcon.common.view.view.picker;

import android.app.Activity;

/**
 * 时间选择器
 */
public class TimePicker extends DateTimePicker {

    /**
     * Instantiates a new Time picker.
     *
     * @param activity the activity
     */
    public TimePicker(Activity activity) {
        this(activity, HOUR_24);
    }

    /**
     * Instantiates a new Time picker.
     *
     * @param activity the activity
     * @param mode     the mode
     * @see #HOUR_24 #HOUR_24
     * @see #HOUR_12 #HOUR_12
     */
    public TimePicker(Activity activity, @TimeMode int mode) {
        super(activity, NONE, mode);
    }

    /**
     * @deprecated use {@link #setLabel(String, String)} instead
     */
    @Deprecated
    @Override
    public final void setLabel(String yearLabel, String monthLabel, String dayLabel, String hourLabel, String minuteLabel) {
        super.setLabel(yearLabel, monthLabel, dayLabel, hourLabel, minuteLabel);
    }

    /**
     * 设置时间显示的单位
     *
     * @param hourLabel   the hour label
     * @param minuteLabel the minute label
     */
    public void setLabel(String hourLabel, String minuteLabel) {
        super.setLabel("", "", "", hourLabel, minuteLabel);
    }

    /**
     * @deprecated nonsupport
     */
    @Deprecated
    @Override
    public final void setDateRangeStart(int startYear, int startMonth, int startDay) {
        throw new UnsupportedOperationException("Date range nonsupport");
    }

    /**
     * @deprecated nonsupport
     */
    @Deprecated
    @Override
    public final void setDateRangeEnd(int endYear, int endMonth, int endDay) {
        throw new UnsupportedOperationException("Date range nonsupport");
    }

    /**
     * @deprecated nonsupport
     */
    @Deprecated
    @Override
    public final void setDateRangeStart(int startYearOrMonth, int startMonthOrDay) {
        throw new UnsupportedOperationException("Date range nonsupport");
    }

    /**
     * @deprecated nonsupport
     */
    @Deprecated
    @Override
    public final void setDateRangeEnd(int endYearOrMonth, int endMonthOrDay) {
        throw new UnsupportedOperationException("Data range nonsupport");
    }

    /**
     * @deprecated use {@link #setRangeStart(int, int)} instead
     */
    @Deprecated
    @Override
    public void setTimeRangeStart(int startHour, int startMinute) {
        super.setTimeRangeStart(startHour, startMinute);
    }

    /**
     * @deprecated use {@link #setRangeEnd(int, int)} instead
     */
    @Deprecated
    @Override
    public void setTimeRangeEnd(int endHour, int endMinute) {
        super.setTimeRangeEnd(endHour, endMinute);
    }

    /**
     * @deprecated use setRangeStart and setRangeEnd instead
     */
    @Deprecated
    public void setRange(int startHour, int endHour) {
        super.setTimeRangeStart(startHour, 0);
        super.setTimeRangeEnd(endHour, 59);
    }


    /**
     * 设置范围：开始的时分
     *
     * @param startHour   the start hour
     * @param startMinute the start minute
     */
    public void setRangeStart(int startHour, int startMinute) {
        super.setTimeRangeStart(startHour, startMinute);
    }

    /**
     * 设置范围：结束的时分
     *
     * @param endHour   the end hour
     * @param endMinute the end minute
     */
    public void setRangeEnd(int endHour, int endMinute) {
        super.setTimeRangeEnd(endHour, endMinute);
    }

    /**
     * @deprecated use {@link #setSelectedItem(int, int)} instead
     */
    @Deprecated
    @Override
    public final void setSelectedItem(int year, int month, int day, int hour, int minute) {
        super.setSelectedItem(year, month, day, hour, minute);
    }

    /**
     * @deprecated use {@link #setSelectedItem(int, int)} instead
     */
    @Deprecated
    @Override
    public final void setSelectedItem(int yearOrMonth, int monthOrDay, int hour, int minute) {
        super.setSelectedItem(yearOrMonth, monthOrDay, hour, minute);
    }

    /**
     * 设置默认选中的时间
     *
     * @param hour   the hour
     * @param minute the minute
     */
    public void setSelectedItem(int hour, int minute) {
        super.setSelectedItem(0, 0, hour, minute);
    }

    /**
     * @deprecated use {@link #setOnWheelListener(OnWheelListener)} instead
     */
    @Deprecated
    @Override
    public final void setOnWheelListener(DateTimePicker.OnWheelListener onWheelListener) {
        super.setOnWheelListener(onWheelListener);
    }

    /**
     * 设置滑动监听器
     *
     * @param listener the listener
     */
    public void setOnWheelListener(final OnWheelListener listener) {
        if (null == listener) {
            return;
        }
        super.setOnWheelListener(new DateTimePicker.OnWheelListener() {
            @Override
            public void onYearWheeled(int index, String year) {
            }

            @Override
            public void onMonthWheeled(int index, String month) {
            }

            @Override
            public void onDayWheeled(int index, String day) {
            }

            @Override
            public void onHourWheeled(int index, String hour) {
                listener.onHourWheeled(index, hour);
            }

            @Override
            public void onMinuteWheeled(int index, String minute) {
                listener.onMinuteWheeled(index, minute);
            }

            @Override
            public void onSecondWheeled(int index, String second) {
                listener.onMinuteWheeled(index, second);
            }
        });
    }

    /**
     * @deprecated use {@link #setOnTimePickListener(OnTimePickListener)} instead
     */
    @Deprecated
    @Override
    public final void setOnDateTimePickListener(OnDateTimePickListener listener) {
        super.setOnDateTimePickListener(listener);
    }

    /**
     * Sets on time pick listener.
     *
     * @param listener the listener
     */
    public void setOnTimePickListener(final OnTimePickListener listener) {
        if (null == listener) {
            return;
        }
        super.setOnDateTimePickListener(new DateTimePicker.OnTimePickListener() {
            @Override
            public void onDateTimePicked(String hour, String minute, String second) {
                listener.onTimePicked(hour, minute, second);
            }
        });
    }

    /**
     * The interface On time pick listener.
     */
    public interface OnTimePickListener {

        /**
         * On time picked.
         *
         * @param hour   the hour
         * @param minute the minute
         * @param second the second
         */
        void onTimePicked(String hour, String minute, String second);

    }

    /**
     * The interface On wheel listener.
     */
    public interface OnWheelListener {

        /**
         * On hour wheeled.
         *
         * @param index the index
         * @param hour  the hour
         */
        void onHourWheeled(int index, String hour);

        /**
         * On minute wheeled.
         *
         * @param index  the index
         * @param minute the minute
         */
        void onMinuteWheeled(int index, String minute);

        /**
         * On second wheeled.
         *
         * @param index  the index
         * @param second the second
         */
        void onSecondWheeled(int index, String second);
    }

}
