package com.supcon.common.view.view.picker;

import android.app.Activity;

/**
 * 数字选择器
 */
public class NumberPicker extends SinglePicker<Number> {

    /**
     * Instantiates a new Number picker.
     *
     * @param activity the activity
     */
    public NumberPicker(Activity activity) {
        super(activity, new Number[]{});
    }

    /**
     * 设置数字范围，递增量为1
     *
     * @param startNumber the start number
     * @param endNumber   the end number
     */
    public void setRange(int startNumber, int endNumber) {
        setRange(startNumber, endNumber, 1);
    }

    /**
     * 设置数字范围及递增量
     *
     * @param startNumber the start number
     * @param endNumber   the end number
     * @param step        the step
     */
    public void setRange(int startNumber, int endNumber, int step) {
        for (int i = startNumber; i <= endNumber; i = i + step) {
            addItem(i);
        }
    }

    /**
     * 设置数字范围及递增量
     *
     * @param startNumber the start number
     * @param endNumber   the end number
     * @param step        the step
     */
    public void setRange(double startNumber, double endNumber, double step) {
        for (double i = startNumber; i <= endNumber; i = i + step) {
            addItem(i);
        }
    }

    /**
     * 设置默认选中的数字
     *
     * @param number the number
     */
    public void setSelectedItem(int number) {
        super.setSelectedItem(number);
    }

    /**
     * 设置默认选中的数字
     *
     * @param number the number
     */
    public void setSelectedItem(double number) {
        super.setSelectedItem(number);
    }

    /**
     * Sets on number pick listener.
     *
     * @param listener the listener
     */
    public void setOnNumberPickListener(OnNumberPickListener listener) {
        super.setOnItemPickListener(listener);
    }

    /**
     * Sets on option pick listener.
     *
     * @param listener the listener
     * @deprecated use {@link #setOnNumberPickListener(OnNumberPickListener)} instead
     */
    @Deprecated
    public void setOnOptionPickListener(final OptionPicker.OnOptionPickListener listener) {
        setOnNumberPickListener(new OnNumberPickListener() {
            @Override
            public void onNumberPicked(int index, Number item) {
                listener.onOptionPicked(index, item.toString());
            }
        });
    }

    /**
     * Sets on wheel listener.
     *
     * @param onWheelListener the on wheel listener
     */
    public void setOnWheelListener(OnWheelListener onWheelListener) {
        super.setOnWheelListener(onWheelListener);
    }

    /**
     * The interface On wheel listener.
     */
    public interface OnWheelListener extends SinglePicker.OnWheelListener<Number> {

    }

    /**
     * The type On number pick listener.
     */
    public static abstract class OnNumberPickListener implements OnItemPickListener<Number> {

        /**
         * On number picked.
         *
         * @param index the index
         * @param item  the item
         */
        public abstract void onNumberPicked(int index, Number item);

        @Override
        public final void onItemPicked(int index, Number item) {
            onNumberPicked(index, item);
        }

    }

}

