package com.supcon.common.view.base.fragment;

import com.supcon.common.view.base.adapter.IListAdapter;
import com.supcon.common.view.base.controller.IRefreshListController;
import com.supcon.common.view.listener.OnRefreshListener;
import com.supcon.common.view.listener.OnRefreshPageListener;

/**
 * Created by wangshizhan on 16/12/1.
 *
 * @param <TModel> the type parameter
 */
public abstract  class BaseRefreshListFragment<TModel> extends BaseControllerFragment {

    /**
     * The Refresh list controller.
     */
    protected IRefreshListController<TModel> refreshListController;

    private static final String _RefreshListController = "RefreshListController";


    @Override
    protected void onRegisterController() {
        super.onRegisterController();
        registerController(_RefreshListController, createRefreshListController());
    }

    /**
     * Create refresh list controller refresh list controller.
     *
     * @return the refresh list controller
     */
    abstract protected IRefreshListController createRefreshListController();

    /**
     * 设置分页刷新监听 自动启用分页模式
     *
     * @param onRefreshPageListener the on refresh page listener
     */
    public void setOnRefreshPageListener(OnRefreshPageListener onRefreshPageListener) {
        refreshListController.setOnRefreshPageListener(onRefreshPageListener);
    }

    /**
     * Sets on refresh listener.
     *
     * @param onRefreshListener the on refresh listener
     */
    public void setOnRefreshListener(OnRefreshListener onRefreshListener) {
        refreshListController.setOnRefreshListener(onRefreshListener);
    }

    /**
     * Create adapter list adapter.
     *
     * @return the list adapter
     */
    protected abstract IListAdapter<TModel> createAdapter();
}
